<?php
/**
 * 
 * Wheremancy
 * 
 * 　WHERE句を生成するためのビルダー。
 * 
 * PHP version 5
 * @package Daomancy
 * @version Release: 0.1.0
 * @author y.terrashima
 */
require_once 'WheremancyLiteral.php';

class Wheremancy
{
	//次のWheremancyにつなげる条件
	protected $conjunction = ' AND ';
	//WHERE句（String）
	protected $where = '';
	//プリペアドステートメントに渡す引数
	protected $params = array();
	//後に続くWheremancy
	protected $next;
	
	
	//////////////////////////////////////////////////////////////////////
	//	コンストラクタ・ファクトリ
	//////////////////////////////////////////////////////////////////////
	protected function __construct($where , $params = array())
	{
		if(!is_object($where)) {
			$this->where = &$where;
			$this->params = (array)$params;
		} else {
			$this->next = $where;
		}
	}
	
	public static function &_($where , $params = array())
	{
		$where = new self($where , $params);
		return $where;
	}
	
	public static function &where($where , $params = array())
	{
		return self::_($where , $params);
	}
	
	/**
	 * IN
	 * @param カラム名
	 * @param 引数
	 */
	public static function &in($col , $params = array())
	{
		$params = array_unique($params);
		if(!$params) {
			return self::_(null , null);
		}
		$where = $col . ' IN('
			. join(',' , array_fill(0 , count($params) , '?'))
			. ') ';
		return self::_($where , $params);
	}
	
	/**
	 * IS NULL
	 * @param カラム名
	 */
	public static function isNull($col)
	{
		return new WheremancyLiteral("{$col} IS NULL");
	}
	
	/**
	 * IS NOT NULL
	 * @param カラム名
	 */
	public static function isNotNull($col)
	{
		return new WheremancyLiteral("{$col} IS NOT NULL");
	}
	
	
	//////////////////////////////////////////////////////////////////////
	//	公開メソッド
	//////////////////////////////////////////////////////////////////////
	
	/**
	 * AND
	 * @param SQL または Wheremancyオブジェクト
	 * @param SQL文字列の場合のみ。プレースホルダ?に渡す引数
	 */
	public function &and_($where , $params = array())
	{
		if(!$this->next) {
			$this->next = &self::_($where , $params);
		} else {
			$this->next->and_($where , $params);
		}
		return $this;
	}
	
	/**
	 * OR
	 * @param SQL または Wheremancyオブジェクト
	 * @param SQL文字列の場合のみ。プレースホルダ?に渡す引数
	 */
	public function &or_($where , $params = array())
	{
		if(!$this->next) {
			$this->next = &self::_($where , $params);
			$this->conjunction = ' OR ';
		} else {
			$this->next->or_($where , $params);
		}
		return $this;
	}
	
	/**
	 * SQL生成
	 */
	public function toSQL($isRoot = true)
	{
		$sql = '';
		$thisSql = '';
		$conjunction = '';
		$nextSql = '';
		if($this->where && $this->params) {
			$thisSql = $this->where;
		}
		if($this->next) {
			$nextSql = $this->next->toSQL(false);
			if(!$this->where && preg_match('/( AND | OR )/' , $nextSql)) {
				$nextSql = '(' . $nextSql . ')';
			}
		}
		if($thisSql && $nextSql) {
			$conjunction = $this->_getConjunction();
		}
		if($isRoot) {
			$sql = ' WHERE ';
		}
		$sql .= $thisSql . $conjunction . $nextSql;
		
		return $sql;
	}
	
	/**
	 * 指定されたSQL引数を適用順にすべて取得
	 */
	public function getParams()
	{
		$params = $this->params;
		if($this->next) {
			$params = array_merge($params , $this->next->getParams());
		}
		return $params;
	}
	
	
	//////////////////////////////////////////////////////////////////////
	//	内部メソッド
	//////////////////////////////////////////////////////////////////////
	protected function _getConjunction()
	{
		if(!($this->next->where && $this->next->params)) {
			return $this->next->_getConjunction();
		}
		return $this->conjunction;
	}
	
}


?>