<?php
/**
 * 
 * Fromancy
 * 
 * 　FROM句、JOIN句を生成するためのビルダー。
 * 
 * PHP version 5
 * @package Daomancy
 * @version Release: 0.1.0
 * @author y.terrashima
 */

class Fromancy
{
	public $from = array();
	
	//////////////////////////////////////////////////////////////////////
	//	コンストラクタ・ファクトリ
	//////////////////////////////////////////////////////////////////////
	public function __construct($class , $as = null , $fetch = true)
	{
		$this->join($class , $as , $fetch);
	}
	
	public static function &_($class , $as = null , $fetch = true)
	{
		$ret = new self($class , $as , $fetch);
		return $ret;
	}
	
	public static function &from($class , $as = null , $fetch = true)
	{
		$ret = new self($class , $as , $fetch);
		return $ret;
	}
	
	
	//////////////////////////////////////////////////////////////////////
	//	公開メソッド
	//////////////////////////////////////////////////////////////////////
	public function &join($class , $as = null , $fetch = true)
	{
		if(is_null($as)) {
			$as = $class;
		}
		$this->from[] = (object)array(
			'class' => $class ,
			'as' => $as ,
			'method' => 'inner' ,
			'fetch' => $fetch ,
			'on' => ''
		);
		return $this;
	}
	
	public function &leftJoin($class , $as = null , $fetch = true)
	{
		if(is_null($as)) {
			$as = $class;
		}
		$this->from[] = (object)array(
			'class' => $class ,
			'as' => $as ,
			'method' => 'left' ,
			'fetch' => $fetch ,
			'on' => ''
		);
		return $this;
	}
	
	public function &rightJoin($class , $as = null , $fetch = true)
	{
		if(is_null($as)) {
			$as = $class;
		}
		$this->from[] = (object)array(
			'class' => $class ,
			'as' => $as ,
			'method' => 'right' ,
			'fetch' => $fetch ,
			'on' => ''
		);
		return $this;
	}
	
	public function &on($on)
	{
		$this->from[count($this->from) -1]->on = $on;
		return $this;
	}
	
	public function &and_($on)
	{
		$this->from[count($this->from) -1]->on .= ' AND ' . $on;
		return $this;
	}
	
	public function toSQL()
	{
		$sql = 'SELECT ' . $this->_getSelectSQL()
			. ' FROM ' . $this->_getFromSQL()
		;
		return $sql;
	}
	
	
	//////////////////////////////////////////////////////////////////////
	//	内部メソッド
	//////////////////////////////////////////////////////////////////////
	protected function _getSelectSQL()
	{
		$arr = array();
		foreach($this->from as $from) {
			if(!$from->fetch) continue;
			$dummy = new $from->class();
			foreach($dummy->cols as $col) {
				$arr[] = $from->as . '.' . $col;
			}
		}
		return join(',' , $arr);
	}
	
	protected function _getFromSQL()
	{
		$froms = $this->from;
		$from = array_shift($froms);
		$dummy = new $from->class();
		$sql = $dummy->table . ' ' . $from->as;
		while($from = array_shift($froms)) {
			$dummy = new $from->class();
			
			switch($from->method) {
				case 'left' :
					$sql .= ' LEFT OUTER JOIN ';
					break;
				case 'right' :
					$sql .= ' RIGHT OUTER JOIN ';
					break;
				default :
					$sql .= ' INNER JOIN ';
					break;
			}
			$sql .= $dummy->table
				. ' ' . $from->as
				. ' ON ' . $from->on
			;
		}
		return $sql;
	}
	
}


?>