<?php
/**
 * 
 * DaomancyRecord
 * 
 * 　各テーブルごとのDAO（アクティブレコード）の親クラス。
 * 　テーブル一個分以上の仕事を担当させることは想定してません。
 * 　とりあえず$table,$cols,$primaryKeysを子クラスで上書けば動きます。
 * 　テーブル行に関連するロジックをてきとうにメソッドで実装できます。
 * 
 * PHP version 5
 * @package Daomancy
 * @version Release: 0.1.0
 * @author y.terrashima
 */

class DaomancyRecord
{
	//DBハンドル（PDO）
	public $dbh;
	
	//テーブル名
	public $table;
	//SELECTで取得するカラム
	public $cols = array();
	//プライマリキー
	public $primaryKey = array();
	
	//////////////////////////////////////////////////////////////////////
	//	コンストラクタ・ファクトリ
	//////////////////////////////////////////////////////////////////////
	public function __construct(&$dbh = null)
	{
		$this->dbh = &$dbh;
	}
	
	
	//////////////////////////////////////////////////////////////////////
	//	メンバ変数アクセスのオーバーライド
	//////////////////////////////////////////////////////////////////////
	public function __set($k , $v)
	{
		if(in_array($k , $this->cols)) {
			$this->{$k} = $v;
		}
	}
	
	public function __get($k)
	{
		if(in_array($k , $this->cols)) {
			return $this->{$k};
		}
	}
	
	
	//////////////////////////////////////////////////////////////////////
	//	公開メソッド
	//////////////////////////////////////////////////////////////////////
	public static function find($dbh , $class , $where , $params = null)
	{
		if(is_object($where)) {
			$where = $where->toSQL();
			$params = $where->getParams();
		} else {
			$where = "WHERE {$where} ";
		}
		$select = 'SELECT ' . join(',' , $this->cols)
			. ' FROM ' . $table
			. $where
		;
		$sth = $dbh->query($sql);
		$sth->setFetchMode(PDO::FETCH_CLASS , $class);
		$sth->execute($params);
		
		$ret = $sth->fetchAll();
		foreach($ret as $v) {
			$v->dbh = &$dbh;
		}
		return $ret;
	}
	
	public function update()
	{
		$sets = array();
		$params = array();
		$wheres = array();
		$whereParams = array();
		foreach($this as $k => $v) {
			if(in_array($k , $this->cols)) {
				if(!in_array($k , $this->primaryKey)) {
					$sets[] = "{$k} = ?";
					$params[] = $v;
				} else {
					$wheres[] = "{$k} = ?";
					$whereParams[] = $v;
				}
			}
		}
		$sql = "UPDATE {$this->table} SET "
			. join(',' , $sets)
			. " WHERE "
			. join(' AND ' , $wheres)
		;
		$sth = $this->dbh->prepare($sql);
		$sth->execute(array_merge($params , $whereParams));
		if($sth->rowCount() == 1) {
			return true;
		} else {
			return false;
		}
	}
	
	public function insert()
	{
		$into = array();
		$params = array();
		foreach($this as $k => $v) {
			if(in_array($k , $this->cols)) {
				$into[] = $k;
				$params[] = $v;
			}
		}
		$sql = "INSERT INTO {$this->table}("
			. join(',' , $into)
			. ') VALUES ('
			. join(',' , array_fill(0 , count($params) , '?'))
			. ')';
		$sth = $this->dbh->prepare($sql);
		$sth->execute($params);
		if($sth->rowCount() == 1) {
			return true;
		} else {
			return false;
		}
	}
	
	public function delete()
	{
		$wheres = array();
		$params = array();
		foreach($this as $k => $v) {
			if(in_array($k , $this->primaryKey)) {
				$wheres[] = "{$k} = ?";
				$params[] = $v;
			}
		}
		$sql = "DELETE FROM {$this->table} WHERE "
			. join(' AND ' , $wheres)
		;
		$sth = $this->dbh->prepare($sql);
		$sth->execute($params);
		if($sth->rowCount() == 1) {
			return true;
		} else {
			return false;
		}
	}
	
}

?>