/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl.data;

import jp.sourceforge.damstation_dl.data.SongId;

public class ResultData2 {
    private final SongId id;
    private final double score;
    private final byte vibratoType;
    private final double vibratoTime;
    private final short shakuri;
    private final short kobushi;
    private final short fall;
    private final byte interval;
    private final byte lowTone;
    private final byte highTone;
    private final byte vibratoSkill;
    private final byte longTone;
    private final byte modulation;
    private final byte rhythm;

    public ResultData2(SongId id, double score, int vibratoType, double vibratoTime, int shakuri, int kobushi, int fall, int interval, int lowTone, int highTone, int vibratoSkill, int longTone, int modulation, int rhythm) {
        if (id == null) {
            throw new NullPointerException("ResultData2.ResultData2\n\tid=" + id);
        }
        if (!ResultData2.isValidScore(score)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 score is invalid.\n\tscore=" + score);
        }
        if (!ResultData2.isValidVibratoType(vibratoType)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 vibratoType is invalid.\n\tvibratoType=" + vibratoType);
        }
        if (!ResultData2.isValidVibratoTime(vibratoTime)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 vibratoTime is invalid.\n\tvibratoTime=" + vibratoTime);
        }
        if (!ResultData2.isValidShakuri(shakuri)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 shakuri is invalid.\n\tshakuri=" + shakuri);
        }
        if (!ResultData2.isValidKobushi(kobushi)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 shakuri is invalid.\n\tkobushi=" + kobushi);
        }
        if (!ResultData2.isValidFall(fall)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 shakuri is invalid.\n\tfall=" + fall);
        }
        if (!ResultData2.isValidInterval(interval)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 interval is invalid.\n\tinterval=" + interval);
        }
        if (!ResultData2.isValidLowTone(lowTone)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 lowTone is invalid.\n\tlowTone=" + lowTone);
        }
        if (!ResultData2.isValidHighTone(highTone)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 highTone is invalid.\n\thighTone=" + highTone);
        }
        if (!ResultData2.isValidVibratoSkill(vibratoSkill)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 vibratoSkill is invalid.\n\tvibratoSkill=" + vibratoSkill);
        }
        if (!ResultData2.isValidLongTone(longTone)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 longTone is invalid.\n\tlongTone=" + longTone);
        }
        if (!ResultData2.isValidModulation(modulation)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 modulation is invalid.\n\tmodulation=" + modulation);
        }
        if (!ResultData2.isValidRhythm(rhythm)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 rhythm is invalid.\n\trhythm=" + rhythm);
        }
        this.id = id;
        this.score = score;
        this.vibratoType = (byte)vibratoType;
        this.vibratoTime = vibratoTime;
        this.shakuri = (short)shakuri;
        this.kobushi = (short)kobushi;
        this.fall = (short)fall;
        this.interval = (byte)interval;
        this.lowTone = (byte)lowTone;
        this.highTone = (byte)highTone;
        this.vibratoSkill = (byte)vibratoSkill;
        this.longTone = (byte)longTone;
        this.rhythm = (byte)rhythm;
        this.modulation = (byte)modulation;
    }

    public short getFall() {
        return this.fall;
    }

    public byte getHighTone() {
        return this.highTone;
    }

    public short getKobushi() {
        return this.kobushi;
    }

    public byte getLongTone() {
        return this.longTone;
    }

    public byte getLowTone() {
        return this.lowTone;
    }

    public byte getVibratoSkill() {
        return this.vibratoSkill;
    }

    public SongId getId() {
        return this.id;
    }

    public byte getInterval() {
        return this.interval;
    }

    public byte getModulation() {
        return this.modulation;
    }

    public byte getRhythm() {
        return this.rhythm;
    }

    public double getScore() {
        return this.score;
    }

    public short getShakuri() {
        return this.shakuri;
    }

    public double getVibratoTime() {
        return this.vibratoTime;
    }

    public byte getVibratoType() {
        return this.vibratoType;
    }

    public static boolean isValidScore(double score) {
        return !(score < 0.0) && !(score > 100.0);
    }

    public static boolean isValidInterval(int interval) {
        return interval >= 0 && interval <= 100;
    }

    public static boolean isValidVibratoTime(double vibratoTime) {
        return !(vibratoTime < 0.0);
    }

    public static boolean isValidVibratoType(int vibratoType) {
        return vibratoType >= 0 && vibratoType <= 9;
    }

    public static boolean isValidShakuri(int shakuri) {
        return shakuri >= 0 && shakuri <= Short.MAX_VALUE;
    }

    public static boolean isValidKobushi(int kobushi) {
        return kobushi >= 0 && kobushi <= Short.MAX_VALUE;
    }

    public static boolean isValidFall(int fall) {
        return fall >= 0 && fall <= Short.MAX_VALUE;
    }

    public static boolean isValidLowTone(int lowTone) {
        return lowTone >= 1 && lowTone <= 4;
    }

    public static boolean isValidHighTone(int highTone) {
        return highTone >= 1 && highTone <= 4;
    }

    public static boolean isValidVibratoSkill(int vibratoSkill) {
        return vibratoSkill >= 0 && vibratoSkill <= 10;
    }

    public static boolean isValidLongTone(int longTone) {
        return longTone >= 0 && longTone <= 10;
    }

    public static boolean isValidModulation(int modulation) {
        return modulation >= 0 && modulation <= 10;
    }

    public static boolean isValidRhythm(int rhythm) {
        return rhythm >= -3 && rhythm <= 3;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{id=");
        buffer.append(this.id);
        buffer.append(", score=");
        buffer.append(this.score);
        buffer.append(", vibratoType=");
        buffer.append(this.vibratoType);
        buffer.append(", vibratoTime=");
        buffer.append(this.vibratoTime);
        buffer.append(", shakuri=");
        buffer.append(this.shakuri);
        buffer.append(", kobushi=");
        buffer.append(this.kobushi);
        buffer.append(", fall=");
        buffer.append(this.fall);
        buffer.append(", interval=");
        buffer.append(this.interval);
        buffer.append(", lowTone=");
        buffer.append(this.lowTone);
        buffer.append(", highTone=");
        buffer.append(this.highTone);
        buffer.append(", vibratoSkill=");
        buffer.append(this.vibratoSkill);
        buffer.append(", longTone=");
        buffer.append(this.longTone);
        buffer.append(", modulation=");
        buffer.append(this.modulation);
        buffer.append(", rhythm=");
        buffer.append(this.rhythm);
        buffer.append("}");
        return buffer.toString();
    }
}

