/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.whereaboutsboard;


import java.util.ArrayList;
import java.util.List;

import com.aimluck.commons.field.ALStringField;


/**
 * 行先板のResultData（名前と場所）です（画面の一覧の1行に対応）。 <br />
 */
public class WhereaboutsboardGroupContainer  {

  /** 名前 */
  private ALStringField name = null;
  
  /** 居場所リスト */
  private List<WhereaboutsboardGroupResultData> places = null;

  /**
   * @see com.aimluck.eip.common.ALData#initField()
   */
  // オブジェクトのフィールドを初期化するメソッドです。
  public void initField() {
    name = new ALStringField();
    places = new ArrayList<WhereaboutsboardGroupResultData>();
  }

  // 以下getとset
  /**
   * @return
   */
  public ALStringField getName() {
    return name;
  }

  /**
   * @return
   */
  public List<WhereaboutsboardGroupResultData> getPlaces() {
    return places;
  }

  /**
   * @param field
   */
  public void setName(String field) {
    name.setValue(field);
  }

  /**
   * @param field
   */
  public void setPlaces(List<WhereaboutsboardGroupResultData> p) {
    places = p;
  }

}
