/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.util.Calendar;
import net.fortuna.ical4j.util.Numbers;

public class WeekDay
implements Serializable {
    private static final long serialVersionUID = -4412000990022011469L;
    public static final WeekDay SU = new WeekDay("SU", 0);
    public static final WeekDay MO = new WeekDay("MO", 0);
    public static final WeekDay TU = new WeekDay("TU", 0);
    public static final WeekDay WE = new WeekDay("WE", 0);
    public static final WeekDay TH = new WeekDay("TH", 0);
    public static final WeekDay FR = new WeekDay("FR", 0);
    public static final WeekDay SA = new WeekDay("SA", 0);
    private String day;
    private int offset;

    public WeekDay(String value) {
        this.offset = value.length() > 2 ? Numbers.parseInt(value.substring(0, value.length() - 2)) : 0;
        this.day = value.substring(value.length() - 2);
    }

    public WeekDay(String day, int offset) {
        this.day = day;
        this.offset = offset;
    }

    public WeekDay(WeekDay weekDay, int offset) {
        this.day = weekDay.getDay();
        this.offset = offset;
    }

    public final String getDay() {
        return this.day;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        if (this.getOffset() != 0) {
            b.append(this.getOffset());
        }
        b.append(this.getDay());
        return b.toString();
    }

    public static final WeekDay getWeekDay(Calendar cal) {
        return new WeekDay(WeekDay.getDay(cal.get(7)), 0);
    }

    public static final WeekDay getMonthlyOffset(Calendar cal) {
        return new WeekDay(WeekDay.getDay(cal.get(7)), cal.get(8));
    }

    public static final WeekDay getNegativeMonthlyOffset(Calendar cal) {
        return new WeekDay(WeekDay.getDay(cal.get(7)), cal.get(8) - 6);
    }

    private static WeekDay getDay(int calDay) {
        switch (calDay) {
            case 1: {
                return SU;
            }
            case 2: {
                return MO;
            }
            case 3: {
                return TU;
            }
            case 4: {
                return WE;
            }
            case 5: {
                return TH;
            }
            case 6: {
                return FR;
            }
            case 7: {
                return SA;
            }
        }
        return null;
    }

    public static int getCalendarDay(WeekDay weekday) {
        if (SU.getDay().equals(weekday.getDay())) {
            return 1;
        }
        if (MO.getDay().equals(weekday.getDay())) {
            return 2;
        }
        if (TU.getDay().equals(weekday.getDay())) {
            return 3;
        }
        if (WE.getDay().equals(weekday.getDay())) {
            return 4;
        }
        if (TH.getDay().equals(weekday.getDay())) {
            return 5;
        }
        if (FR.getDay().equals(weekday.getDay())) {
            return 6;
        }
        if (SA.getDay().equals(weekday.getDay())) {
            return 7;
        }
        return -1;
    }

    public final boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof WeekDay)) {
            return false;
        }
        WeekDay wd = (WeekDay)arg0;
        return wd.getDay().equals(this.getDay()) && wd.getOffset() == this.getOffset();
    }

    public final int hashCode() {
        return this.getDay().hashCode() + this.getOffset();
    }
}

