/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.screens;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import net.sf.json.JSONObject;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.extcabinet.ExtFolderInfo;
import com.aimluck.eip.extcabinet.beans.ExtCabinetBean;
import com.aimluck.eip.extcabinet.util.ExtCabinetUtils;

/**
 * 文書管理のフォルダをJSONデータとして出力するクラスです。 <br />
 * 
 */
public class ExtCabinetJSONScreen extends ALJSONScreen {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(ExtCabinetJSONScreen.class.getName());

  protected String getJSONString(RunData rundata, Context context)
      throws Exception {
    String result = "";

    ExtCabinetBean bean = null;
    List<ExtCabinetBean> beanitems = new ArrayList<ExtCabinetBean>();
    try {
    	List<ExtFolderInfo> folders = ExtCabinetUtils.getFolderList(ExtCabinetUtils.ROOT_PARENT_FODLER_ID);
      if (folders != null && folders.size() > 0) {
        int folderssize = folders.size();
        for (int i = 0; i < folderssize; i++) {
          ExtFolderInfo folder = (ExtFolderInfo) folders.get(i);
          if (folder.getFolderId() == 1) {
            // ルートフォルダのBeanは作らない
            continue;
          }
          bean = new ExtCabinetBean();
          bean.initField();
          bean.setCabinetId(folder.getFolderId());
          bean.setCabinetName(folder.getFolderName());
          bean.settype(folder.getHierarchyIndex());
          // child要素を検索
          for (int j = 0; j < folderssize; j++) {
            ExtFolderInfo folder_child = (ExtFolderInfo) folders.get(j);
            if (folder_child.getParentFolderId() == folder.getFolderId()) {
              Hashtable<String, String> hash = new Hashtable<String, String>();
              hash.put("_reference", folder_child.getFolderName());
              bean.getchildren().add(hash);
            }
          }
          beanitems.add(bean);
        }
      }

      JSONObject json = new JSONObject();
      List<ExtCabinetBean> jsonlist = new ArrayList<ExtCabinetBean>();
      int beansize = beanitems.size();
      for (int i = 0; i < beansize; i++) {
        jsonlist.add(beanitems.get(i));
      }
      json.put("items", jsonlist);
      json.put("identifier", "cabinetName");
      json.put("label", "cabinetName");

      result = json.toString();

    } catch (Exception e) {
      logger.error("[ERROR]", e);
    }

    return result;
  }

}
