/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.util.ArrayList;
import net.sf.json.JSONArray;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.lunchorder.LunchOrderInputFormData;



/**
 * 注文入力内容をJSONデータとして出力するクラスです。ココでは入力値チェックだけのクラスです。
 * insert,updata,の処理は行わない。 <br />
 * 
 */
public class LunchOrderInputFormJSONScreen extends ALJSONScreen {
  /** logger  */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(LunchOrderInputFormJSONScreen.class.getName());

  @Override
  protected String getJSONString(RunData rundata, Context context)
      throws Exception {
    String result = new JSONArray().toString();
    try {
      LunchOrderInputFormData formData = new LunchOrderInputFormData();
      formData.initField(rundata);//フィールド初期化
      boolean res = formData.doCheack(this, rundata, context);//入力値チェック
      if(res){//エラーメッセ時がなければ確認画面へ遷移
        ArrayList list = (ArrayList) context
        .get(ALEipConstants.ERROR_MESSAGE_LIST); 
      JSONArray json = JSONArray.fromObject(list);
      result = json.toString();
    }else{//エラーがある場合はJSON文字列を返す。
        ArrayList list = (ArrayList) context
        .get(ALEipConstants.ERROR_MESSAGE_LIST); 
      JSONArray json = JSONArray.fromObject(list);
      result = json.toString();
      }
        
    }catch (Exception e) {
      logger.error("[LunchOrderInpuｔFormJSONScreen]", e);
    }
    return result;
  }
}
  


