//**********************************************************************
// setup.js : Copyright 2009 BEKISYS Inc.
//**********************************************************************
var DIR_FULL_PATH_INSTALL = 
  Common_objWScriptShell.CurrentDirectory
    + Common_CHAR_DIR_SEPARATOR
;

var DIR_FULL_PATH_MY_APP_DATA = "";
var FILE_FULL_PATH_STATUS = "";
var FILE_FULL_PATH_FILE_NAME = "";
var FILE_FULL_PATH_OUTPUT_DIR = "";
var FILE_FULL_PATH_SECOND_KEY = "";


try
{
  DIR_FULL_PATH_MY_APP_DATA = Common_GetDirFullPathMyAppData_IfNotExistsThenCreate();
  FILE_FULL_PATH_STATUS = 
    Common_objFso.BuildPath(DIR_FULL_PATH_MY_APP_DATA, Common_DIR_NAME_TEMP)
      + Common_CHAR_DIR_SEPARATOR
      + Common_FILE_NAME_STATUS
  ;
  FILE_FULL_PATH_FILE_NAME = 
    Common_objFso.BuildPath(DIR_FULL_PATH_MY_APP_DATA, Common_DIR_NAME_TEMP)
      + Common_CHAR_DIR_SEPARATOR
      + Common_FILE_NAME_FILE_NAME
  ;
  FILE_FULL_PATH_OUTPUT_DIR = Common_objFso.BuildPath(DIR_FULL_PATH_MY_APP_DATA, Common_FILE_NAME_OUTPUT_DIR);
  FILE_FULL_PATH_SECOND_KEY = Common_objFso.BuildPath(DIR_FULL_PATH_MY_APP_DATA, Common_FILE_NAME_SECOND_KEY);

  MainProcess();
}
catch(m_Error)
{
  if(m_Error instanceof ClassCustomError)
  {
    Common_objWScriptShell.popup(
      m_Error.description,
      0,
      Common_TEXT_POPUP_TITLE,
      Common_POPUP_TYPE_CRITICAL
    );
  }
  else
  {
    throw m_Error;
  }

}


function MainProcess()
{
  if(Common_SetupOutputdir(FILE_FULL_PATH_OUTPUT_DIR) == "")
  {
    //Is there need to change?
    if(!IsValidOutputDir(FILE_FULL_PATH_OUTPUT_DIR))
    {
      Common_objWScriptShell.popup(
        "Cancelled", 
        Common_POPUP_CLOSE_SECOND_DEFAULT, 
        Common_TEXT_POPUP_TITLE,
        Common_POPUP_TYPE_EXCLAMATION
      );
      WScript.Quit();
    }
  }
  
  CopyAndSetupShortcutForScript(
    Common_objSpecialFolders.Item(Common_SPECIAL_FOLDER_NAME_SENDTO)
      + Common_CHAR_DIR_SEPARATOR
  );

  CopyAndSetupShortcutForScript(
    Common_objSpecialFolders.Item(Common_SPECIAL_FOLDER_NAME_DESKTOP)
      + Common_CHAR_DIR_SEPARATOR
  );

  if(!Common_objFso.FileExists(FILE_FULL_PATH_SECOND_KEY))
  {
    MakeFileSecondKey();

    DuplicateFileSecondKey();
    
    Common_OpenMyAppDataAndPopupInformation_Done_PleaseBackupSecondKey();
  }
  else
  {
    DuplicateFileSecondKey();

    Common_OpenMyAppDataAndPopupInformation_Done();
  }
  
  Common_ClearStatusAndFileName();
}


function CopyAndSetupShortcutForScript(i_DirFullPathTarget)
{
  Common_objFso.CopyFile(
    Common_DIR_NAME_MISC
      + Common_CHAR_DIR_SEPARATOR
      + Common_FILE_NAME_CSCDENCR_SHORTCUT
      , 
    i_DirFullPathTarget,
    true
  );

  with(
    Common_objWScriptShell.CreateShortcut(
      Common_objFso.BuildPath(
        i_DirFullPathTarget, 
        Common_FILE_NAME_CSCDENCR_SHORTCUT
      )
    )
  )
  {
    TargetPath = "wscript.exe";
    Arguments = 
      "\""
      +
      Common_objFso.BuildPath(
        DIR_FULL_PATH_INSTALL, 
        Common_DIR_NAME_SCRIPT
          + Common_CHAR_DIR_SEPARATOR
          + Common_FILE_NAME_CSCDENCR_SCRIPT
      )
      + "\""
    ;
    IconLocation = 
      Common_objFso.BuildPath(
        DIR_FULL_PATH_INSTALL,
        Common_DIR_NAME_ICON
        + Common_CHAR_DIR_SEPARATOR
        + Common_FILE_NAME_ICON_ENCRYPT
      );

    Save();
  }
}


function MakeFileSecondKey()
{
  var cscdencr_option = 
    "--command make-second-key --second-key-file"
    + " " 
    + "\"" + FILE_FULL_PATH_SECOND_KEY + "\""
  ;

  var command_line = 
    Common_objFso.BuildPath(
      DIR_FULL_PATH_INSTALL, 
      Common_DIR_NAME_BIN
        + Common_CHAR_DIR_SEPARATOR
        + Common_FILE_NAME_CSCDENCR_EXE
    )
    + " " + cscdencr_option
  ;

  var error_message = 
    Common_objWScriptShell.Exec(command_line).StdErr.ReadAll()
  ;

  if(error_message == "")
  {
    //Set ReadOnly flag
    Common_objFso.GetFile(FILE_FULL_PATH_SECOND_KEY).Attributes |= Common_FILE_ATTRIBUTES_READONLY;
  }
  else
  {
    throw (
      error_message
        + Common_CHAR_NEWLINE
        + command_line
    );
  }
}


function DuplicateFileSecondKey()
{
  Common_objFso.CopyFile(
    FILE_FULL_PATH_SECOND_KEY, 
    Common_objFso.BuildPath(DIR_FULL_PATH_MY_APP_DATA, Common_DIR_NAME_TEMP)
      + Common_CHAR_DIR_SEPARATOR
      + Common_objFso.GetBaseName(Common_FILE_NAME_SECOND_KEY)
      + "."
      + Common_GetStringDatetimeNow()
      + "."
      + Common_objFso.GetExtensionName(Common_FILE_NAME_SECOND_KEY)
    ,
    false
  );
}


function IsValidOutputDir(
  i_file_full_path_output_dir
)
{
  if(
    (Common_objFso.FileExists(i_file_full_path_output_dir))
    &&
    (
      Common_objFso.FolderExists(
        Common_objFso.OpenTextFile(
          i_file_full_path_output_dir,
          1, 
          true,
          -1
        ).ReadLine()
      )
    )
  )
  {
    return true;
  }
  else
  {
    return false;
  }
}


