//**********************************************************************
// CscdEncr.js : Copyright 2009 BEKISYS Inc.
//**********************************************************************
var m_colArg = WScript.Arguments;

var m_file_full_path_target;

var DIR_FULL_PATH_INSTALL = "";
var DIR_FULL_PATH_MY_APP_DATA = "";
var FILE_FULL_PATH_STATUS = "";
var FILE_FULL_PATH_FILE_NAME = "";
var FILE_FULL_PATH_OUTPUT_DIR = "";
var FILE_FULL_PATH_SECOND_KEY = "";

var DIR_FULL_PATH_OUTPUT = "";


try
{
  DIR_FULL_PATH_INSTALL = Common_objFso.GetParentFolderName(Common_objFso.GetParentFolderName(WScript.ScriptFullName));
  DIR_FULL_PATH_MY_APP_DATA = Common_GetDirFullPathMyAppData_IfNotExistsThenCreate();
  FILE_FULL_PATH_STATUS = 
    Common_objFso.BuildPath(DIR_FULL_PATH_MY_APP_DATA, Common_DIR_NAME_TEMP)
      + Common_CHAR_DIR_SEPARATOR
      + Common_FILE_NAME_STATUS
  ;
  FILE_FULL_PATH_FILE_NAME = 
    Common_objFso.BuildPath(DIR_FULL_PATH_MY_APP_DATA, Common_DIR_NAME_TEMP)
      + Common_CHAR_DIR_SEPARATOR
      + Common_FILE_NAME_FILE_NAME
  ;
  FILE_FULL_PATH_OUTPUT_DIR = Common_objFso.BuildPath(DIR_FULL_PATH_MY_APP_DATA, Common_FILE_NAME_OUTPUT_DIR);
  FILE_FULL_PATH_SECOND_KEY = Common_objFso.BuildPath(DIR_FULL_PATH_MY_APP_DATA, Common_FILE_NAME_SECOND_KEY);

  DIR_FULL_PATH_OUTPUT = ReadOutputDir(FILE_FULL_PATH_OUTPUT_DIR);

  if(DIR_FULL_PATH_OUTPUT == "")
  {
    throw (
      new ClassCustomError(
        "Cannot get output directory."
      )
    );
  }

  if(m_colArg.length < 1)
  {
    throw (
      new ClassCustomError(
        "Less arguments."
      )
    );
  }
  else if(m_colArg.length > 1)
  {
    throw (
      new ClassCustomError(
        "Too many arguments."
      )
    );
  }
  else
  {
    m_file_full_path_target = m_colArg(0);

    if(!Common_objFso.FileExists(m_file_full_path_target))
    {
      throw (
        new ClassCustomError(
          "Not a regular file."
        )
      );
    }
  }

  MainProcess();
}
catch(m_Error)
{
  WriteErrorLog(m_Error);
  ChangeShortcutIcon_ALL(Common_FILE_NAME_ICON_ERROR);

  if(m_Error instanceof Error)
  {
    throw m_Error;
  }
}


function MainProcess()
{
  var file_extension_target = Common_objFso.GetExtensionName(m_file_full_path_target);
  var status = ReadStatus();
  var command = "";
  var cscdencr_option = "--command" + " ";

  switch(file_extension_target)
  {
    case Common_FILE_EXTENSION_KEY:
      if(
          (status == Common_APP_STATUS_CIP)
        &&
          (Common_objFso.GetBaseName(m_file_full_path_target) == Common_objFso.GetBaseName(ReadFileName()))
      )
      {
        cscdencr_option +=
          "decrypt" + " "
          + "--plain-file" + " "
          + "\"" + DIR_FULL_PATH_OUTPUT + "\"" + " "
          + "--cipher-file" + " "
          + "\"" + ReadFileName() + "\"" + " "
          + "--key-file" + " "
          + "\"" + m_file_full_path_target + "\"" + " "
        ;
        command = "decrypt";
      }
      else
      {
        Common_WriteStatusAndFileName(
          Common_APP_STATUS_KEY,
          m_file_full_path_target
        );
        ChangeShortcutIcon_ALL(Common_FILE_NAME_ICON_KEY);
        WScript.Quit();
      }
      break;
      
    case Common_FILE_EXTENSION_CIPHER:
      if(
          (status == Common_APP_STATUS_KEY)
        &&
          (Common_objFso.GetBaseName(m_file_full_path_target) == Common_objFso.GetBaseName(ReadFileName()))
      )
      {
        cscdencr_option +=
          "decrypt" + " "
          + "--plain-file" + " "
          + "\"" + DIR_FULL_PATH_OUTPUT + "\"" + " "
          + "--cipher-file" + " "
          + "\"" + m_file_full_path_target + "\"" + " "
          + "--key-file" + " "
          + "\"" + ReadFileName() + "\"" + " "
        ;
        command = "decrypt";
      }
      else
      {
        Common_WriteStatusAndFileName(
          Common_APP_STATUS_CIP,
          m_file_full_path_target
        );
        ChangeShortcutIcon_ALL(Common_FILE_NAME_ICON_CIPHER);
        WScript.Quit();
      }
      break;

    default:
      cscdencr_option +=
        "encrypt" + " "
        + "--plain-file" + " "
        + "\"" + m_file_full_path_target + "\"" + " "
        + "--cipher-file" + " "
        + "\"" + DIR_FULL_PATH_OUTPUT + "\"" + " "
        + "--key-file" + " "
        + "\"" + DIR_FULL_PATH_OUTPUT + "\"" + " "
        + "--always-add-time-stamp-to-output-filename" + " "
      ;
      command = "encrypt";
      break;

  }

  Common_ClearStatusAndFileName();

  cscdencr_option += 
    "--second-key-file"
    + " " 
    + "\"" + FILE_FULL_PATH_SECOND_KEY + "\"" + " "
  ;

  var command_line = 
    Common_objFso.BuildPath(
      DIR_FULL_PATH_INSTALL, 
      Common_DIR_NAME_BIN
        + Common_CHAR_DIR_SEPARATOR
        + Common_FILE_NAME_CSCDENCR_EXE
    )
    + " " + cscdencr_option
  ;

  var error_message = 
    Common_objWScriptShell.Exec(command_line).StdErr.ReadAll()
  ;

  if(error_message == "")
  {
    if(command == "encrypt")
    {
      ChangeShortcutIcon_ALL(Common_FILE_NAME_ICON_ENCRYPT);
    }
    else
    {
      ChangeShortcutIcon_ALL(Common_FILE_NAME_ICON_DECRYPT);
    }

    Common_OpenDirectory(DIR_FULL_PATH_OUTPUT);
  }
  else
  {
    throw (
      new ClassCustomError(
        error_message
          + Common_CHAR_NEWLINE
          + command_line
      )
    );
  }
}


function ChangeShortcutIcon_ALL(i_FileNameIcon)
{
    ChangeShortcutIcon(
      i_FileNameIcon,
      Common_objFso.BuildPath(
        Common_objSpecialFolders.Item(Common_SPECIAL_FOLDER_NAME_SENDTO), 
        Common_FILE_NAME_CSCDENCR_SHORTCUT
      )
    );

    ChangeShortcutIcon(
      i_FileNameIcon,
      Common_objFso.BuildPath(Common_objSpecialFolders.Item(
        Common_SPECIAL_FOLDER_NAME_DESKTOP), 
        Common_FILE_NAME_CSCDENCR_SHORTCUT
      )
    );
}


function ChangeShortcutIcon(i_FileNameIcon, i_ShortcutFullPath)
{
  if(Common_objFso.FileExists(i_ShortcutFullPath))
  {
    with(
      Common_objWScriptShell.CreateShortcut(i_ShortcutFullPath)
    )
    {
      IconLocation = 
        DIR_FULL_PATH_INSTALL
          + Common_CHAR_DIR_SEPARATOR
          + Common_DIR_NAME_ICON
          + Common_CHAR_DIR_SEPARATOR
          + i_FileNameIcon
      ;
      Save();
    }
  }
}


function ReadStatus()
{
  if(Common_objFso.FileExists(FILE_FULL_PATH_STATUS))
  {
    return Common_objFso.OpenTextFile(FILE_FULL_PATH_STATUS , 1).ReadLine();
  }
  else
  {
    return "";
  }
}


function ReadFileName()
{
  if(Common_objFso.FileExists(FILE_FULL_PATH_FILE_NAME))
  {
    return Common_objFso.OpenTextFile(FILE_FULL_PATH_FILE_NAME , 1, true, -1).ReadLine();
  }
  else
  {
    return "";
  }
}


function ReadOutputDir(
  i_file_full_path_output_dir
)
{
  var output_dir = "";

  if(Common_objFso.FileExists(i_file_full_path_output_dir))
  {
    output_dir = 
      Common_objFso.OpenTextFile(
        i_file_full_path_output_dir,
        1,
        true,
        -1
      ).ReadLine()
    ;

    if(!Common_objFso.FolderExists(output_dir))
    {
      output_dir = Common_SetupOutputdir(i_file_full_path_output_dir);
    }
  }
  else
  {
    output_dir = Common_SetupOutputdir(i_file_full_path_output_dir);
  }

  return output_dir;
}

function WriteErrorLog(i_Error)
{
  var err_messge = "";
  
  if(i_Error instanceof ClassCustomError)
  {
    err_messge = i_Error.description;
  }
  else if (i_Error instanceof Error)
  {
    err_messge = 
      (i_Error.number & 0xFFFF)
      + " "
      + i_Error.description
    ;
  }

  Common_objWScriptShell.LogEvent(Common_LOGEVENT_ERROR, err_messge);
}



