//**********************************************************************
// Common.js : Copyright 2009 BEKISYS Inc.
//**********************************************************************
var Common_CHAR_DIR_SEPARATOR = "\\";
var Common_CHAR_NEWLINE = "\n";

var Common_DIR_NAME_APP_DATA_ROOT = "." + "CscdEncr";
var Common_DIR_NAME_APP_DATA_VERSION = "2009";

var Common_DIR_NAME_APP_DATA = 
  Common_DIR_NAME_APP_DATA_ROOT
    + Common_CHAR_DIR_SEPARATOR
    + Common_DIR_NAME_APP_DATA_VERSION
;

var Common_FILE_EXTENSION_KEY = "key";
var Common_FILE_EXTENSION_CIPHER = "cip";

var Common_APP_STATUS_KEY = "key";
var Common_APP_STATUS_CIP = "cip";

var Common_DIR_NAME_BIN = "bin";
var Common_DIR_NAME_ICON = "icon";
var Common_DIR_NAME_MISC = "misc";
var Common_DIR_NAME_SCRIPT = "script";

var Common_DIR_NAME_TEMP = "Temp";

var Common_FILE_NAME_OUTPUT_DIR = "output_dir.txt";
var Common_FILE_NAME_STATUS = "status.txt";
var Common_FILE_NAME_FILE_NAME = "filename.txt";
var Common_FILE_NAME_SECOND_KEY = "second_key.txt";

var Common_FILE_NAME_ICON_ENCRYPT = "encrypt.ico";
var Common_FILE_NAME_ICON_KEY = "key.ico";
var Common_FILE_NAME_ICON_CIPHER = "cipher.ico";
var Common_FILE_NAME_ICON_DECRYPT = "decrypt.ico";
var Common_FILE_NAME_ICON_ERROR = "error.ico";

var Common_FILE_NAME_CSCDENCR_SHORTCUT = "Cascade Encryptor.lnk";
var Common_FILE_NAME_CSCDENCR_SCRIPT = "CscdEncr.wsf";
var Common_FILE_NAME_CSCDENCR_EXE = "CscdEncr.exe";

var Common_SPECIAL_FOLDER_NAME_SENDTO = "SendTo";
var Common_SPECIAL_FOLDER_NAME_DESKTOP = "Desktop";

var Common_POPUP_TYPE_CRITICAL = 16;
var Common_POPUP_TYPE_QUESTION = 32;
var Common_POPUP_TYPE_EXCLAMATION = 48;
var Common_POPUP_TYPE_INFORMATION = 64;

var Common_FILE_ATTRIBUTES_READONLY = 1;

var Common_LOGEVENT_ERROR = 1;

var Common_POPUP_CLOSE_SECOND_DEFAULT = 180;


var Common_objWScriptShell = WScript.CreateObject("WScript.Shell");
var Common_objFso = WScript.CreateObject("Scripting.FileSystemObject");
var Common_objSpecialFolders = Common_objWScriptShell.SpecialFolders;
var Common_objApplication = WScript.CreateObject("Shell.Application");


function Common_OpenDirectory(i_DirFullPath)
{
    Common_objApplication.Open(i_DirFullPath);
//    Common_objWScriptShell.Run("explorer.exe" + " " + i_DirFullPath);
}


function Common_GetDirFullPathMyAppData_IfNotExistsThenCreate()
{
  //----------
  // appdata
  //----------
  var dir_full_path_appdata = 
    Common_objWScriptShell.Environment("Process").Item("APPDATA")
  ;

  if(
    (dir_full_path_appdata == "")
    ||
    (!Common_objFso.FolderExists(dir_full_path_appdata))
  )
  {
    throw (
      new ClassCustomError(
        "Cannot get Application Data folder."
      )
    );
  }

  //----------
  // myapp root
  //----------
  var dir_full_path_myapp_root = 
    Common_objFso.BuildPath(
      dir_full_path_appdata, 
      Common_DIR_NAME_APP_DATA_ROOT
    );

  if(!Common_objFso.FolderExists(dir_full_path_myapp_root))
  {
    Common_objFso.CreateFolder(dir_full_path_myapp_root);
  }

  //----------
  // myapp
  //----------
  var dir_full_path_myapp = 
    Common_objFso.BuildPath(
      dir_full_path_myapp_root, 
      Common_DIR_NAME_APP_DATA_VERSION
    );

  if(!Common_objFso.FolderExists(dir_full_path_myapp))
  {
    Common_objFso.CreateFolder(dir_full_path_myapp);
  }

  //----------
  // myapp temp
  //----------
  var dir_full_path_myapp_temp = 
    Common_objFso.BuildPath(
      dir_full_path_myapp, 
      Common_DIR_NAME_TEMP
    );

  if(!Common_objFso.FolderExists(dir_full_path_myapp_temp))
  {
    Common_objFso.CreateFolder(dir_full_path_myapp_temp);
  }


  return dir_full_path_myapp;
}


function Common_DeleteFile(i_FileName)
{
  if(Common_objFso.FileExists(i_FileName))
  {
      Common_objFso.DeleteFile(i_FileName, true);
  }
}


function Common_OpenMyAppDataAndPopupInformation_Done()
{
  Common_OpenMyAppDataAndPopupInformation(
    "done" 
  );
}

function Common_OpenMyAppDataAndPopupInformation_Done_PleaseBackupSecondKey()
{
  Common_OpenMyAppDataAndPopupInformation(
    "done" 
      + Common_CHAR_NEWLINE
      + "Please backup" + " " + Common_FILE_NAME_SECOND_KEY
  );
}

function Common_OpenMyAppDataAndPopupInformation(i_Message)
{
  Common_objWScriptShell.popup(
    i_Message, 
    Common_POPUP_CLOSE_SECOND_DEFAULT, 
    Common_TEXT_POPUP_TITLE,
    Common_POPUP_TYPE_INFORMATION
  );

  Common_OpenDirectory(DIR_FULL_PATH_MY_APP_DATA);
}


function Common_WriteStatusAndFileName(
  i_Status,
  i_FileName
)
{
  Common_objFso.OpenTextFile(FILE_FULL_PATH_STATUS , 2, true).WriteLine(i_Status);
  Common_objFso.OpenTextFile(FILE_FULL_PATH_FILE_NAME , 2, true, -1).WriteLine(i_FileName);
}


function Common_ClearStatusAndFileName()
{
  Common_WriteStatusAndFileName(
    "",
    ""
  );
}


function Common_PadLeft0(
  i_TargetValue,
  i_FixLength
)
{
  var pad_string = "";
  
  for(var i = 0; i < i_FixLength; ++i)
  {
    pad_string += "0";
  }

  var temp_string = pad_string + i_TargetValue;

  temp_string =
    temp_string.substr(
      temp_string.length - i_FixLength,
      i_FixLength
    )
  ;

  return temp_string;
}


function Common_GetStringDatetimeNow()
{
  var objDate = new Date();

  var string_of_datetime_now =
    Common_PadLeft0(objDate.getFullYear(), 4)
    + Common_PadLeft0(objDate.getMonth() + 1, 2)
    + Common_PadLeft0(objDate.getDate(), 2)
    + Common_PadLeft0(objDate.getHours(), 2)
    + Common_PadLeft0(objDate.getMinutes(), 2)
    + Common_PadLeft0(objDate.getSeconds(), 2)
    + "."
    + Common_PadLeft0(objDate.getMilliseconds(), 3)
  ;

  return string_of_datetime_now;
}


function Common_SetupOutputdir(
  i_file_full_path_output_dir
)
{
  var full_path_output_dir = "";

  var objFolder = 
    Common_objApplication.BrowseForFolder(
      0,
      "Please select output folder:",
      0x1 | 0x10,
      ""
    );

  if(objFolder != undefined)
  {
    full_path_output_dir = objFolder.Self.Path;
    
    var objTS = Common_objFso.CreateTextFile(i_file_full_path_output_dir, true, true);
    objTS.WriteLine(full_path_output_dir);
    objTS.Close();
  }

  return full_path_output_dir;
}


