//-----------　以下のコードは必要のあるユーザのみ記述する --------------

// もしMain()の開始前に実行しておきたいコードが別にある場合は以下に記述．
// このルーチンの出力はログファイルに記録されません．
void preMain() {
}

// もしMain()終了後に実行しておきたいコードが別にある場合は以下に記述．
// このルーチンの出力はログファイルに記録されません．
void postMain() {
}

// ユーザ独自のmousePressed()
void userMousePressed() {
}
// ユーザ独自のmouseRelased()
void userMouseReleased() {
}
// ユーザ独自のmouseDragged()
void userMouseDragged() {
}
// ユーザ独自のmouseMoved()
void userMouseMoved() {
}
// ユーザ独自のmouseClicked()
void userMouseClicked() {
}
// ユーザ独自のkeyPressed()
void userKeyPressed() {
  if ((key == 'q') || (key == 'Q')) crowbar.stop();
  // 何でも良いのでキーが押されたら処理を再開
  crowbar.loop();
}
// ユーザ独自のkeyRleased()
void userKeyReleased() {
}
// ユーザ独自のkeyTyped()
void userKyeTyped() {
}

class dataClass {
  float x, y;
  dataClass() {
    x = y = 0.0;
  }
}
class graphClass {
  float  Ymin, Ymax;
  float  Xmin, Xmax;
  float xa, xb, xc;
  float pixelRatio;
  int size;
  dataClass data[];
  boolean xbase;    // X軸を基準としたpixelRatioか？
  graphClass(int s) {
    Xmin = Xmax = 0.0;
    Ymin = Ymax = 0.0;
    size = s;
    data = new dataClass[100];
    int i;
    for (i = 0; i < size; i++) data[i] = new dataClass();
    xbase = true;
  }
  void calc(float ca, float cb) {
    int    i;
    float  x;
    xa = ca;
    xb = cb;
    xc = (xa + xb) / 2.0;
    // 全計算
    for (i = 0; i < size; i++) {
      x = xa + (xb - xa) / size * i;
      data[i].x = x;
      data[i].y = f(x);
    }
    // 最大値最小値（Y)を求める
    for (i = 0; i < size; i++) {
      if (i == 0) {
        Ymin = Ymax = data[i].y;
      } else {
        if (data[i].y < Ymin) Ymin = data[i].y;
        if (data[i].y > Ymax) Ymax = data[i].y;
      }
    }
    float xwidth, ywidth;
    xwidth = abs(xb - xa);
    ywidth = abs(Ymax - Ymin);
    Xmin = xa - xwidth * 0.05;
    Xmax = xb + xwidth * 0.05;
    Ymin -= ywidth * 0.05;
    Ymax += ywidth * 0.05;
    // ピクセル比を決定する
    float pixRatioX, pixRatioY;
    pixRatioX = (crowbar.gwx - crowbar.frameWidth * 2) / abs(Xmax - Xmin);
    pixRatioY = (crowbar.gwy - crowbar.frameWidth * 2) / abs(Ymax - Ymin);
    if (pixRatioX > pixRatioY) {
      pixelRatio = pixRatioY;
      xbase = false;
      Xmin -= ((crowbar.gwx - crowbar.frameWidth * 2) / pixelRatio - abs(xb - xa)) / 2.0;
      Xmax += ((crowbar.gwx - crowbar.frameWidth * 2) / pixelRatio - abs(xb - xa)) / 2.0;
    } else {
      pixelRatio = pixRatioX;
      xbase = true;
    }
  }
  int px(float x) {
    float gx;
    gx = (x - Xmin) * pixelRatio + crowbar.frameWidth;
    return int(gx);
  }
  int py(float y) {
    float gy;
    gy = crowbar.gwy - (y - Ymin) * pixelRatio - crowbar.frameWidth;
    return int(gy);
  }
  void Line(float x0, float y0, float x1, float y1) {
    line(px(x0), py(y0), px(x1), py(y1));
  }
  float norm(float x0, float y0, float x1, float y1) {
    float dx, dy;
    dx = x1 - x0;
    dy = y1 - y0;
    return sqrt(dx * dx + dy * dy);
  }
  void dashedLine(float x0, float y0, float x1, float y1) {
    int    step = 10;
    float  px0, py0, px1, py1, normv;
    float  unitx, unity;
    float  dx, dy;
    int    countmax, count;
    boolean stroke = true;

    countmax = int(norm(x0, y0, x1, y1) * pixelRatio / step);
    if (countmax <= 0) {
      Line(x0, y0, x1, y1);
      return;
    }
    px0 = x0;
    py0 = y0;
    for (count = 0; count < countmax; count++) {
      dx = x1 - px0;
      dy = y1 - py0;
      normv = sqrt(dx * dx + dy * dy);
      if (normv * pixelRatio < step) {
        Line(px0, py0, x1, y1);
        return;
      }
      unitx = dx / normv;
      unity = dy / normv;
      px1 = px0 + unitx * (step / pixelRatio);
      py1 = py0 + unity * (step / pixelRatio);
      if (stroke) Line(px0, py0, px1, py1);
      stroke = !stroke;
      px0 = px1;
      py0 = py1;
    }
  }
  void Ellipse(float x, float y) {
    ellipse(px(x), py(y), 10, 10);
  }
  void graphdraw() {
    int  i;
    // ｘ軸を描画
    Line(Xmin, 0, Xmax, 0);
    // グラフを描画
    for (i = 0; i < size - 1; i++) {
      Line(data[i].x, data[i].y, data[i+1].x, data[i+1].y);
    }
    // xaを描画
    dashedLine(xa, 0, xa, f(xa));
    Ellipse(xa, f(xa));
    // xbを描画
    dashedLine(xb, 0, xb, f(xb));
    Ellipse(xb, f(xb));
    // xcを描画
    dashedLine(xc, 0, xc, f(xc));
    Ellipse(xc, f(xc));
    // テキスト情報を描画
    crowbar._write(1, 1, str(loopcount) + "回目");
    crowbar._write(1, 2, "xa = " + nf(xa, 1, 10) + " f(xa) = " + nf(f(xa), 1, 10));
    crowbar._write(1, 3, "xc = " + nf(xc, 1, 10) + " f(xc) = " + nf(f(xc), 1, 10));
    crowbar._write(1, 4, "xb = " + nf(xb, 1, 10) + " f(xb) = " + nf(f(xb), 1, 10));
    crowbar._write(1, 6, "(xb - xa) = " + nf(xb - xa, 1, 10));
    crowbar._write(1, 7, "|f(xb) - f(xa)| = " + nf(abs(f(xb) - f(xa)), 1, 10));
  }
}

// もしMain()終了後に通常のProcessingのようにエンドレスに処理を続ける場合は
// setup()にcrowbar.nonStop()を記述すると共に，以下にコードを記述．
// ユーザ独自のdraw()
graphClass graph = new graphClass(100);
void userDraw() {
  crowbar.clrscr();
  // 繰り返し計算
  if (keyPressed && key == ' ') {
    c = (a + b) / 2.0;
    if (sgn(f(a)) == sgn(f(c))) a = c; else b = c;
    loopcount++;
  }
  // グラフ表示
  graph.calc(a, b);
  graph.graphdraw();
  // キーが押されるまで処理を中断
  crowbar.noLoop();
}

