/* $Id$ */
package saccubus.properties;

import java.io.File;
import java.util.Properties;
import saccubus.converter.profile.FfmpegOption;

/**
 * 動画設定.
 * @author yuki
 */
public class MovieSetting {

    private static final String PROP_FFMPEG_PATH = "FFnpegPath";
    private static final String PROP_VHOOK_PATH = "VhookPath";
    private static final String PROP_OPTION_FILE = "OptionFile";
    private static final String PROP_CMDLINE_EXT = "CMD_EXT";
    private static final String PROP_CMDLINE_MAIN = "CMD_MAIN";
    private static final String PROP_CMDLINE_IN = "CMD_IN";
    private static final String PROP_CMDLINE_OUT = "CMD_OUT";
    private static final String PROP_CMDLINE_AVFILTER = "CMD_AVFILTER";
    private static final String PROP_RESIZE = "CMD_RESIZE";
    private static final String PROP_RESIZE_WIDTH = "CMD_RESIZE_WIDTH";
    private static final String PROP_RESIZE_HEIGHT = "CMD_RESIZE_HEIGHT";
    private static final String PROP_ADJUST_RATIO = "CMD_ADJUST_RATIO";
    private final File ffmpeg;
    private final File vhook;
    private final File optionFile;
    private final FfmpegOption ffmpegOption;

    public MovieSetting(File ffmpeg, File vhook, File optionFile, FfmpegOption ffmpegOption) {
        this.ffmpeg = ffmpeg;
        this.vhook = vhook;
        this.optionFile = optionFile;
        this.ffmpegOption = ffmpegOption;
    }

    public File getFfmpeg() {
        return ffmpeg;
    }

    public File getVhook() {
        return vhook;
    }

    public File getOptionFile() {
        return optionFile;
    }

    public FfmpegOption getFfmpegOption() {
        return ffmpegOption;
    }

    public void save(Properties prop) {
        prop.setProperty(PROP_FFMPEG_PATH, getFfmpeg().getPath());
        prop.setProperty(PROP_VHOOK_PATH, getVhook().getPath());
        prop.setProperty(PROP_CMDLINE_EXT, getFfmpegOption().getExtOption());
        prop.setProperty(PROP_CMDLINE_MAIN, getFfmpegOption().getMainOption());
        prop.setProperty(PROP_CMDLINE_IN, getFfmpegOption().getInOption());
        prop.setProperty(PROP_CMDLINE_OUT, getFfmpegOption().getOutOption());
        prop.setProperty(PROP_CMDLINE_AVFILTER, getFfmpegOption().getAvfilterOption());
        prop.setProperty(PROP_RESIZE, Boolean.toString(getFfmpegOption().isResize()));
        prop.setProperty(PROP_RESIZE_WIDTH, Integer.toString(getFfmpegOption().getResizeWidth()));
        prop.setProperty(PROP_RESIZE_HEIGHT, Integer.toString(getFfmpegOption().getResizeHeight()));
        prop.setProperty(PROP_ADJUST_RATIO, Boolean.toString(getFfmpegOption().isAdjustRatio()));
        if (getOptionFile() != null) {
            prop.setProperty(PROP_OPTION_FILE, getOptionFile().getPath());
        } else {
            prop.remove(PROP_OPTION_FILE);
        }
    }

    public static MovieSetting load(Properties prop) {
        String name = prop.getProperty(PROP_OPTION_FILE);
        File optionFile = null;
        if (name != null) {
            optionFile = new File(name);
        }

        String ffmpeg = prop.getProperty(PROP_FFMPEG_PATH, new File("bin", "ffmpeg.exe").getPath());
        String vhook = prop.getProperty(PROP_VHOOK_PATH, new File("bin", "nicovideo.dll").getPath());
        String ext = prop.getProperty(PROP_CMDLINE_EXT, ".m4v");
        String main = prop.getProperty(PROP_CMDLINE_MAIN, "");
        String in = prop.getProperty(PROP_CMDLINE_IN, "");
        String out = prop.getProperty(PROP_CMDLINE_OUT,
                "-f ipod -g 150 -qcomp 0.7 -qmin 20 -qmax 30 -qdiff 4 -subq 6 -me_range 16 -i_qfactor 0.714286");
        String avfilter = prop.getProperty(PROP_CMDLINE_AVFILTER, "");
        boolean resize = Boolean.getBoolean(prop.getProperty(PROP_RESIZE, "false"));
        String width = prop.getProperty(PROP_RESIZE_WIDTH, "512");
        String height = prop.getProperty(PROP_RESIZE_HEIGHT, "384");
        boolean adjust = Boolean.getBoolean(prop.getProperty(PROP_ADJUST_RATIO, "false"));
        FfmpegOption opt = new FfmpegOption(ext, main, in, out, avfilter, resize, width, height, adjust);

        return new MovieSetting(new File(ffmpeg), new File(vhook), optionFile, opt);
    }
}
