/* $Id$ */
package saccubus.properties;

import java.io.File;

/**
 * 入力ファイル設定のためのスーパクラス.
 * @author yuki
 */
public abstract class InputFileSetting<T> extends ProcessFileSetting<T> {

    private final boolean deleteAfterConvert;

    /**
     * 入力ファイル設定のためのスーパクラス.
     * @param processKind ダウンロードするのであればtrue, ローカルファイルを用いるのであればfalse.
     * @param autoNaming フォルダ名のみを指定してファイル名は自動命名/自動検索するのであればtrue,
     * ファイル名まで指定するのであればfalse.
     * @param folder 画面で入力したフォルダ名. autoNamingがtrueの場合に用いられる.
     * @param file 画面で入力したファイル名. autoNamingがfalseの場合に用いられる.
     * @param deleteAfterConvert 変換処理後にファイルを削除するのであればtrue.
     */
    public InputFileSetting(T processKind, boolean autoNaming, File folder,
            File file, boolean deleteAfterConvert) {
        super(processKind, autoNaming, folder, file);
        this.deleteAfterConvert = deleteAfterConvert;
    }

    public final boolean isDeleteAfterConvert() {
        return deleteAfterConvert;
    }
}
