/* $Id$ */
package saccubus.converter.profile;

import java.io.File;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * さきゅばすで扱うファイルは、「保存するディレクトリ」と、「保存されたファイルそのもの」の2パターンある。
 * このクラスはこれらをまとめて扱うためのもの。
 * @author yuki
 */
public class SFile {

    private final boolean isFile;
    private final File file;

    /**
     * @param isFile ファイルであればtrue, ディレクトリであればfalse.
     * @param file このオブジェクトが示すFileインスタンス.
     * @throws IllegalArgumentException 存在しないディレクトリを指定した. isFileがtrueの場合、親ディレクトリが存在しないとこの例外となる.
     */
    public SFile(boolean isFile, File file) {
        this.isFile = isFile;
        this.file = file;

        File dir;
        if (isFile) {
            dir = file.getAbsoluteFile().getParentFile();
        } else {
            dir = file;
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("ディレクトリが存在しません:" + dir);
        }
    }

    public boolean isFile() {
        return isFile;
    }

    public File getFile() {
        return file;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
