/* $Id$ */
package saccubus.converter.profile;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 *
 * @author yuki
 */
public class Proxy {

    private String host;
    private int port;
    public static final Proxy NO_PROXY = new Proxy();

    private Proxy() {
        this.host = null;
        this.port = -1;
    }

    public Proxy(String host, int port) {
        if (StringUtils.isEmpty(host) || port < 0 || port > 65535) {
            throw new IllegalArgumentException("プロキシの設定が不適切です");
        }
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
