/* $Id$ */
package saccubus.converter.profile;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 *
 * @author yuki
 */
public class InputFileSetting {

    private final SFile file;
    private final boolean download;
    private final boolean delete;

    /**
     * @param file 対象ファイル.
     * @param download ダウンロードする必要があればtrue, ローカルファイルを用いるのであればfalse.
     * @param delete 変換後にファイルを削除するのであればtrue, 残したままにするのであればfalse.
     */
    public InputFileSetting(SFile file, boolean download, boolean delete) {
        this.file = file;
        this.download = download;
        this.delete = delete;
    }

    public SFile getFile() {
        return file;
    }

    public boolean isDownload() {
        return download;
    }

    public boolean isDelete() {
        return delete;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
