/* $Id$ */
package saccubus.converter.profile;

import java.io.File;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 *
 * @author yuki
 */
public class Ffmpeg {

    private final File ffmpeg;
    private final File vhook;
    private final FfmpegOption ffmpegOption;
    private final boolean vhookDisabled;
    private final int maxNumOfComment;
    private final File font;
    private final int fontIndex;
    private final int shadowIndex;
    private final boolean showConverting;
    private final boolean selfAdjustFontSize;
    private final boolean commentOpaque;
    private final NgSetting ngSetting;

    public Ffmpeg(File ffmpegPath, File vhookPath, FfmpegOption ffmpegOption, boolean vhookDisabled,
            int videoShowNum, File fontPath, int fontIndex, int shadowIndex, boolean showConvertingVideo,
            boolean selfAdjustFontSize, boolean opaqueComment, NgSetting ngSetting) {
        this.ffmpeg = ffmpegPath;
        this.vhook = vhookPath;
        this.ffmpegOption = ffmpegOption;
        this.vhookDisabled = vhookDisabled;
        this.maxNumOfComment = videoShowNum;
        this.font = fontPath;
        this.fontIndex = fontIndex;
        this.shadowIndex = shadowIndex;
        this.showConverting = showConvertingVideo;
        this.selfAdjustFontSize = selfAdjustFontSize;
        this.commentOpaque = opaqueComment;
        this.ngSetting = ngSetting;
    }

    public FfmpegOption getFfmpegOption() {
        return ffmpegOption;
    }

    public File getFfmpeg() {
        return ffmpeg;
    }

    public int getFontIndex() {
        return fontIndex;
    }

    public File getFont() {
        return font;
    }

    public boolean isCommentOpaque() {
        return commentOpaque;
    }

    public boolean isSelfAdjustFontSize() {
        return selfAdjustFontSize;
    }

    public int getShadowIndex() {
        return shadowIndex;
    }

    public boolean isShowConverting() {
        return showConverting;
    }

    public boolean isVhookDisabled() {
        return vhookDisabled;
    }

    public File getVhook() {
        return vhook;
    }

    public int getMaxNumOfComment() {
        return maxNumOfComment;
    }

    public NgSetting getNgSetting() {
        return ngSetting;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
