/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package saccubus.converter.profile;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * コメント取得に関するプロファイルです.
 * @author yuki
 */
public class CommentGetInfo {

    /** コメント取得数を自動調整するのであればtrue. */
    private final boolean selfAdjustCommentNum;
    /** コメント取得数を自動調整しない場合の取得数. */
    private final int backComment;
    /** 旧仕様(2010年末までバージョン)でコメントを取得する場合はtrue. */
    private final boolean reduceComment;

    public CommentGetInfo(boolean selfAdjustCommentNum, int backComment, boolean reduceComment) {
        this.selfAdjustCommentNum = selfAdjustCommentNum;
        this.backComment = backComment;
        this.reduceComment = reduceComment;
    }

    public boolean isSelfAdjustCommentNum() {
        return selfAdjustCommentNum;
    }

    public int getBackComment() {
        return backComment;
    }

    public boolean isReduceComment() {
        return reduceComment;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
