package saccubus.converter;

import java.util.regex.Matcher;
import saccubus.converter.profile.Profile;
import saccubus.converter.profile.FfmpegOption;
import saccubus.converter.filegetter.FileInstanciator;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import saccubus.ConvertStopFlag;
import saccubus.net.TextProgressListener;

/**
 * <p>タイトル: さきゅばす</p>
 *
 * <p>説明: ニコニコ動画の動画をコメントつきで保存</p>
 *
 * <p>著作権: Copyright (c) 2007 PSI</p>
 *
 * <p>会社名: </p>
 *
 * @author 未入力
 * @version 1.0
 */
public class Converter extends AbstractCommand implements Runnable, Callable<Boolean> {

    private final Profile Setting;
    private final String Tag;
    private final String Time;

    public Converter(String url, String time, Profile setting,
            TextProgressListener listener, ConvertStopFlag flag) {
        super(listener, flag);

        // TODO 入力欄の値から動画IDの切り出しはGUI側でやるべきだろう
        final int startIdIdx = url.lastIndexOf("/") + 1;
        final String altId = url.substring(startIdIdx);
        final Pattern idPattern = Pattern.compile("([a-z]*\\d+)");
        final Matcher idMatcher = idPattern.matcher(altId);
        if (idMatcher.find()) {
            Tag = idMatcher.group(1);
        } else {
            throw new IllegalArgumentException("URL/IDの指定が不正です: " + url);
        }

        Time = time;
        Setting = setting;
    }

    @Override
    public Boolean call() throws Exception {
        System.out.println("Convert Thread Start");
        boolean result = false;
        try {
            result = runConvert();
        } finally {
            getStopFlag().finished();
        }
        return Boolean.valueOf(result);
    }

    @Override
    public void run() {
        try {
            call();
        } catch (Exception ex) {
            String text = (ex.getMessage() != null) ? ex.getMessage() : "予期しないエラー発生のため中断しました。";
            sendText(text);
            ex.printStackTrace();
        }
    }

    private boolean runConvert() throws IOException, InterruptedException {
        if (!Setting.shouldRun()) {
            sendText("何もすることがありません");
            return true;
        }

        validSetting();
        final FfmpegOption ov = Setting.getFfmpeg().getFfmpegOption();

        sendText("ログイン中");

        final FileInstanciator fi = createInstanciator();

        stopFlagReturn();

        final File videoFile = fi.getVideoFile(getListener());

        stopFlagReturn();

        File commentFile = fi.getCommentFile(getListener());

        stopFlagReturn();

        File tcommFile = fi.getTcommFile(getListener());

        if (!Setting.needsConvert()) {
            sendText("動画・コメントを保存し、変換は行いませんでした。");
            return true;
        }

        if (!videoFile.isFile()) {
            throw new IOException("入力動画ファイルが存在しません:" + videoFile.getPath());
        }

        if (Setting.getOutputFileSetting().isAddComment()) {
            if (!commentFile.isFile()) {
                throw new IOException("入力コメントファイルが存在しません:" + commentFile.getPath());
            }
        } else {
            commentFile = null;
        }

        if (Setting.getOutputFileSetting().isAddTcomment()) {
            if (!tcommFile.isFile()) {
                throw new IOException("入力投稿者コメントファイルが存在しません" + tcommFile.getPath());
            }
        } else {
            tcommFile = null;
        }

        /*ビデオ名の確定*/
        File convertedVideoFile;
        if (!Setting.getOutputFileSetting().getFile().isFile()) {
            String conv_name = fi.getVideoTitle();
            if (Setting.getOutputFileSetting().isAppendPrefixVideoId()) {
                conv_name = getVideoIDWithBracket() + conv_name;
            }
            convertedVideoFile = new File(Setting.getOutputFileSetting().getFile().getFile(),
                    conv_name + ov.getExtOption());
        } else {
            String filename = Setting.getOutputFileSetting().getFile().getFile().getPath();
            if (!filename.endsWith(ov.getExtOption())) {
                filename = filename.substring(0, filename.lastIndexOf('.')) + ov.getExtOption();
                convertedVideoFile = new File(filename);
            } else {
                convertedVideoFile = Setting.getOutputFileSetting().getFile().getFile();
            }
        }

        boolean res = new FfmpegCommand(getListener(), getStopFlag(), commentFile, tcommFile, videoFile,
                convertedVideoFile, Setting.getFfmpeg(), Setting.getGeneralSetting()).execute();
        if (res) {
            if (Setting.getCommentSetting().isDelete()) {
                commentFile.delete();
            }
            if (Setting.getVideoSetting().isDelete()) {
                videoFile.delete();
            }
            if (Setting.getTcommentSetting().isDelete()) {
                tcommFile.delete();
            }
        }
        return res;
    }

    private FileInstanciator createInstanciator() throws IOException {
        FileInstanciator fi;

        FileInstanciator.InstanciationType videoType = new FileInstanciator.InstanciationType(Setting.getVideoSetting());

        FileInstanciator.CommentInstanciationType commentType = new FileInstanciator.CommentInstanciationType(Setting.
                getCommentSetting(), Setting.getCommentGetInfo().isSelfAdjustCommentNum(), Setting.getCommentGetInfo().
                getBackComment(), Setting.getCommentGetInfo().isReduceComment());

        FileInstanciator.InstanciationType tcommType = new FileInstanciator.InstanciationType(
                Setting.getTcommentSetting());

        fi = FileInstanciator.create(getStopFlag(), videoType, commentType, tcommType, Setting.getLoginInfo(), Tag, Time);
        return fi;
    }

    /**
     * (ネットワーク設定以外の)設定を検証する.
     * @throws IllegalArgumentException 設定に不備がある場合.
     */
    private void validSetting() {
        if (Setting.needsConvert()) {
            File a = Setting.getFfmpeg().getFfmpeg();
            if (!a.canRead()) {
                throw new IllegalArgumentException("FFmpegが見つかりません。");
            }
            if (Setting.getFfmpeg().getVhook().getPath().indexOf(' ') >= 0) {
                throw new IllegalArgumentException("すいません。現在vhookライブラリには半角空白は使えません。");
            }
            a = Setting.getFfmpeg().getVhook();
            if (!a.canRead()) {
                throw new IllegalArgumentException("Vhookライブラリが見つかりません。");
            }
            a = Setting.getFfmpeg().getFont();
            if (!a.canRead()) {
                throw new IllegalArgumentException("フォントが見つかりません。");
            }
        } else {
            if (Setting.getVideoSetting().isDelete()) {
                throw new IllegalArgumentException("変換しないのに、動画削除しちゃって良いんですか？");
            }
            if (Setting.getCommentSetting().isDelete()) {
                throw new IllegalArgumentException("変換しないのに、コメント削除しちゃって良いんですか？");
            }
            if (Setting.getTcommentSetting().isDelete()) {
                throw new IllegalArgumentException("変換しないのに、投稿者コメント削除しちゃって良いんですか？");
            }
        }
    }

    private String getVideoIDWithBracket() {
        return "[" + Tag + "]";
    }

    public boolean isConverted() {
        return getStopFlag().isFinished();
    }

    @Override
    public ConvertStopFlag getStopFlag() {
        return super.getStopFlag();
    }
}
