package saccubus;

/**
 * <p>
 * タイトル: さきゅばす
 * </p>
 * 
 * <p>
 * 説明: ニコニコ動画の動画をコメントつきで保存
 * </p>
 * 
 * <p>
 * 著作権: Copyright (c) 2007 PSI
 * </p>
 * 
 * <p>
 * 会社名:
 * </p>
 * 
 * @author 未入力
 * @version 1.0
 */
public class ConvertStopFlag {

    public interface StateChangeListener {

        void changeState(State s);
        /**
         * StateChangeListenerの何もしないバージョンの実装.
         */
        static final ConvertStopFlag.StateChangeListener EMPTY_LISTENER = new ConvertStopFlag.StateChangeListener() {

            public void changeState(State s) {
            }
        };
    }

    public enum State {

        STOPPING, FINISHED;
    }
    private volatile boolean needStop = false;
    private volatile boolean finished = false;
    private final StateChangeListener listener;

    public ConvertStopFlag(StateChangeListener listener) {
        this.listener = listener;
    }

    public void requestStop() {
        needStop = true;
        listener.changeState(State.STOPPING);
    }

    public boolean needStop() {
        return needStop;
    }

    public boolean isFinished() {
        return finished;
    }

    public void finished() {
        finished = true;
        listener.changeState(State.FINISHED);
    }
}
