/* $Id$ */
package saccubus.properties;

import java.io.File;
import java.util.Properties;

/**
 * 投稿者コメントに関する設定.
 * @author yuki
 */
public class InputTcommentSetting extends InputFileSetting<Boolean> {

    /**
     * 「入力投稿者コメント」パネルの設定.
     * @param download ダウンロードする必要があればtrue. ローカルにあるファイルを用いるのであればfalse.
     * @param inputDirectory ユーザが「保存するフォルダを指定し、ファイル名は自動で決定する」テキストフィールドに入力した値.
     * @param inputFile ユーザが「保存するファイル名を指定する」テキストフィールドに入力した値.
     * @param delete 処理終了後ファイルを削除するのであればtrue. 残したままであればfalse.
     */
    public InputTcommentSetting(boolean download, boolean autoFileName, String inputDirectory, String inputFile,
            boolean delete) {
        super(Boolean.valueOf(download), autoFileName, new File(inputDirectory), new File(inputFile), delete);
    }

    public static InputTcommentSetting load(Properties prop) {
        String str;
        str = prop.getProperty(PROP_DOWNLOAD, Boolean.toString(true));
        boolean down = Boolean.valueOf(str);
        str = prop.getProperty(PROP_DELETE, Boolean.toString(false));
        boolean del = Boolean.valueOf(str);
        str = prop.getProperty(PROP_AUTOFILENAME, Boolean.toString(true));
        boolean naming = Boolean.valueOf(str);
        String dir = prop.getProperty(PROP_DIRECTORYNAME, "out/commentowner");
        String f = prop.getProperty(PROP_FILENAME, "tcomment.xml");
        return new InputTcommentSetting(down, naming, dir, f, del);
    }

    public void save(Properties prop) {
        prop.setProperty(PROP_DOWNLOAD, getProcessKind().toString());
        prop.setProperty(PROP_DELETE, Boolean.toString(isDeleteAfterConvert()));
        prop.setProperty(PROP_AUTOFILENAME, Boolean.toString(isAutoNaming()));
        prop.setProperty(PROP_DIRECTORYNAME, getFolder().toString());
        prop.setProperty(PROP_FILENAME, getFile().toString());
    }
    private static final String PROP_DOWNLOAD = "TCDownload";
    private static final String PROP_DELETE = "TCDelete";
    private static final String PROP_AUTOFILENAME = "TCAutoNaming";
    private static final String PROP_DIRECTORYNAME = "TCDirectory";
    private static final String PROP_FILENAME = "TCFileName";
}
