/* $Id$ */
package saccubus.converter.profile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

/**
 *
 * @author yuki
 */
public class FfmpegOption {

    private final String extOption;
    private final String mainOption;
    private final String inOption;
    private final String outOption;
    private final String avfilterOption;
    private final boolean resize;
    private final int resizeWidth;
    private final int resizeHeight;
    private final boolean adjustRatio;

    public static FfmpegOption load(File file) throws IOException {
        Properties prop = new Properties();
        prop.loadFromXML(new FileInputStream(file));
        String ext = prop.getProperty("EXT");
        String main = prop.getProperty("MAIN", "");
        String in = prop.getProperty("IN", "");
        String out = prop.getProperty("OUT", "");
        String avfilter = prop.getProperty("AVFILTER", "");
        boolean resize = Boolean.getBoolean(prop.getProperty("RESIZE", "false"));
        String width = prop.getProperty("WIDTH", "");
        String height = prop.getProperty("HEIGHT", "");
        boolean adjust =  Boolean.getBoolean(prop.getProperty("ADJST_RATIO", "true"));

        if (StringUtils.isBlank(ext)) {
            throw new IOException("変換オプションファイル書式誤り ext: "
                    + ext + ", main: " + main + ", in: " + in + ", out: " + out + ", avfilter: " + avfilter);
        }
        return new FfmpegOption(ext, main, in, out, avfilter, resize, width, height, adjust);
    }

    public FfmpegOption(String extOption, String mainOption, String inOption, String outOption, String avfilterOption,
            boolean resize, String width, String height, boolean adjust) {
        this.extOption = (extOption.startsWith(".")) ? extOption : "." + extOption;
        this.mainOption = mainOption;
        this.inOption = inOption;
        this.outOption = outOption;
        this.avfilterOption = avfilterOption;
        this.resize = resize;
        this.resizeWidth = (width.isEmpty()) ? 0 : Integer.parseInt(width);
        this.resizeHeight = (height.isEmpty()) ? 0 : Integer.parseInt(height);
        this.adjustRatio = adjust;
    }


    public String getExtOption() {
        return extOption;
    }

    public String getMainOption() {
        return mainOption;
    }

    public String getInOption() {
        return inOption;
    }

    public String getOutOption() {
        return outOption;
    }

    public String getAvfilterOption() {
        return avfilterOption;
    }

    public boolean isResize() {
        return resize;
    }

    public int getResizeWidth() {
        return resizeWidth;
    }

    public int getResizeHeight() {
        return resizeHeight;
    }

    public boolean isAdjustRatio() {
        return adjustRatio;
    }
}
