/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package saccubus.converter.filegetter;

import java.io.File;
import java.io.IOException;
import saccubus.net.CommentInfo;
import saccubus.net.NicoClient;
import saccubus.net.TextProgressListener;
import saccubus.net.VideoInfo;

/**
 *
 * @author yuki
 */
public class CommentFileWebGetter extends TcommFileWebGetter {

    private final boolean autoCommentNum;
    private final int backComment;
    private final boolean reduceComment;
    private final CommentInfo commentInfo;

    CommentFileWebGetter(NicoClient client, VideoInfo vi, CommentInfo ci, boolean autoCommentNum, int backComment, boolean reduceComment) {
        super(client, vi);
        this.autoCommentNum = autoCommentNum;
        this.backComment = backComment;
        this.reduceComment = reduceComment;
        this.commentInfo = ci;
    }

    @Override
    public File get(File file, TextProgressListener listener) throws IOException {
        int com;
        if (this.autoCommentNum) {
            com = getVideoInfo().getBackCommentFromLength();
        } else {
            com = backComment;
        }

        File res = getClient().getComment(getVideoInfo(), getCommentInfo(), file, listener, com, reduceComment);
        if (res == null) {
            throw new IOException("コメントファイルのダウンロードに失敗しました。");
        }
        return res;
    }

    private CommentInfo getCommentInfo() {
        return commentInfo;
    }
}
