/* $Id$ */
package saccubus.converter;

import saccubus.ConvertStopFlag;
import saccubus.net.TextProgressListener;

/**
 *
 * @author yuki
 */
public abstract class AbstractCommand {

    private final TextProgressListener listener;
    private final ConvertStopFlag StopFlag;

    public AbstractCommand(TextProgressListener listener, ConvertStopFlag StopFlag) {
        this.listener = listener;
        this.StopFlag = StopFlag;
    }

    protected void stopFlagReturn() throws InterruptedException {
        if (getStopFlag().needStop()) {
            throw new InterruptedException("中止しました。");
        }
    }

    protected void sendText(String text) {
        getListener().setText(text);
    }

    /**
     * @return the listener
     */
    protected TextProgressListener getListener() {
        return listener;
    }

    /**
     * @return the StopFlag
     */
    protected ConvertStopFlag getStopFlag() {
        return StopFlag;
    }
}
