package saccubus;

import java.io.IOException;
import saccubus.converter.Converter;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.SwingUtilities;
import nicobrowser.entity.NicoContent;
import nicobrowser.main.Main;
import org.apache.commons.lang.StringUtils;
import saccubus.ConvertStopFlag.State;
import saccubus.converter.profile.FfmpegOption;
import saccubus.converter.profile.NgSetting;
import saccubus.net.TextProgressListener;
import saccubus.properties.BasicSetting;
import saccubus.properties.ConvertSetting;
import saccubus.properties.InputCommentSetting;
import saccubus.properties.InputVideoSetting;
import saccubus.properties.SProperties;
import saccubus.properties.InputTcommentSetting;
import saccubus.properties.MovieSetting;
import saccubus.properties.OutputVideoSetting;
import saccubus.util.FileDropTarget;
import saccubus.util.PopupRightClick;
import yukihane.nicovideo.NicoDBFinder;

/**
 * <p>
 * タイトル: さきゅばす
 * </p>
 *
 * <p>
 * 説明: ニコニコ動画の動画をコメントつきで保存
 * </p>
 *
 * <p>
 * 著作権: Copyright (c) 2007 PSI
 * </p>
 *
 * <p>
 * 会社名:
 * </p>
 *
 * @author 未入力
 * @version 1.0
 */
public class MainFrame extends JFrame {

    private static final long serialVersionUID = 2564486741331062989L;
    public static final String PRODUCT_NAME = "いんきゅばす";
    public static final String VERSION = "1.7.2 (NicoBrowser" + Main.VERSION + ")";
    public static final Image WinIcon = Toolkit.getDefaultToolkit().createImage(saccubus.MainFrame.class.getResource(
            "icon32.png"));
    // TODO GUIが無いためフィールドに保持.
    private File tempDir;
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JLabel statusBar = new JLabel();
    JTabbedPane mainTabbedPane = new JTabbedPane();
    JPanel SavingInfoTabPanel = new JPanel();
    JPanel FFMpegTabPanel = new JPanel();
    // メインウィンドウ
    private JPanel videoInfoPanel = new JPanel();
    private JPanel opPanel = new JPanel();
    private JLabel videoIdLabel = new JLabel();
    private JTextField videoIdField = new JTextField();
    private JLabel wayBackLabel = new JLabel();
    private JTextField wayBackField = new JTextField();
    private JCheckBox reduceCommentCheckBox = new JCheckBox();
    private JButton doButton = new JButton();
    public static final String DoButtonDefString = "変換";
    public static final String DoButtonStopString = "停止";
    public static final String DoButtonWaitString = "待機";
    JPanel UserInfoPanel = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    // ユーザ設定
    JLabel mailAddressLabel = new JLabel();
    JTextField mailAddressField = new JTextField();
    JLabel passwordLabel = new JLabel();
    JPasswordField passwordField = new JPasswordField();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    GridBagLayout gridBagLayout6 = new GridBagLayout();
    ButtonGroup CommentSaveButtonGroup = new ButtonGroup();
    ButtonGroup ConvSaveButtonGroup = new ButtonGroup();

    private class FfmpegOptionCheckBoxListener implements ActionListener{

        @Override
        public void actionPerformed(ActionEvent e) {
            setFFMpegOptionCheckbox();
        }
    }
    private final FfmpegOptionCheckBoxListener ffmpegOptionCheckBoxListener = new FfmpegOptionCheckBoxListener();

    private void setFFMpegOptionCheckbox() {
        boolean resizable = (resizeCheckBox.isEnabled() && resizeCheckBox.isSelected());
        resizeWidthField.setEnabled(resizable);
        resizeHeigitField.setEnabled(resizable);
        adjustRatioCheckBox.setEnabled(resizable);

    }

    private void setNames() {
        mainTabbedPane.setName("mainTabbedPane");

        mailAddressField.setName("mailAddressField");
        passwordField.setName("passwordField");

        ffmpegPathField.setName("ffmpegPathField");
        vhookPathField.setName("vhookPathField");

        mainOptionField.setName("mainOptionField");
        inputOptionField.setName("inputOptionField");
        outputOptionField.setName("outputOptionField");

        fontPathField.setName("fontPathField");
        fontIndexField.setName("fontIndexField");
        showConvVideoCheckBox.setName("showConvVideoCheckBox");
    }

    public MainFrame() {
        setNames();

        videoSaveInfoPanel = savePanel.getVideoSaveInfoPanel();

        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
            setPopup();
            setDropTarget();
            SProperties setting = SProperties.loadSetting(null,
                    null);
            this.setSetting(setting);
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * メイン画面最上部(ID/URL, 過去ログ, 変換ボタン)のパネルを初期化します.
     */
    private void initVideoInfoPanel() {

        videoIdLabel.setText("URL/ID");
        wayBackLabel.setText("過去ログ");
        videoIdField.setText("http://www.nicovideo.jp/watch/");
        reduceCommentCheckBox.setText("旧仕様コメント数");

        final GroupLayout oppLayout = new GroupLayout(opPanel);
        opPanel.setLayout(oppLayout);

        oppLayout.setHorizontalGroup(oppLayout.createSequentialGroup()
                .addGroup(oppLayout.createParallelGroup()
                    .addComponent(videoIdLabel)
                    .addComponent(wayBackLabel))
                .addGroup(oppLayout.createParallelGroup()
                    .addComponent(videoIdField)
                    .addGroup(oppLayout.createSequentialGroup()
                        .addComponent(wayBackField)
                        .addComponent(reduceCommentCheckBox)))
                );

        oppLayout.setVerticalGroup(oppLayout.createSequentialGroup()
                    .addGroup(oppLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                        .addComponent(videoIdLabel)
                        .addComponent(videoIdField))
                    .addGroup(oppLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                        .addComponent(wayBackLabel)
                        .addComponent(wayBackField)
                        .addComponent(reduceCommentCheckBox))
                );

        doButton.setText(DoButtonDefString);
        doButton.addActionListener(new MainFrame_DoButton_actionAdapter(this));

        final GroupLayout vipLayout = new GroupLayout(videoInfoPanel);
        videoInfoPanel.setLayout(vipLayout);

        vipLayout.setHorizontalGroup(vipLayout.createSequentialGroup()
                .addComponent(opPanel).addComponent(doButton));

        vipLayout.setVerticalGroup(vipLayout.createParallelGroup()
                .addComponent(opPanel).addComponent(doButton, 10, 20, 50));
    }

    /**
     * コンポーネントの初期化。
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {

        initVideoInfoPanel();

        GridBagConstraints gridBagConstraints74 = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 0, 0, 5), 0, 0);
        gridBagConstraints74.gridwidth = 2;
        GridBagConstraints gridBagConstraints73 = new GridBagConstraints();
        gridBagConstraints73.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints73.gridy = 6;
        gridBagConstraints73.weightx = 1.0;
        gridBagConstraints73.gridwidth = 4;
        gridBagConstraints73.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints73.gridx = 1;
        GridBagConstraints gridBagConstraints72 = new GridBagConstraints();
        gridBagConstraints72.gridx = 0;
        gridBagConstraints72.anchor = GridBagConstraints.WEST;
        gridBagConstraints72.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints72.fill = GridBagConstraints.NONE;
        gridBagConstraints72.gridwidth = 1;
        gridBagConstraints72.gridy = 6;
        ShadowKindLabel = new JLabel();
        ShadowKindLabel.setText("影の種類");
        ShadowKindLabel.setDisplayedMnemonic(KeyEvent.VK_UNDEFINED);
        GridBagConstraints gridBagConstraints66 = new GridBagConstraints();
        gridBagConstraints66.gridx = 0;
        gridBagConstraints66.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints66.anchor = GridBagConstraints.WEST;
        gridBagConstraints66.gridwidth = 2;
        gridBagConstraints66.gridy = 1;
        ViewCommentLabel = new JLabel();
        ViewCommentLabel.setText("表示コメント数");
        GridBagConstraints gridBagConstraints65 = new GridBagConstraints();
        gridBagConstraints65.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints65.gridy = 1;
        gridBagConstraints65.weightx = 1.0;
        gridBagConstraints65.gridwidth = 6;
        gridBagConstraints65.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints65.gridx = 3;
        GridBagConstraints gridBagConstraints64 = new GridBagConstraints(1, 1,
                1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 0, 0, 5), 0, 0);
        gridBagConstraints64.gridy = 3;
        gridBagConstraints64.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints64.gridx = 4;
        GridBagConstraints gridBagConstraints63 = new GridBagConstraints(0, 4,
                2, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 5), 0, 0);
        gridBagConstraints63.gridy = 7;
        gridBagConstraints63.gridx = 0;
        gridBagConstraints63.gridwidth = 5;
        GridBagConstraints gridBagConstraints62 = new GridBagConstraints(0, 3,
                2, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 5, 5, 5), 0, 0);
        gridBagConstraints62.gridy = 5;
        gridBagConstraints62.gridx = 1;
        gridBagConstraints62.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints62.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints62.gridwidth = 4;
        GridBagConstraints gridBagConstraints61 = new GridBagConstraints(0, 2,
                1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0);
        gridBagConstraints61.gridy = 5;
        gridBagConstraints61.gridx = 0;
        gridBagConstraints61.fill = GridBagConstraints.VERTICAL;
        gridBagConstraints61.anchor = GridBagConstraints.WEST;
        gridBagConstraints61.gridwidth = 1;
        GridBagConstraints gridBagConstraints60 = new GridBagConstraints(0, 1,
                1, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 5, 0, 5), 0, 0);
        gridBagConstraints60.gridy = 3;
        gridBagConstraints60.gridx = 1;
        gridBagConstraints60.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints60.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints60.gridwidth = 3;
        GridBagConstraints gridBagConstraints59 = new GridBagConstraints(0, 0,
                2, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0);
        gridBagConstraints59.gridy = 3;
        gridBagConstraints59.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints59.gridx = 0;
        gridBagConstraints59.fill = GridBagConstraints.NONE;
        gridBagConstraints59.anchor = GridBagConstraints.WEST;
        gridBagConstraints59.weightx = 0.0;
        gridBagConstraints59.gridwidth = 1;
        GridBagConstraints gridBagConstraints58 = new GridBagConstraints();
        gridBagConstraints58.gridx = 0;
        gridBagConstraints58.anchor = GridBagConstraints.WEST;
        gridBagConstraints58.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints58.gridwidth = 5;
        gridBagConstraints58.weightx = 1.0;
        gridBagConstraints58.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints58.gridy = 0;

        GridBagConstraints gridBagConstraints54 = new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0);
        gridBagConstraints54.gridwidth = 3;

        GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
        gridBagConstraints33.gridx = 0;
        gridBagConstraints33.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints33.weightx = 1.0;
        gridBagConstraints33.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints33.gridwidth = 5;
        gridBagConstraints33.gridy = 9;

        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 0;
        gridBagConstraints14.anchor = GridBagConstraints.WEST;
        gridBagConstraints14.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints14.weightx = 1.0;
        gridBagConstraints14.gridwidth = 5;
        gridBagConstraints14.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints14.gridy = 8;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints(0, 0,
                1, 1, 1.0, 1.0, GridBagConstraints.NORTH,
                GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 5), 0, 0);
        gridBagConstraints7.weighty = 0.0;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints6.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints6.anchor = GridBagConstraints.NORTH;
        gridBagConstraints6.gridy = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints(0, 1,
                1, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 5), 0, 0);
        gridBagConstraints1.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.anchor = GridBagConstraints.NORTH;
        gridBagConstraints1.weighty = 1.0;

        this.setIconImage(WinIcon);
        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(borderLayout1);
        setSize(new Dimension(400, 450));
        setTitle(PRODUCT_NAME + " " + VERSION);
        this.addWindowListener(new MainFrame_this_windowAdapter(this));
        statusBar.setText(" ");
        jMenuFile.setText("ファイル");
        jMenuFileExit.setText("終了");
        jMenuFileExit.addActionListener(new MainFrame_jMenuFileExit_ActionAdapter(
                this));
        jMenuHelp.setText("ヘルプ");
        jMenuHelpAbout.setText("バージョン情報");
        jMenuHelpAbout.addActionListener(new MainFrame_jMenuHelpAbout_ActionAdapter(
                this));
        SavingInfoTabPanel.setLayout(new GridLayout());
        UserInfoPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "ユーザ設定"));
        UserInfoPanel.setLayout(gridBagLayout3);
        mailAddressLabel.setText("メールアドレス");
        passwordLabel.setText("パスワード");

        setListenerToSavePanelButton();

        FFMpegTabPanel.setLayout(gridBagLayout6);
        PathSettingPanel.setBorder(BorderFactory.createTitledBorder(
                BorderFactory.createEtchedBorder(), "プログラムの位置の設定"));
        PathSettingPanel.setLayout(gridBagLayout7);
        FFmpegPathLabel.setText("FFmpeg");
        SettingFFmpegPathButton.setText("参照");
        SettingFFmpegPathButton.addActionListener(new MainFrame_SettingFFmpegPathButton_actionAdapter(
                this));
        VhookPathLabel.setText("拡張vhookライブラリ");
        SettingVhookPathButton.setText("参照");
        SettingVhookPathButton.addActionListener(new MainFrame_SettingVhookPathButton_actionAdapter(
                this));
        VhookSettingPanel.setLayout(gridBagLayout8);
        VhookSettingPanel.setBorder(BorderFactory.createTitledBorder(
                BorderFactory.createEtchedBorder(), "拡張vhookライブラリの設定"));
        FFmpegSettingPanel.setBorder(BorderFactory.createTitledBorder(
                BorderFactory.createEtchedBorder(), "FFmpegの設定"));
        FFmpegSettingPanel.setLayout(gblFFmpegSettingPanel);
        FontPathLabel.setText("フォントパス");
        SettingFontPathButton.setText("参照");
        SettingFontPathButton.addActionListener(new MainFrame_SettingFontPathButton_actionAdapter(
                this));
        showConvVideoCheckBox.setText("変換中の画像を表示する");

        extOptionLabel.setText("出力動画の拡張子");
        inputOptionLabel.setText("入力オプション");
        outputOptionLabel.setText("出力オプション");
        mainOptionLabel.setText("メインオプション");
        avfilterOptionLabel.setText("avfilterオプション");

        FontIndexLabel.setText("フォント番号");

        BasicInfoTabPanel.setLayout(gridBagLayout12);
        jMenuBar1.add(jMenuFile);
        jMenuFile.add(jMenuFileExit);
        jMenuBar1.add(jMenuHelp);
        jMenuHelp.add(jMenuHelpAbout);
        setJMenuBar(jMenuBar1);

        contentPane.add(statusBar, BorderLayout.SOUTH);
        contentPane.add(mainTabbedPane, java.awt.BorderLayout.CENTER);
        contentPane.add(videoInfoPanel, java.awt.BorderLayout.NORTH);
        UserInfoPanel.add(passwordField, new GridBagConstraints(1, 1, 1, 1,
                1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                new Insets(0, 5, 5, 5), 0, 0));
        UserInfoPanel.add(mailAddressField, new GridBagConstraints(1, 0, 1, 1,
                1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                new Insets(0, 5, 5, 5), 0, 0));
        UserInfoPanel.add(passwordLabel, new GridBagConstraints(0, 1, 1, 1,
                0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE,
                new Insets(0, 5, 5, 0), 0, 0));
        UserInfoPanel.add(mailAddressLabel, new GridBagConstraints(0, 0, 1, 1,
                0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE,
                new Insets(0, 5, 5, 0), 0, 0));
        PathSettingPanel.add(ffmpegPathField, new GridBagConstraints(0, 1, 1,
                1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 5, 0, 5), 0, 0));
        PathSettingPanel.add(SettingFFmpegPathButton, gridBagConstraints74);
        PathSettingPanel.add(FFmpegPathLabel, new GridBagConstraints(0, 0, 2,
                1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE,
                new Insets(0, 5, 5, 5), 0, 0));
        PathSettingPanel.add(vhookPathField, new GridBagConstraints(0, 3, 1, 1,
                1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                new Insets(0, 5, 5, 5), 0, 0));
        PathSettingPanel.add(SettingVhookPathButton, new GridBagConstraints(1,
                3, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 0, 5, 5), 0, 0));
        PathSettingPanel.add(VhookPathLabel, gridBagConstraints54);


        final GroupLayout layout = new GroupLayout(FFmpegSettingPanel);
        FFmpegSettingPanel.setLayout(layout);

        layout.setHorizontalGroup(layout.createParallelGroup()
                .addComponent(getFFmpegOptionComboBoxPanel())
                .addGroup(layout.createSequentialGroup()
                    .addGroup(layout.createParallelGroup()
                        .addComponent(extOptionLabel)
                        .addComponent(mainOptionLabel)
                        .addComponent(inputOptionLabel)
                        .addComponent(outputOptionLabel)
                        .addComponent(avfilterOptionLabel)
                    )
                    .addPreferredGap(ComponentPlacement.RELATED)
                    .addGroup(layout.createParallelGroup()
                        .addComponent(extOptionField)
                        .addComponent(mainOptionField)
                        .addComponent(inputOptionField)
                        .addComponent(outputOptionField)
                        .addComponent(avfilterOptionField)
                    )
                )
                .addGroup(layout.createParallelGroup()
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(resizeCheckBox)
                        .addPreferredGap(ComponentPlacement.UNRELATED)
                        .addComponent(resizeWidthLabel)
                        .addPreferredGap(ComponentPlacement.RELATED)
                        .addComponent(resizeWidthField)
                        .addPreferredGap(ComponentPlacement.UNRELATED)
                        .addComponent(resizeHeightLabel)
                        .addPreferredGap(ComponentPlacement.RELATED)
                        .addComponent(resizeHeigitField)
                    )
                )
                .addGroup(layout.createSequentialGroup()
                    .addGap(10)
                    .addComponent(adjustRatioCheckBox))
                .addGroup(layout.createSequentialGroup()
                    .addGap(20)
                )
            );

        layout.setVerticalGroup(layout.createSequentialGroup()
            .addComponent(getFFmpegOptionComboBoxPanel())
            .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                .addComponent(extOptionLabel)
                .addComponent(extOptionField))
            .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                .addComponent(mainOptionLabel)
                .addComponent(mainOptionField))
            .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                .addComponent(inputOptionLabel)
                .addComponent(inputOptionField))
            .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                .addComponent(outputOptionLabel)
                .addComponent(outputOptionField))
            .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                .addComponent(avfilterOptionLabel)
                .addComponent(avfilterOptionField))
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(resizeCheckBox)
                    .addComponent(resizeWidthLabel)
                    .addComponent(resizeWidthField)
                    .addComponent(resizeHeightLabel)
                    .addComponent(resizeHeigitField))
                .addComponent(adjustRatioCheckBox)
                )
            );

        resizeCheckBox.addActionListener(ffmpegOptionCheckBoxListener);
        adjustRatioCheckBox.addActionListener(ffmpegOptionCheckBoxListener);
        setFFMpegOptionCheckbox();



        mainTabbedPane.add(BasicInfoTabPanel, "基本設定");
        mainTabbedPane.add(SavingInfoTabPanel, "保存設定");
        mainTabbedPane.add(FFMpegTabPanel, "動画設定");
        mainTabbedPane.addTab("変換設定", null, getConvertingSettingPanel(), null);
        SavingInfoTabPanel.add(savePanel);
        BasicInfoTabPanel.add(UserInfoPanel, gridBagConstraints7);
        BasicInfoTabPanel.add(getProxyInfoPanel(), gridBagConstraints6);
        VhookSettingPanel.add(FontPathLabel, gridBagConstraints59);
        VhookSettingPanel.add(showConvVideoCheckBox, gridBagConstraints63);
        VhookSettingPanel.add(fontPathField, gridBagConstraints60);
        VhookSettingPanel.add(fontIndexField, gridBagConstraints62);
        VhookSettingPanel.add(FontIndexLabel, gridBagConstraints61);
        VhookSettingPanel.add(SettingFontPathButton, gridBagConstraints64);
        VhookSettingPanel.add(getFixFontSizeCheckBox(), gridBagConstraints14);
        VhookSettingPanel.add(getOpaqueCommentCheckBox(), gridBagConstraints33);
        VhookSettingPanel.add(getNotUseVhookCheckBox(), gridBagConstraints58);
        VhookSettingPanel.add(getViewCommentField(), gridBagConstraints65);
        VhookSettingPanel.add(ViewCommentLabel, gridBagConstraints66);
        VhookSettingPanel.add(ShadowKindLabel, gridBagConstraints72);
        VhookSettingPanel.add(getShadowComboBox(), gridBagConstraints73);

        FFMpegTabPanel.add(PathSettingPanel, new GridBagConstraints(0, 0, 1, 1,
                1.0, 0.0, GridBagConstraints.NORTHEAST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 5), 0, 0));
        FFMpegTabPanel.add(FFmpegSettingPanel, gridBagConstraints1);
    }

    /**
     * 保存設定パネル内のボタンにアクションリスナを割り当てる.
     */
    private void setListenerToSavePanelButton() {
        ActionListener al;
        al = new InputVideoPanelButtonListener();
        videoSaveInfoPanel.getShowSavingVideoFolderDialogButton().addActionListener(al);
        videoSaveInfoPanel.getShowSavingVideoFileDialogButton().addActionListener(al);
        videoSaveInfoPanel.getNibrFileChooserButton().addActionListener(al);

        al = new VideoUseRadioButtonListener();
        videoSaveInfoPanel.getVideoNoSaveButton().addActionListener(al);
        videoSaveInfoPanel.getVideoSaveButton().addActionListener(al);
        videoSaveInfoPanel.getVideoUseNiBrButton().addActionListener(al);

        al = new InputCommentPanelButtonListener();
        savePanel.getShowSavingCommentFolderDialogButton().addActionListener(al);
        savePanel.getShowSavingCommentFileDialogButton().addActionListener(al);

        al = new OutputVideoPanelButtonListener();
        savePanel.getShowSavingConvertedVideoFolderDialogButton().addActionListener(al);
        savePanel.getShowSavingConvertedVideoFileDialogButton().addActionListener(al);
    }

    private void setPopup() {
        mainOptionField.addMouseListener(new PopupRightClick(
                this.mainOptionField));
        inputOptionField.addMouseListener(new PopupRightClick(
                this.inputOptionField));
        outputOptionField.addMouseListener(new PopupRightClick(
                this.outputOptionField));
        savePanel.getCommentNumField().addMouseListener(new PopupRightClick(
                savePanel.getCommentNumField()));

        savePanel.getCommentSavedFileField().addMouseListener(new PopupRightClick(
                savePanel.getCommentSavedFileField()));
        savePanel.getCommentSavedFolderField().addMouseListener(new PopupRightClick(
                savePanel.getCommentSavedFolderField()));

        savePanel.getConvertedVideoSavedFileField().addMouseListener(new PopupRightClick(
                savePanel.getConvertedVideoSavedFileField()));
        savePanel.getConvertedVideoSavedFolderField().addMouseListener(new PopupRightClick(
                savePanel.getConvertedVideoSavedFolderField()));

        videoSaveInfoPanel.getVideoSavedFileField().addMouseListener(new PopupRightClick(
                videoSaveInfoPanel.getVideoSavedFileField()));
        videoSaveInfoPanel.getVideoSavedFolderField().addMouseListener(new PopupRightClick(
                videoSaveInfoPanel.getVideoSavedFolderField()));
        videoSaveInfoPanel.getNibrFileField().addMouseListener(
                new PopupRightClick(videoSaveInfoPanel.getNibrFileField()));

        ffmpegPathField.addMouseListener(new PopupRightClick(
                this.ffmpegPathField));
        vhookPathField.addMouseListener(new PopupRightClick(this.vhookPathField));
        videoIdField.addMouseListener(new PopupRightClick(
                this.videoIdField));
        viewCommentField.addMouseListener(new PopupRightClick(
                this.viewCommentField));
        fontPathField.addMouseListener(new PopupRightClick(this.fontPathField));
        mailAddressField.addMouseListener(new PopupRightClick(this.mailAddressField));
        passwordField.addMouseListener(new PopupRightClick(this.passwordField));
        wayBackField.addMouseListener(new PopupRightClick(this.wayBackField));

        proxyTextField.addMouseListener(new PopupRightClick(this.proxyTextField));
        proxyPortTextField.addMouseListener(new PopupRightClick(
                this.proxyPortTextField));

        fontIndexField.addMouseListener(new PopupRightClick(this.fontIndexField));

        ngWordTextField.addMouseListener(new PopupRightClick(
                this.ngWordTextField));
        ngIdTextField.addMouseListener(new PopupRightClick(this.ngIdTextField));
    }

    private void setDropTarget() {
        addTarget(videoSaveInfoPanel.getVideoSavedFileField(), false);
        addTarget(videoSaveInfoPanel.getVideoSavedFolderField(), true);
        addTarget(videoSaveInfoPanel.getNibrFileField(), false);

        addTarget(savePanel.getCommentSavedFileField(), false);
        addTarget(savePanel.getCommentSavedFolderField(), true);

        addTarget(savePanel.getConvertedVideoSavedFileField(), false);
        addTarget(savePanel.getConvertedVideoSavedFolderField(), true);

        addTarget(ffmpegPathField, false);
        addTarget(vhookPathField, false);
        addTarget(fontPathField, false);

    }

    /**
     * テキストフィールドに対しドロップを行った場合にファイルもしくはディレクトリの文字列を設定できるようにする.
     * @param c 設定対象のテキストフィールドオブジェクト.
     * @param isDir ディレクトリを設定する場合はtrue, ファイルの場合はfalse.
     * @return ドロップターゲット(用途無し).
     */
    private DropTarget addTarget(JTextField c, boolean isDir) {
        return new DropTarget(c, DnDConstants.ACTION_COPY, new FileDropTarget(
                c, isDir), true);
    }
    private File CurrentDir = new File(".");
    private JPanel PathSettingPanel = new JPanel();
    private JLabel FFmpegPathLabel = new JLabel();
    private GridBagLayout gridBagLayout7 = new GridBagLayout();
    private JTextField ffmpegPathField = new JTextField();
    private JButton SettingFFmpegPathButton = new JButton();
    private JLabel VhookPathLabel = new JLabel();
    private JTextField vhookPathField = new JTextField();
    private JButton SettingVhookPathButton = new JButton();
    private JPanel VhookSettingPanel = new JPanel();
    private GridBagLayout gridBagLayout8 = new GridBagLayout();
    private JPanel FFmpegSettingPanel = new JPanel();
    private GridBagLayout gblFFmpegSettingPanel = new GridBagLayout();
    private JLabel FontPathLabel = new JLabel();
    private JTextField fontPathField = new JTextField();
    private JButton SettingFontPathButton = new JButton();
    private JCheckBox showConvVideoCheckBox = new JCheckBox();

    private void showSaveDialog(String title, JTextField field, boolean isSave,
            boolean isDir) {
        JFileChooser chooser = new JFileChooser(CurrentDir);
        chooser.setDialogTitle(title);
        int code = 0;
        if (isDir) {
            chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        }
        if (isSave) {
            code = chooser.showSaveDialog(this);
        } else {
            code = chooser.showOpenDialog(this);
        }
        if (code == JFileChooser.APPROVE_OPTION) {
            if (isDir) {
                CurrentDir = chooser.getSelectedFile();
                field.setText(CurrentDir.getAbsolutePath());
            } else {
                File selected = chooser.getSelectedFile();
                CurrentDir = chooser.getCurrentDirectory();
                field.setText(selected.getAbsolutePath());
            }
        }
    }

    private SProperties getSetting() {
        SProperties setting = new SProperties(
                getBasicSetting(),
                getInputVideoSetting(),
                getInputCommentSetting(),
                getTcommentSetting(),
                getOutputVideoSetting(),
                getMovieSetting(),
                getConvertSetting());
        return setting;
    }

    /**
     * 設定を画面に反映する.
     * @param setting 反映する設定.
     */
    private void setSetting(SProperties setting) {
        // 基本設定
        final BasicSetting basic = setting.getBasicSetting();
        tempDir = basic.getTempDir();
        mailAddressField.setText(basic.getUser().getMail());
        passwordField.setText(basic.getUser().getPassword());
        // プロキシ関連
        useProxyCheckBox.setSelected(basic.isProxyUse());
        proxyTextField.setText(basic.getProxyHost());
        int proxy_port = basic.getProxyPort();
        if (proxy_port >= 0 && proxy_port <= 65535) {
            proxyPortTextField.setText(Integer.toString(proxy_port));
        } else {
            proxyPortTextField.setText("");
        }

        // 保存設定 - 入力動画
        final InputVideoSetting inVideo = setting.getInputVideoSetting();
        JRadioButton activeButton;
        switch (inVideo.getProcessKind()) {
            case NO_SAVE:
                activeButton = videoSaveInfoPanel.getVideoNoSaveButton();
                break;
            case NICOBROWSER:
                activeButton = videoSaveInfoPanel.getVideoUseNiBrButton();
                break;
            case SAVE:
            default:
                activeButton = videoSaveInfoPanel.getVideoSaveButton();
                break;
        }
        activeButton.doClick();

        videoSaveInfoPanel.getVideoSavedFileField().setText(inVideo.getFile().getPath());
        videoSaveInfoPanel.getVideoSavedFolderField().setText(inVideo.getFolder().getPath());
        videoSaveInfoPanel.getDelVideoCheckBox().setSelected(inVideo.isDeleteAfterConvert());
        final boolean videoFixName = inVideo.isAutoNaming();
        videoSaveInfoPanel.getSaveFileRadioButton().setSelected(!videoFixName);
        videoSaveInfoPanel.getSaveFolderRadioButton().setSelected(videoFixName);
        videoSaveInfoPanel.getNibrFileField().setText(inVideo.getNicoBrowserFile().getPath());

        // 保存設定 - 入力コメント
        final InputCommentSetting inputComment = setting.getInputCommentSetting();
        savePanel.getSavingCommentCheckBox().setSelected(inputComment.getProcessKind());
        savePanel.getCommentSavedFileField().setText(inputComment.getFile().getPath());
        savePanel.getDelCommentCheckBox().setSelected(inputComment.isDeleteAfterConvert());
        savePanel.getCommentSavedFolderField().setText(inputComment.getFolder().getPath());
        savePanel.getCommentNumField().setText(Integer.toString(inputComment.getNumOfComment()));
        savePanel.getFixCommentNumCheckBox().setSelected(inputComment.isSelfAdjustNumOfComment());
        boolean commentFixName = inputComment.isAutoNaming();
        savePanel.getCommentSaveFileRadioButton().setSelected(!commentFixName);
        savePanel.getCommentSaveFolderRadioButton().setSelected(commentFixName);

        // 投稿者コメント
        InputTcommentSetting tcom = setting.getInputTcommentSetting();
        savePanel.setTcommentDownload(tcom.getProcessKind());
        savePanel.setTcommentDelete(tcom.isDeleteAfterConvert());
        savePanel.setTcommentAutoFileName(tcom.isAutoNaming());
        savePanel.setTcommentDirectoryName(tcom.getFolder().getPath());
        savePanel.setTcommentFileName(tcom.getFile().getPath());

        // 保存設定 - 出力コメント付き動画
        final OutputVideoSetting outputVideo = setting.getOutputVideoSetting();
        savePanel.getSavingConvertedVideoCheckBox().setSelected(outputVideo.getProcessKind());
        savePanel.getAddCommentCheckBox().setSelected(outputVideo.isAddComment());
        savePanel.getAddTcommentCheckBox().setSelected(outputVideo.isAddTcomment());
        savePanel.getConvertedVideoSavedFileField().setText(outputVideo.getFile().getPath());
        savePanel.getConvertedVideoSavedFolderField().setText(outputVideo.getFolder().getPath());
        savePanel.getNotAddVideoIdConvVideoCheckBox().setSelected(outputVideo.isCutIdName());
        boolean convFixName = outputVideo.isAutoNaming();
        savePanel.getConvSaveFileRadioButton().setSelected(!convFixName);
        savePanel.getConvSaveFolderRadioButton().setSelected(convFixName);

        // 動画設定
        final MovieSetting movie = setting.getMovieSetting();
        ffmpegPathField.setText(movie.getFfmpeg().toString());
        vhookPathField.setText(movie.getVhook().toString());
        extOptionField.setText(movie.getFfmpegOption().getExtOption());
        mainOptionField.setText(movie.getFfmpegOption().getMainOption());
        inputOptionField.setText(movie.getFfmpegOption().getInOption());
        outputOptionField.setText(movie.getFfmpegOption().getOutOption());
        avfilterOptionField.setText(movie.getFfmpegOption().getAvfilterOption());
        resizeCheckBox.setSelected(movie.getFfmpegOption().isResize());
        resizeWidthField.setText(Integer.toString(movie.getFfmpegOption().getResizeWidth()));
        resizeHeigitField.setText(Integer.toString(movie.getFfmpegOption().getResizeHeight()));
        adjustRatioCheckBox.setSelected(movie.getFfmpegOption().isAdjustRatio());
        FFmpegOptionModel.reload(movie.getOptionFile());

        // 変換設定
        final ConvertSetting conv = setting.getConvertSetting();
        disableVhookCheckBox.setSelected(conv.isVhookDisabled());
        viewCommentField.setText(Integer.toString(conv.getMaxNumOfComment()));
        fontPathField.setText(conv.getFont().toString());
        fontIndexField.setText(Integer.toString(conv.getFontIndex()));
        shadowComboBox.setSelectedIndex(conv.getShadowIndex());
        showConvVideoCheckBox.setSelected(conv.isShowConverting());
        fixFontSizeCheckBox.setSelected(conv.isSelfAdjustFontSize());
        opaqueCommentCheckBox.setSelected(conv.isCommentOpaque());
        ngWordTextField.setText(conv.getNgSetting().getWord());
        ngIdTextField.setText(conv.getNgSetting().getId());
    }

    /**
     * [ファイル|終了] アクションが実行されました。
     *
     * @param actionEvent
     *            ActionEvent
     */
    void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        try {
            SProperties setting = getSetting();
            SProperties.saveSetting(setting);
        } catch (Throwable t) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, "設定保存に失敗", t);
        }
        System.exit(0);
    }

    /**
     * [ヘルプ|バージョン情報] アクションが実行されました。
     *
     * @param actionEvent
     *            ActionEvent
     */
    void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        MainFrame_AboutBox dlg = new MainFrame_AboutBox(this);
        dlg.pack();
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
    }

    /* 変換・保存する */
    private Converter Converter = null;
    // FFmpegの設定 ここから
    private final JLabel extOptionLabel = new JLabel();
    private final JTextField extOptionField = new JTextField();
    private JLabel mainOptionLabel = new JLabel();
    private JTextField mainOptionField = new JTextField();
    private JLabel inputOptionLabel = new JLabel();
    private JTextField inputOptionField = new JTextField();
    private JLabel outputOptionLabel = new JLabel();
    private JTextField outputOptionField = new JTextField();
    private final JLabel avfilterOptionLabel = new JLabel();
    private final JTextField avfilterOptionField = new JTextField();
    private final JCheckBox resizeCheckBox = new JCheckBox("次のサイズに収まるよう縮小(-s)");
    private final JLabel resizeWidthLabel = new JLabel("横");
    private final JTextField resizeWidthField = new NumberFormattedTextField();
    private final JLabel resizeHeightLabel = new JLabel("縦");
    private final JTextField resizeHeigitField = new NumberFormattedTextField();
    private final JCheckBox adjustRatioCheckBox = new JCheckBox("アスペクト比を維持");
    // FFmpegの設定 ここまで
    private JLabel FontIndexLabel = new JLabel();
    private JTextField fontIndexField = new JTextField();
    private JPanel BasicInfoTabPanel = new JPanel();
    private GridBagLayout gridBagLayout12 = new GridBagLayout();
    private JPanel ConvertingSettingPanel = null;
    private JPanel NGWordSettingPanel = null;
    private JLabel NGWordLabel = null;
    private JTextField ngWordTextField = null;
    private JLabel NGIDLabel = null;
    private JTextField ngIdTextField = null;
    // プロキシ設定
    private JPanel ProxyInfoPanel = null;
    private JCheckBox useProxyCheckBox = null;
    private JLabel proxyLabel = null;
    private JTextField proxyTextField = null;
    private JLabel proxyPortLabel = null;
    private JTextField proxyPortTextField = null;
    //
    private JCheckBox fixFontSizeCheckBox = null;
    private JCheckBox opaqueCommentCheckBox = null;
    private final SavePanel savePanel = new SavePanel();
    private final VideoSaveInfoPanel videoSaveInfoPanel;
    private JComboBox FFmpegOptionComboBox = null;
    private JButton FFmpegOptionReloadButton = null;
    private JPanel FFmpegOptionComboBoxPanel = null;

    public void DoButton_actionPerformed(ActionEvent e) {
        if (Converter == null || Converter.isConverted()) {
            try {
                executeConvert();
            } catch (Exception ex) {
                String text = ex.getMessage();
                if (StringUtils.isEmpty(text)) {
                    text = "予期しないエラーのため中断しました。";
                }
                ex.printStackTrace();
                statusBar.setText(text);
            }
        } else { /* 開始しているので、ストップする。 */
            final ConvertStopFlag flag = Converter.getStopFlag();
            if (!flag.needStop()) { /* まだストップしていない。 */
                flag.requestStop();
            }
        }
    }

    private void executeConvert() throws IOException {
        String url;

        // NicoBrowserファイルを利用する場合は、ファイル名からビデオIDを特定.
        if (videoSaveInfoPanel.getVideoUseNiBrButton().isSelected()) {
            try {
                String fileName = videoSaveInfoPanel.getNibrFileField().getText();
                NicoDBFinder finder = NicoDBFinder.getInstance();
                NicoContent info = finder.findNicoContent(fileName);
                if (info != null) {
                    url = info.getNicoId();
                } else {
                    url = "";
                }
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "エラー", JOptionPane.ERROR_MESSAGE);
                return;
            }
        } else {
            url = videoIdField.getText();
        }

        TextProgressListener sl = new TextProgressListener() {

            public void setText(final String text) {
                SwingUtilities.invokeLater(new Runnable() {

                    public void run() {
                        statusBar.setText(text);
                    }
                });
            }
        };

        ConvertStopFlag.StateChangeListener scl = new ConvertStopFlag.StateChangeListener() {

            public void changeState(final State s) {
                SwingUtilities.invokeLater(new Runnable() {

                    public void run() {
                        switch (s) {
                            case STOPPING:
                                doButton.setText(DoButtonWaitString);
                                break;
                            case FINISHED:
                                doButton.setText(DoButtonDefString);
                        }
                    }
                });
            }
        };

        Converter = new Converter(url, wayBackField.getText(), getSetting().toProfile(), sl,
                new ConvertStopFlag(scl));
        doButton.setText(DoButtonStopString);
        new Thread(Converter).start();

    }

    /* FFmpegへのパス */
    public void SettingFFmpegPathButton_actionPerformed(ActionEvent e) {
        showSaveDialog("FFmpegへのパス", ffmpegPathField, false, false);
    }

    public void SettingVhookPathButton_actionPerformed(ActionEvent e) {
        showSaveDialog("拡張vhookライブラリへのパス", vhookPathField, false, false);
    }

    public void SettingFontPathButton_actionPerformed(ActionEvent e) {
        showSaveDialog("フォントへのパス", fontPathField, false, false);
    }

    public void this_windowClosing(WindowEvent e) {
        this.jMenuFileExit_actionPerformed(null);
    }

    /**
     * This method initializes ConvertingSettingPanel
     *
     * @return javax.swing.JPanel
     */
    private JPanel getConvertingSettingPanel() {
        if (ConvertingSettingPanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = GridBagConstraints.NORTH;
            gridBagConstraints11.fill = GridBagConstraints.HORIZONTAL;
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0,
                    2, 1, 1, 1.0, 1.0, GridBagConstraints.NORTH,
                    GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 5), 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = GridBagConstraints.CENTER;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridy = 0;
            ConvertingSettingPanel = new JPanel();
            ConvertingSettingPanel.setLayout(new GridBagLayout());
            ConvertingSettingPanel.add(getNGWordSettingPanel(),
                    gridBagConstraints11);
            ConvertingSettingPanel.add(VhookSettingPanel, gridBagConstraints);
        }
        return ConvertingSettingPanel;
    }

    /**
     * This method initializes NGWordSettingPanel
     *
     * @return javax.swing.JPanel
     */
    private JPanel getNGWordSettingPanel() {
        if (NGWordSettingPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = GridBagConstraints.HORIZONTAL;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints5.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = GridBagConstraints.WEST;
            gridBagConstraints4.insets = new Insets(0, 5, 5, 0);
            gridBagConstraints4.gridy = 1;
            NGIDLabel = new JLabel();
            NGIDLabel.setText("NG ID");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = GridBagConstraints.HORIZONTAL;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 5, 5, 0);
            gridBagConstraints2.gridy = 0;
            NGWordLabel = new JLabel();
            NGWordLabel.setText("NGワード");
            NGWordSettingPanel = new JPanel();
            NGWordSettingPanel.setLayout(new GridBagLayout());
            NGWordSettingPanel.setBorder(BorderFactory.createTitledBorder(null,
                    "NGワード・ID設定(半角スペース区切りで複数入力)"));
            NGWordSettingPanel.add(NGWordLabel, gridBagConstraints2);
            NGWordSettingPanel.add(getNGWordTextField(), gridBagConstraints3);
            NGWordSettingPanel.add(NGIDLabel, gridBagConstraints4);
            NGWordSettingPanel.add(getNGIDTextField(), gridBagConstraints5);
        }
        return NGWordSettingPanel;
    }

    /**
     * This method initializes NGWordTextField
     *
     * @return javax.swing.JTextField
     */
    private JTextField getNGWordTextField() {
        if (ngWordTextField == null) {
            ngWordTextField = new JTextField();
            ngWordTextField.setName("ngWordTextField");
        }
        return ngWordTextField;
    }

    /**
     * This method initializes NGIDTextField
     *
     * @return javax.swing.JTextField
     */
    private JTextField getNGIDTextField() {
        if (ngIdTextField == null) {
            ngIdTextField = new JTextField();
            ngIdTextField.setName("ngIdTextField");
        }
        return ngIdTextField;
    }

    /**
     * This method initializes ProxyInfoPanel
     *
     * @return javax.swing.JPanel
     */
    private JPanel getProxyInfoPanel() {
        if (ProxyInfoPanel == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridwidth = 2;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.fill = GridBagConstraints.HORIZONTAL;
            gridBagConstraints13.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints13.gridy = 0;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = GridBagConstraints.HORIZONTAL;
            gridBagConstraints12.gridy = 2;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints12.gridx = 1;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints10.gridy = 2;
            proxyPortLabel = new JLabel();
            proxyPortLabel.setText("ポート番号");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = GridBagConstraints.BOTH;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints8.fill = GridBagConstraints.NONE;
            gridBagConstraints8.anchor = GridBagConstraints.EAST;
            gridBagConstraints8.gridy = 1;
            proxyLabel = new JLabel();
            proxyLabel.setText("プロキシ");
            ProxyInfoPanel = new JPanel();
            ProxyInfoPanel.setLayout(new GridBagLayout());
            ProxyInfoPanel.setBorder(BorderFactory.createTitledBorder(null,
                    "プロキシ設定"));
            ProxyInfoPanel.add(proxyLabel, gridBagConstraints8);
            ProxyInfoPanel.add(getProxyTextField(), gridBagConstraints9);
            ProxyInfoPanel.add(proxyPortLabel, gridBagConstraints10);
            ProxyInfoPanel.add(getProxyPortTextField(), gridBagConstraints12);
            ProxyInfoPanel.add(getUseProxyCheckBox(), gridBagConstraints13);
        }
        return ProxyInfoPanel;
    }

    /**
     * This method initializes ProxyTextField
     *
     * @return javax.swing.JTextField
     */
    private JTextField getProxyTextField() {
        if (proxyTextField == null) {
            proxyTextField = new JTextField();
            proxyTextField.setName("proxyTextField");
        }
        return proxyTextField;
    }

    /**
     * This method initializes ProxyPortTextField
     *
     * @return javax.swing.JTextField
     */
    private JTextField getProxyPortTextField() {
        if (proxyPortTextField == null) {
            proxyPortTextField = new JTextField();
            proxyPortTextField.setName("proxyPortTextField");
        }
        return proxyPortTextField;
    }

    /**
     * This method initializes UseProxyCheckBox
     *
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getUseProxyCheckBox() {
        if (useProxyCheckBox == null) {
            useProxyCheckBox = new JCheckBox();
            useProxyCheckBox.setText("プロキシを使う");
            useProxyCheckBox.setName("useProxyCheckBox");
        }
        return useProxyCheckBox;
    }

    /**
     * This method initializes FixFontSizeCheckBox
     *
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getFixFontSizeCheckBox() {
        if (fixFontSizeCheckBox == null) {
            fixFontSizeCheckBox = new JCheckBox();
            fixFontSizeCheckBox.setText("フォントサイズを画面にあわせて自動調整する");
            fixFontSizeCheckBox.setName("fixFontSizeCheckBox");
        }
        return fixFontSizeCheckBox;
    }

    /**
     * This method initializes OpaqueCommentCheckBox
     *
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getOpaqueCommentCheckBox() {
        if (opaqueCommentCheckBox == null) {
            opaqueCommentCheckBox = new JCheckBox();
            opaqueCommentCheckBox.setText("全てのコメントを不透明にする");
            opaqueCommentCheckBox.setName("opaqueCommentCheckBox");
        }
        return opaqueCommentCheckBox;
    }
    /**
     * This method initializes FFmpegOptionComboBox
     *
     * @return javax.swing.JComboBox
     */
    private final OptionComboBoxModel FFmpegOptionModel = new OptionComboBoxModel();
    private JCheckBox disableVhookCheckBox = null;
    private JTextField viewCommentField = null;
    private JLabel ViewCommentLabel = null;
    private JLabel ShadowKindLabel = null;
    private JComboBox shadowComboBox = null;

    private JComboBox getFFmpegOptionComboBox() {
        if (FFmpegOptionComboBox == null) {
            FFmpegOptionComboBox = new JComboBox(FFmpegOptionModel);
            FFmpegOptionComboBox.addActionListener(new java.awt.event.ActionListener() {

                public void actionPerformed(java.awt.event.ActionEvent e) {
                    if (FFmpegOptionModel.isFile()) {// ファイル
                        setFFMpegOptionEnabled(false);
                    } else {// ファイルでない
                        setFFMpegOptionEnabled(true);
                        setFFMpegOptionCheckbox();
                    }
                }

                private void setFFMpegOptionEnabled(boolean enable) {
                    extOptionField.setEnabled(enable);
                    mainOptionField.setEnabled(enable);
                    inputOptionField.setEnabled(enable);
                    outputOptionField.setEnabled(enable);
                    avfilterOptionField.setEnabled(enable);
                    resizeCheckBox.setEnabled(enable);
                    resizeWidthField.setEnabled(enable);
                    resizeHeigitField.setEditable(enable);
                    adjustRatioCheckBox.setEnabled(enable);
                }
            });
        }
        return FFmpegOptionComboBox;
    }

    /**
     * This method initializes FFmpegOptionReloadButton
     *
     * @return javax.swing.JButton
     */
    private JButton getFFmpegOptionReloadButton() {
        if (FFmpegOptionReloadButton == null) {
            FFmpegOptionReloadButton = new JButton();
            FFmpegOptionReloadButton.setText("更新");
            FFmpegOptionReloadButton.addActionListener(new java.awt.event.ActionListener() {

                public void actionPerformed(java.awt.event.ActionEvent e) {
                    FFmpegOptionModel.reload();
                }
            });
        }
        return FFmpegOptionReloadButton;
    }

    /**
     * This method initializes FFmpegOptionComboBoxPanel
     *
     * @return javax.swing.JPanel
     */
    private JPanel getFFmpegOptionComboBoxPanel() {
        if (FFmpegOptionComboBoxPanel == null) {
            GridBagConstraints gridBagConstraints47 = new GridBagConstraints();
            gridBagConstraints47.fill = GridBagConstraints.BOTH;
            gridBagConstraints47.gridx = -1;
            gridBagConstraints47.gridy = -1;
            gridBagConstraints47.insets = new Insets(0, 0, 5, 5);
            GridBagConstraints gridBagConstraints46 = new GridBagConstraints();
            gridBagConstraints46.fill = GridBagConstraints.HORIZONTAL;
            gridBagConstraints46.gridwidth = 3;
            gridBagConstraints46.gridx = -1;
            gridBagConstraints46.gridy = -1;
            gridBagConstraints46.weightx = 1.0;
            gridBagConstraints46.insets = new Insets(0, 5, 5, 5);
            FFmpegOptionComboBoxPanel = new JPanel();
            FFmpegOptionComboBoxPanel.setLayout(new GridBagLayout());
            FFmpegOptionComboBoxPanel.add(getFFmpegOptionComboBox(),
                    gridBagConstraints46);
            FFmpegOptionComboBoxPanel.add(getFFmpegOptionReloadButton(),
                    gridBagConstraints47);
        }
        return FFmpegOptionComboBoxPanel;
    }

    /**
     * This method initializes NotUseVhookCheckBox
     *
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getNotUseVhookCheckBox() {
        if (disableVhookCheckBox == null) {
            disableVhookCheckBox = new JCheckBox();
            disableVhookCheckBox.setText("拡張vhookライブラリを無効にする（デバッグ用）");
            disableVhookCheckBox.setName("disableVhookCheckBox");
        }
        return disableVhookCheckBox;
    }

    /**
     * This method initializes ViewCommentField
     *
     * @return javax.swing.JTextField
     */
    private JTextField getViewCommentField() {
        if (viewCommentField == null) {
            viewCommentField = new JTextField();
            viewCommentField.setName("viewCommentField");
        }
        return viewCommentField;
    }

    /**
     * This method initializes ShadowComboBox
     *
     * @return javax.swing.JComboBox
     */
    private JComboBox getShadowComboBox() {
        if (shadowComboBox == null) {
            shadowComboBox = new JComboBox(SProperties.ShadowKindArray);
            shadowComboBox.setName("shadowComboBox");
        }
        return shadowComboBox;
    }

    private BasicSetting getBasicSetting() {
        String mail = mailAddressField.getText();
        String pass = String.valueOf(passwordField.getPassword());
        boolean proxyUse = useProxyCheckBox.isSelected();
        String proxyHost = proxyTextField.getText();
        int proxyPort;
        try {
            proxyPort = Integer.parseInt(proxyPortTextField.getText());
        } catch (NumberFormatException e) {
            proxyPort = -1;
        }
        // TODO 作業用ディレクトリの設定GUI無し
        return new BasicSetting(tempDir, mail, pass, proxyUse, proxyHost, proxyPort);
    }

    private InputVideoSetting getInputVideoSetting() {
        VideoSaveKind kind;
        if (videoSaveInfoPanel.getVideoNoSaveButton().isSelected() == true) {
            kind = VideoSaveKind.NO_SAVE;
        } else if (videoSaveInfoPanel.getVideoUseNiBrButton().isSelected() == true) {
            kind = VideoSaveKind.NICOBROWSER;
        } else {
            kind = VideoSaveKind.SAVE;
        }
        boolean autoNaming = videoSaveInfoPanel.getSaveFolderRadioButton().isSelected();
        String folder = videoSaveInfoPanel.getVideoSavedFolderField().getText();
        String file = videoSaveInfoPanel.getVideoSavedFileField().getText();
        boolean delete = videoSaveInfoPanel.getDelVideoCheckBox().isSelected();
        String nibrFile = videoSaveInfoPanel.getNibrFileField().getText();

        return new InputVideoSetting(kind, autoNaming, new File(folder), new File(file), delete, new File(nibrFile));
    }

    private InputCommentSetting getInputCommentSetting() {
        boolean download = savePanel.getSavingCommentCheckBox().isSelected();
        String file = savePanel.getCommentSavedFileField().getText();
        int back_comment;
        try {
            back_comment = Integer.parseInt(savePanel.getCommentNumField().getText());
        } catch (NumberFormatException ex) {
            back_comment = 500;
        }
        boolean delete = savePanel.getDelCommentCheckBox().isSelected();
        boolean autoNaming = savePanel.getCommentSaveFolderRadioButton().isSelected();
        String folder = savePanel.getCommentSavedFolderField().getText();
        boolean adjustNumOfCom = savePanel.getFixCommentNumCheckBox().isSelected();

        return new InputCommentSetting(download, autoNaming, new File(folder), new File(file), delete, adjustNumOfCom,
                back_comment, reduceCommentCheckBox.isSelected());
    }

    /**
     * 画面入力値から投稿者コメント設定を作成する.
     * @return 作成した投稿者コメント設定.
     */
    private InputTcommentSetting getTcommentSetting() {
        boolean down = savePanel.isTcommentDownload();
        boolean del = savePanel.isTcommentDelete();
        boolean naming = savePanel.isTcommentAutoFileName();
        String dir = savePanel.getTcommentDirectoryName();
        String f = savePanel.getTcommentFileName();
        return new InputTcommentSetting(down, naming, dir, f, del);
    }

    private OutputVideoSetting getOutputVideoSetting() {
        boolean process = savePanel.getSavingConvertedVideoCheckBox().isSelected();
        boolean addComment = savePanel.getAddCommentCheckBox().isSelected();
        boolean addTcomment = savePanel.getAddTcommentCheckBox().isSelected();
        String file = savePanel.getConvertedVideoSavedFileField().getText();
        boolean cutId = savePanel.getNotAddVideoIdConvVideoCheckBox().isSelected();
        boolean autoNaming = savePanel.getConvSaveFolderRadioButton().isSelected();
        String folder = savePanel.getConvertedVideoSavedFolderField().getText();

        return new OutputVideoSetting(process, autoNaming, new File(folder), new File(file), cutId, addComment,
                addTcomment);
    }

    private MovieSetting getMovieSetting() {
        String ffmpeg = ffmpegPathField.getText();
        String vhook = vhookPathField.getText();
        String ext = extOptionField.getText();
        String main = mainOptionField.getText();
        String in = inputOptionField.getText();
        String out = outputOptionField.getText();
        String avfilter = avfilterOptionField.getText();
        boolean resize = resizeCheckBox.isSelected();
        String width = resizeWidthField.getText();
        String height = resizeHeigitField.getText();
        boolean adjust = adjustRatioCheckBox.isSelected();
        File optionFile = FFmpegOptionModel.getSelectedFile();

        FfmpegOption opt = new FfmpegOption(ext, main, in, out, avfilter, resize, width, height, adjust);
        return new MovieSetting(new File(ffmpeg), new File(vhook), optionFile, opt);
    }

    private ConvertSetting getConvertSetting() {
        boolean vhookDisabled = disableVhookCheckBox.isSelected();
        int maxComment = 30;
        try {
            maxComment = Integer.parseInt(viewCommentField.getText());
        } catch (NumberFormatException ex) {
        }
        File font = new File(fontPathField.getText());
        int fontIndex = Integer.parseInt(fontIndexField.getText());
        int shadowIndex = shadowComboBox.getSelectedIndex();
        boolean showConv = showConvVideoCheckBox.isSelected();
        boolean adjustFont = fixFontSizeCheckBox.isSelected();
        boolean commentOpaque = opaqueCommentCheckBox.isSelected();
        NgSetting ngSetting = new NgSetting(ngWordTextField.getText(), ngIdTextField.getText());

        return new ConvertSetting(vhookDisabled, maxComment, font, fontIndex, shadowIndex, showConv, adjustFont,
                commentOpaque, ngSetting);
    }

    private class InputVideoPanelButtonListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            final Object source = e.getSource();
            final VideoSaveInfoPanel panel = videoSaveInfoPanel;
            String title;
            JTextField field;
            boolean isSave;
            boolean isDir;

            if (source == panel.getShowSavingVideoFolderDialogButton()) {
                title = "動画の保存先(フォルダ)";
                field = panel.getVideoSavedFolderField();
                isSave = true;
                isDir = true;
            } else if (source == panel.getShowSavingVideoFileDialogButton()) {
                title = "動画の保存先(ファイル)";
                field = panel.getVideoSavedFileField();
                isSave = true;
                isDir = false;
            } else if (source == panel.getNibrFileChooserButton()) {
                title = "NicoBrowserファイル選択";
                field = panel.getNibrFileField();
                isSave = false;
                isDir = false;
            } else {
                return;
            }
            showSaveDialog(title, field, isSave, isDir);
        }
    }

    private class InputCommentPanelButtonListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            final Object source = e.getSource();
            String title;
            JTextField field;
            boolean isSave;
            boolean isDir;
            if (source == savePanel.getShowSavingCommentFolderDialogButton()) {
                title = "コメントの保存先(フォルダ)";
                field = savePanel.getCommentSavedFolderField();
                isSave = true;
                isDir = true;
            } else if (source == savePanel.getShowSavingCommentFileDialogButton()) {
                title = "コメントの保存先(ファイル)";
                field = savePanel.getCommentSavedFileField();
                isSave = true;
                isDir = false;
            } else {
                return;
            }
            showSaveDialog(title, field, isSave, isDir);
        }
    }

    private class OutputVideoPanelButtonListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            final Object source = e.getSource();
            String title;
            JTextField field;
            boolean isSave;
            boolean isDir;
            if (source == savePanel.getShowSavingConvertedVideoFolderDialogButton()) {
                title = "コメント付き動画の保存先(フォルダ)";
                field = savePanel.getConvertedVideoSavedFolderField();
                isSave = true;
                isDir = true;
            } else if (source == savePanel.getShowSavingConvertedVideoFileDialogButton()) {
                title = "コメント付き動画の保存先(ファイル)";
                field = savePanel.getConvertedVideoSavedFileField();
                isSave = true;
                isDir = false;
            } else {
                return;
            }
            showSaveDialog(title, field, isSave, isDir);
        }
    }

    private class VideoUseRadioButtonListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == videoSaveInfoPanel.getVideoUseNiBrButton()) {
                maskExt();
            } else {
                maskBase();
            }
        }

        private void maskBase() {
            mask(true);
        }

        private void maskExt() {
            mask(false);
        }

        private void mask(boolean b) {
            final VideoSaveInfoPanel panel = videoSaveInfoPanel;
            videoIdField.setEditable(b);
            panel.getDelVideoCheckBox().setEnabled(b);

            panel.getSaveFolderRadioButton().setEnabled(b);
            panel.getVideoSavedFolderField().setEnabled(b);
            panel.getShowSavingVideoFolderDialogButton().setEnabled(b);

            panel.getSaveFileRadioButton().setEnabled(b);
            panel.getVideoSavedFileField().setEnabled(b);
            panel.getShowSavingVideoFileDialogButton().setEnabled(b);

            panel.getNibrFileField().setEnabled(!b);
            panel.getNibrFileChooserButton().setEnabled(!b);
        }
    }
}

class MainFrame_this_windowAdapter extends WindowAdapter {

    private MainFrame adaptee;

    MainFrame_this_windowAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        adaptee.this_windowClosing(e);
    }
}

class MainFrame_SettingFontPathButton_actionAdapter implements ActionListener {

    private MainFrame adaptee;

    MainFrame_SettingFontPathButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.SettingFontPathButton_actionPerformed(e);
    }
}

class MainFrame_SettingVhookPathButton_actionAdapter implements ActionListener {

    private MainFrame adaptee;

    MainFrame_SettingVhookPathButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.SettingVhookPathButton_actionPerformed(e);
    }
}

class MainFrame_SettingFFmpegPathButton_actionAdapter implements ActionListener {

    private MainFrame adaptee;

    MainFrame_SettingFFmpegPathButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.SettingFFmpegPathButton_actionPerformed(e);
    }
}

class MainFrame_DoButton_actionAdapter implements ActionListener {

    private MainFrame adaptee;

    MainFrame_DoButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.DoButton_actionPerformed(e);
    }
}

class MainFrame_jMenuFileExit_ActionAdapter implements ActionListener {

    MainFrame adaptee;

    MainFrame_jMenuFileExit_ActionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        adaptee.jMenuFileExit_actionPerformed(actionEvent);
    }
}

class MainFrame_jMenuHelpAbout_ActionAdapter implements ActionListener {

    MainFrame adaptee;

    MainFrame_jMenuHelpAbout_ActionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        adaptee.jMenuHelpAbout_actionPerformed(actionEvent);
    }
}
