/* $Id$ */
package saccubus.properties;

import java.io.File;
import java.util.Properties;

/**
 * 処理対象ファイル設定のためのスーパクラス.
 * @author yuki
 */
public abstract class ProcessFileSetting<T> {

    private final T processKind;
    private final boolean autoNaming;
    private final File folder;
    private final File file;

    /**
     * 処理対象ファイル設定のためのスーパクラス.
     * @param processKind 処理する種類を設定する. 
     * 対象ファイルにより意味は異なるが, 入力ファイルではダウンロードするのであればtrue,
     * 出力ファイルであれば変換する(出力する)のであればtrue, というように用いる.
     * @param autoNaming フォルダ名のみを指定してファイル名は自動命名/自動検索するのであればtrue,
     * ファイル名まで指定するのであればfalse.
     * @param folder 画面で入力したフォルダ名. autoNamingがtrueの場合に用いられる.
     * @param file 画面で入力したファイル名. autoNamingがfalseの場合に用いられる.
     */
    public ProcessFileSetting(T processKind, boolean autoNaming, File folder, File file) {
        this.processKind = processKind;
        this.autoNaming = autoNaming;
        this.folder = folder;
        this.file = file;
    }

    public final T getProcessKind() {
        return processKind;
    }

    /**
     * @return 「保存するフォルダを指定し、ファイル名は自動で決定する」のであればtrue.
     * 「保存するファイル名を指定する」のであればfalse.
     */
    public final boolean isAutoNaming() {
        return autoNaming;
    }

    public final File getFolder() {
        return folder;
    }

    public final File getFile() {
        return file;
    }


    public abstract void save(Properties prop);
}
