package osm.jp;
import hayashi.yuu.tools.logger.LoggerFactory;

import javax.xml.parsers.*;
import javax.xml.transform.TransformerException;

import org.w3c.dom.*;
import org.xml.sax.*;

import java.io.*;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

import jp.co.areaweb.tools.database.*;

public class ConvBusroute {

	String filter = "";
	String urlStr = "";

	public static final boolean DB_INIT = false;

	// 近くのバス停を探す範囲（バス停を中心としたNEER×２ｍ四方の領域
	static final int NEER = 75;
	static boolean nocheck = true;
	static Logger logger = LoggerFactory.getInstance();

	/**
	 * メイン
	 *
	 *	java -cp .:ConvBusstop.jar:hayashi_0225.jar:hsqldb_2.2.9.jar osm.jp.ConvBusroute
	 *
	 * @throws IOException
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws FileNotFoundException
	 * @throws TransformerException
	 * @throws SAXException
	 * @throws ParserConfigurationException */
	public static void main(String[] args) throws FileNotFoundException, ClassNotFoundException, SQLException, IOException, ParserConfigurationException, SAXException, TransformerException
	{
		/**
		 * アプリケーション [ConvBusroute]
		 * > java -jar ConvBusstop.jar <オプション>
		 * 	オプション： -exp	実行する直前にデータベースを初期化する（省略可能）
		 */
		File dbdir = new File("database");
		if (!dbdir.isDirectory()) {
			dbdir.mkdir();
		}

		Connection con = DatabaseTool.openDb("database");
		ConvBusroute.initDb(con);

		try {
			/**
			 * バスルートデータ変換のメイン処理
			 */
			int fcounter = 0;
			File dir = new File(".");
			File[] files = dir.listFiles();
			for (File iFile : files) {
				if (checkFile(iFile)) {
					fcounter++;
					ConvBusroute.clearDb(con);
					inputFile(con, iFile);

					// ローカルデータベース内の情報を出力する
					String iStr = iFile.getName();
					outputDb(con, iStr.substring(0, iStr.length() - 4));
				}
			}
			logger.info("["+ fcounter +"]つのファイルをインポートしました。");
		}
		finally {
			DatabaseTool.closeDb(con);
		}
	}

	/**
	 * ソースファイルを読み取ってローカルベータベースへ記録する
	 * @param con
	 * @param iFile
	 * @throws FileNotFoundException
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 * @throws ParserConfigurationException 
	 * @throws SAXException 
	 */
	public static void inputFile (Connection con, File iFile) throws FileNotFoundException, ClassNotFoundException, SQLException, IOException, ParserConfigurationException, SAXException {
		int iCounter = 0;

		String iStr = iFile.getName();
		File dir = new File(iStr.substring(0, iStr.length() - 4));
		dir.mkdir();

		DocumentBuilderFactory factory;
		DocumentBuilder        builder;
		Node root;

		iCounter = 0;
		factory = DocumentBuilderFactory.newInstance();
		builder = factory.newDocumentBuilder();
		factory.setIgnoringElementContentWhitespace(true);
		factory.setIgnoringComments(true);
		factory.setValidating(true);
		root    = builder.parse(iStr);

		iCounter += importNodes(con, root, iStr.substring(0, iStr.length() - 4));
		logger.info("バスルート数["+ iCounter +"]");
	}

	public static void clearDb(Connection con) throws SQLException {
		Statement stmt = con.createStatement();
		long count = stmt.executeUpdate("delete from bus_route");
	    logger.info("'bus_route'から "+ count +" 件のデータを削除しました。");
	    
	    count = stmt.executeUpdate("delete from bus_Curve");
	    logger.info("'bus_Curve'から "+ count +" 件のデータを削除しました。");
	    
	    stmt.close();
	}

	public static void initDb(Connection con) throws SQLException {
		// 'table.BUS_STOP'を新規に作る
		// 'table.bus_route'を新規に作る
		// 'table.bus_Curve'を新規に作る
		DbBusstop.create(con);
	}


	/**
	 * ローカルデータベース内の情報を出力する
	 * @param con
	 * @param iCode
	 * @throws IOException
	 * @throws SQLException
	 */
	public static void outputDb(Connection con, String iCode) throws IOException, SQLException {
		File dir = new File(iCode);
		dir.mkdir();

		BufferedWriter gw = null;
		BufferedWriter hw = null;

		// HTML header
		File htmlFile = new File(iCode  +".html");
		hw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(htmlFile), "UTF-8"));
		hw.write("<!DOCTYPE html>");
		hw.newLine();
		hw.write("<html><head><meta charset=\"utf-8\" /></head>");
		hw.newLine();
		hw.write("<body><table border='1'>");
		hw.newLine();
		hw.write("<tr>");
		hw.write("<td>boc</td>");
		hw.write("<td>bln</td>");
		hw.write("<td>GPX</td>");
		hw.write("</tr>");
		hw.newLine();
		
		String maeid = "";
		String maeroute = "";
		File gpxFile = null;

		System.out.println("Database request....");
		PreparedStatement ps7 = con.prepareStatement("SELECT bus_route.bsc, bus_route.boc, bus_route.bln, bus_Curve.idref, bus_Curve.seq, bus_Curve.lat, bus_Curve.lon FROM bus_route INNER JOIN bus_Curve ON bus_route.cvid = bus_Curve.idref ORDER BY bus_route.bsc,bus_route.boc,bus_route.bln, bus_route.cvid,bus_Curve.seq");
		ResultSet rset7 = ps7.executeQuery();
		while (rset7.next()) {
			int bsc = rset7.getInt(1);
			String boc = rset7.getString(2);
			String bln = rset7.getString(3);
			String cvid = rset7.getString(4);
			//int seq = rset7.getInt(5);
			Double lat = rset7.getDouble(6);
			Double lon = rset7.getDouble(7);

			if (!maeroute.equals(boc +" "+ bln)) {
				// GPX file
				if (!maeroute.equals("")) {
					if (!maeid.equals(cvid)) {
						// GPX <trkseg/>
						if (!maeid.equals("")) {
							gw.write("</trkseg>");
							gw.newLine();
							maeid = "";
						}
					}
					
					// GPX file footer
					gw.write("</trk>");
					gw.write("</gpx>");
					gw.newLine();
					gw.close();
					System.out.println();
				}
				maeroute = new String(boc +" "+ bln);

				System.out.print("export course("+ maeroute +") ");

				gpxFile = new File(dir, iCode + cvid +".gpx");
				gw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(gpxFile), "UTF-8"));
				gw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
				gw.newLine();
				gw.write("<gpx xmlns=\"http://www.topografix.com/GPX/1/1\" version=\"1.1\" creator=\"osmtracker-android\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd \">");
				gw.newLine();

				// GPX <trk/>
				gw.write("<trk>");
				gw.write(" <name>"+ bsc +" "+ boc +" "+ bln +" "+ cvid +"</name>");
				gw.newLine();

				// INDEX file
				hw.write("<tr>");
				hw.write("<td>"+ boc +"</td>");
				hw.write("<td>"+ bln +"</td>");
				hw.write("<td><a href='"+ dir.getName() +"/"+ gpxFile.getName() +"'>"+ gpxFile.getName() +"</a></td>");
				hw.write("</tr>");
				hw.newLine();
			}
			
			if (!maeid.equals(cvid)) {
				if (!maeid.equals("")) {
					// GPX file footer
					gw.write("</trkseg>");
					gw.newLine();
				}
				System.out.println();

				// GPX <trkseg/>
				gw.write("<trkseg>");
				gw.newLine();
			}
			maeid = new String(cvid);
			
			// GPX <trkpt/>
			System.out.print(".");
			gw.write("<trkpt lat=\""+ lat +"\" lon=\""+ lon +"\"></trkpt>");
			gw.newLine();
		}
		rset7.close();

		// GPX file footer
		gw.write("</trkseg>");
		gw.write("</trk>");
		gw.write("</gpx>");
		gw.newLine();
		gw.close();

		// index file footer
		hw.write("</table></body></html>");
		hw.newLine();
		hw.close();
	}
	
	public static BufferedWriter createGPX(File gpxFile, String cvid) throws IOException {
		BufferedWriter gw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(gpxFile), "UTF-8"));
		gw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
		gw.newLine();
		gw.write("<gpx xmlns=\"http://www.topografix.com/GPX/1/1\" version=\"1.1\" creator=\"osmtracker-android\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd \">");
		gw.newLine();
		return gw;		
	}


	/**
	 *
	 * @param con
	 * @param node
	 * @param iFileName		// ソースファイル名（拡張子を含まない）
	 * @return
	 * @throws IOException
	 * @throws SQLException
	 */
	public static int importNodes(Connection con, Node node, String iFileName) throws IOException, SQLException {
		int iCounter = 0;

		NodeList nodes = node.getChildNodes();
		for (int i=0; i<nodes.getLength(); i++) {
			Node node2 = nodes.item(i);
			if (node2.getNodeName().equals("gml:Curve")) {
				importGmlCurve(con, node2);
			}
			else if (node2.getNodeName().equals("ksj:BusRoute")) {
				iCounter++;
				importBusRoute(con, node2, iFileName);
			}
			else {
				iCounter += importNodes(con, node2, iFileName);
			}
		}
		return iCounter;
	}
	
	public static void importGmlCurve(Connection con, Node node) throws IOException, SQLException {
		String positionStr = "";
		String latStr = "";
		String lonStr = "";
		String idStr = "";

		NamedNodeMap nodeMap = node.getAttributes();
		if ( null != nodeMap ) {
			for ( int j=0; j<nodeMap.getLength(); j++ ) {
				if (nodeMap.item(j).getNodeName().equals("gml:id")) {
					idStr = nodeMap.item(j).getNodeValue();
				}
			}
		}

		NodeList nodes = node.getChildNodes();
		for (int i=0; i < nodes.getLength(); i++) {
			Node node2 = nodes.item(i);
			if (node2.getNodeName().equals("gml:segments")) {
				NodeList nodes3 = node2.getChildNodes();
				for (int j=0; j < nodes3.getLength(); j++) {
					Node node3 = nodes3.item(j);
					if (node3.getNodeName().equals("gml:LineStringSegment")) {
						NodeList nodes4 = node3.getChildNodes();
						for (int k=0; k < nodes4.getLength(); k++) {
							Node node4 = nodes4.item(k);
							if (node4.getNodeName().equals("gml:posList")) {
								BufferedReader bf = new BufferedReader(new StringReader(node4.getTextContent()));
								String line;
								int seq = 0;
								while ((line = bf.readLine()) != null) {
									seq++;
									positionStr = line.trim();
									if (!positionStr.equals("")) {
										String[] str4Ary = positionStr.split(" ");
										latStr = str4Ary[0];
										lonStr = str4Ary[1];
										double lat = Double.parseDouble(latStr);
										double lon = Double.parseDouble(lonStr);
										
										System.out.println("import course("+ idStr+","+ seq +","+ lat +","+ lon +")");

										PreparedStatement ps2 = con.prepareStatement("INSERT INTO bus_Curve (idref,seq,lat,lon) VALUES (?,?,?,?)");
										ps2.setString(1, idStr);
										ps2.setInt(2, seq);
										ps2.setDouble(3, lat);
										ps2.setDouble(4, lon);
										ps2.executeUpdate();
										ps2.close();
									}
								}
							}
						}
					}
				}
			}
		}
	}

	public static void importBusRoute(Connection con, Node node, String iFileName) throws IOException, SQLException {
		String cvId = "";
		int bsc = -1;
		String boc = "";
		String bln = "";
		
		NodeList nodes = node.getChildNodes();
		for (int i=0; i < nodes.getLength(); i++) {
			Node node2 = nodes.item(i);
			if (node2.getNodeName().equals("ksj:brt")) {
				NamedNodeMap nodeMap = node2.getAttributes();
				if (null != nodeMap) {
					for ( int j=0; j < nodeMap.getLength(); j++ ) {
						if (nodeMap.item(j).getNodeName().equals("xlink:href")) {
							cvId = nodeMap.item(j).getNodeValue();
							cvId = cvId.substring(1);
							logger.info("found idref='"+ cvId +"'");
							break;
						}
					}
				}
			}
			else if (node2.getNodeName().equals("ksj:bsc")) {
				String str = node2.getTextContent();
				bsc = Integer.parseInt(str);
			}
			else if (node2.getNodeName().equals("ksj:boc")) {
				boc = node2.getTextContent();
			}
			else if (node2.getNodeName().equals("ksj:bln")) {
				bln = node2.getTextContent();
			}
		}

		PreparedStatement ps2 = con.prepareStatement("INSERT INTO bus_route (cvid,bsc,boc,bln) VALUES (?,?,?,?)");
		ps2.setString(1, cvId);
		ps2.setInt(2, bsc);
		ps2.setString(3, boc);
		ps2.setString(4, bln);
		ps2.executeUpdate();
		ps2.close();
	}


	/**
	 * exp: KANAGAWA-ken [N07-11_14.xml]
	 * 
	 * @param f
	 * @return
	 */
	static boolean checkFile(File f) {
		String name = f.getName();
		if (!name.toUpperCase().startsWith("N07-")) {
			return false;
		}
		if (!name.toLowerCase().endsWith(".xml")) {
			return false;
		}
		return true;
	}
}