package osm.jp;

public class RectArea {
    public double minlon;	// 経度（西）
    public double maxlon;	// 経度（東）
    public double minlat;	// 緯度（南）
    public double maxlat;	// 緯度（北）

    /**
     * 矩形領域を中心点と中心点からの距離（メートル）でセットする
     * 
     * @param lat	// 中心点の緯度
     * @param lon	// 中心点の経度
     * @param m		// 距離　領域の一辺の長さの半分
     */
	public RectArea(double lat, double lon, int m) {
		/*
		double BIG_Y = (40000000.0d / 2.0d / Math.PI);		// 地球の半径
		double LAT1 = (10000000.0d / 90.0d);		// 緯度１度の距離（ｍ）
		double dLat = m / LAT1;						// 距離を表す緯度（差分）
		double y = Math.sin((90.0d - lat) / 180.0d) * BIG_Y;	// 緯線上の地球の半径
		double lon1 = y * 2.0d * Math.PI;			// 経度１度の距離（ｍ）
		double dLon = m / lon1;						// 距離を表す経度（差分）
		*/
		double dLat = 0.000453D * m / 50D;			// 距離を表す緯度（差分）
		double dLon = 0.0005588D * m / 50D;			// 距離を表す経度（差分）
		minlat = lat - dLat;		// 底辺（緯度）
		maxlat = lat + dLat;		// 上辺（緯度）
		minlon = lon - dLon;		// 左辺
		maxlon = lon + dLon;		// 右辺
	}

	/**
	 * 約１００ｍ四方
	 * @param lat
	 * @param lon
	 * @param m
	 */
	public RectArea(double lat, double lon) {
		double dLat = 0.000453;			// 距離を表す緯度（差分）
		double dLon = 0.0005588;		// 距離を表す経度（差分）
		minlat = lat - dLat;		// 底辺（緯度）
		maxlat = lat + dLat;		// 上辺（緯度）
		minlon = lon - dLon;		// 左辺
		maxlon = lon + dLon;		// 右辺
	}
}
