/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.parser;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorsParser
implements ITypeParser {
    private static final String NAMESPACE = "http://concierge.sourceforge.jp/ns/authors";
    private static final String PREFIX = "auth";
    private static final String TAGNAME = "author";
    private static final String MESSAGE = "Each author name (family name followed by the middle and given names or thier initial letters) must be separate by a COMMA, e.g. \"Hubel DH, Weisel TN\".";

    private Hashtable<String, String> parse(String name) {
        ArrayList<String> vl = new ArrayList<String>();
        String[] vals = name.split(" ");
        int i = 0;
        while (i < vals.length) {
            String val = vals[i].trim();
            if (val.length() > 0) {
                vl.add(val);
            }
            ++i;
        }
        String lastname = "";
        if (vl.size() >= 2) {
            int i2 = 0;
            while (i2 < vl.size() - 1) {
                if (i2 != 0) {
                    lastname = String.valueOf(lastname) + " ";
                }
                lastname = String.valueOf(lastname) + (String)vl.get(i2);
                ++i2;
            }
        } else if (vl.size() == 1) {
            lastname = (String)vl.get(0);
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("lastname", lastname);
        ht.put("firstname", vl.size() > 1 ? (String)vl.get(vl.size() - 1) : "");
        ht.put("preposition", "");
        ht.put("middlename", "");
        return ht;
    }

    @Override
    public String getParserNS() {
        return NAMESPACE;
    }

    @Override
    public String getParserNSPrefix() {
        return PREFIX;
    }

    @Override
    public String getSingleText(Element elem) {
        String str = "";
        ArrayList<Element> elems = DomImpl.getElements(elem, "auth:author");
        int i = 0;
        while (i < elems.size()) {
            Element e = elems.get(i);
            ArrayList<Element> fnl = DomImpl.getElements(e, "firstname", PREFIX);
            String firstname = fnl.size() > 0 ? DomImpl.getElementText(fnl.get(0)) : "";
            ArrayList<Element> mnl = DomImpl.getElements(e, "middlename", PREFIX);
            String middlename = mnl.size() > 0 ? DomImpl.getElementText(mnl.get(0)) : "";
            ArrayList<Element> lnl = DomImpl.getElements(e, "lastname", PREFIX);
            String lastname = lnl.size() > 0 ? DomImpl.getElementText(lnl.get(0)) : "";
            ArrayList<Element> pnl = DomImpl.getElements(e, "preposition", PREFIX);
            String preposition = pnl.size() > 0 ? DomImpl.getElementText(pnl.get(0)) : "";
            String name = "";
            if (preposition.length() > 0) {
                name = String.valueOf(name) + preposition;
            }
            if (lastname.length() > 0) {
                if (name.length() > 0) {
                    name = String.valueOf(name) + " ";
                }
                name = String.valueOf(name) + lastname;
            }
            if (middlename.length() > 0) {
                if (name.length() > 0) {
                    name = String.valueOf(name) + " ";
                }
                name = String.valueOf(name) + middlename;
            }
            if (firstname.length() > 0) {
                if (name.length() > 0) {
                    name = String.valueOf(name) + " ";
                }
                name = String.valueOf(name) + firstname;
            }
            if (str.length() > 0 && name.length() > 0) {
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + name;
            ++i;
        }
        return str;
    }

    @Override
    public void putToElement(Element elem, String str) {
        String[] vals = str.split(",");
        ArrayList<Element> elems = DataDomImpl.getElements(elem, TAGNAME, PREFIX);
        int i = 0;
        while (i < elems.size()) {
            elem.removeChild(elems.get(i));
            ++i;
        }
        i = 0;
        while (i < vals.length) {
            String val = vals[i].trim();
            Element e = DomImpl.appendElement(elem, TAGNAME, PREFIX);
            Hashtable<String, String> ht = this.parse(val);
            Element fe = DomImpl.createElement(elem, "firstname", PREFIX);
            DomImpl.setElementText(fe, ht.get("firstname"));
            Element me = DomImpl.createElement(elem, "middlename", PREFIX);
            DomImpl.setElementText(me, ht.get("middlename"));
            Element pe = DomImpl.createElement(elem, "preposition", PREFIX);
            DomImpl.setElementText(pe, ht.get("preposition"));
            Element le = DomImpl.createElement(elem, "lastname", PREFIX);
            DomImpl.setElementText(le, ht.get("lastname"));
            e.appendChild(pe);
            e.appendChild(le);
            e.appendChild(me);
            e.appendChild(fe);
            ++i;
        }
    }

    public void addAuthorToElement(Element elem, String author) {
        Hashtable<String, String> ht = this.parse(author.trim());
        this.addAuthorToElement(elem, ht.get("lastname"), ht.get("middlename"), ht.get("firstname"), ht.get("preposition"));
    }

    public void addAuthorToElement(Element elem, String lastname, String middlename, String firstname, String preposition) {
        if (lastname == null) {
            lastname = "";
        }
        if (middlename == null) {
            middlename = "";
        }
        if (firstname == null) {
            firstname = "";
        }
        if (preposition == null) {
            preposition = "";
        }
        Element e = DomImpl.appendElement(elem, TAGNAME, PREFIX);
        Element fe = DomImpl.createElement(elem, "firstname", PREFIX);
        DomImpl.setElementText(fe, firstname);
        Element me = DomImpl.createElement(elem, "middlename", PREFIX);
        DomImpl.setElementText(me, middlename);
        Element pe = DomImpl.createElement(elem, "preposition", PREFIX);
        DomImpl.setElementText(pe, preposition);
        Element le = DomImpl.createElement(elem, "lastname", PREFIX);
        DomImpl.setElementText(le, lastname);
        e.appendChild(pe);
        e.appendChild(le);
        e.appendChild(me);
        e.appendChild(fe);
    }

    @Override
    public ArrayList<String> getMultiText(Element elem) {
        ArrayList<String> al = new ArrayList<String>();
        ArrayList<Element> elems = DataDomImpl.getElements(elem, TAGNAME, PREFIX);
        int i = 0;
        while (i < elems.size()) {
            Element e = elems.get(i);
            ArrayList<Element> fnl = DomImpl.getElements(e, "firstname", PREFIX);
            String firstname = fnl.size() > 0 ? DomImpl.getElementText(fnl.get(0)) : "";
            ArrayList<Element> lnl = DomImpl.getElements(e, "lastname", PREFIX);
            String lastname = lnl.size() > 0 ? DomImpl.getElementText(lnl.get(0)) : "";
            String item = "";
            item = firstname.length() > 0 ? (lastname.length() > 0 ? String.valueOf(lastname) + " " + firstname : firstname) : lastname;
            if (item.trim().length() > 0) {
                al.add(item);
            }
            ++i;
        }
        return al;
    }

    @Override
    public ArrayList<String> getIndexValues(Element elem, String abc) {
        ArrayList<String> al = new ArrayList<String>();
        ArrayList<Element> elems = DataDomImpl.getElements(elem, TAGNAME, PREFIX);
        int i = 0;
        while (i < elems.size()) {
            Element e = elems.get(i);
            ArrayList<Element> fnl = DomImpl.getElements(e, "firstname", PREFIX);
            String firstname = fnl.size() > 0 ? DomImpl.getElementText(fnl.get(0)) : "";
            ArrayList<Element> lnl = DomImpl.getElements(e, "lastname", PREFIX);
            String lastname = lnl.size() > 0 ? DomImpl.getElementText(lnl.get(0)) : "";
            String item = "";
            item = firstname.length() > 0 ? (lastname.length() > 0 ? String.valueOf(lastname) + " " + firstname : firstname) : lastname;
            if (item.trim().length() > 0) {
                if (abc != null) {
                    if (item.substring(0, abc.length()).compareToIgnoreCase(abc) == 0) {
                        al.add(item);
                    }
                } else {
                    al.add(item);
                }
            }
            ++i;
        }
        return al;
    }

    @Override
    public ArrayList<String> getIndexABC(Element elem) {
        ArrayList<String> al = new ArrayList<String>();
        ArrayList<Element> elems = DataDomImpl.getElements(elem, TAGNAME, PREFIX);
        int i = 0;
        while (i < elems.size()) {
            Element e = elems.get(i);
            ArrayList<Element> fnl = DomImpl.getElements(e, "firstname", PREFIX);
            String firstname = fnl.size() > 0 ? DomImpl.getElementText(fnl.get(0)) : "";
            ArrayList<Element> lnl = DomImpl.getElements(e, "lastname", PREFIX);
            String lastname = lnl.size() > 0 ? DomImpl.getElementText(lnl.get(0)) : "";
            String item = "";
            item = firstname.length() > 0 ? (lastname.length() > 0 ? String.valueOf(lastname) + " " + firstname : firstname) : lastname;
            if (item.trim().length() > 0) {
                String abc = item.substring(0, 1).toUpperCase();
                al.add(abc);
            }
            ++i;
        }
        return al;
    }

    @Override
    public String getMessage() {
        return MESSAGE;
    }
}

