/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.actions;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.DataExtractorPlugin;
import jp.sourceforge.concierge.plugin.IFileFilter;
import jp.sourceforge.concierge.util.CCGFileUtils;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.widget.ImageListDialog;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;

public class SelectImageAction
implements IViewActionDelegate {
    private final int MAXWIDTH = 200;
    private final int MAXHEIGHT = 200;
    private Document document = null;

    private int getImageType(String ext) {
        if (ext.compareToIgnoreCase("bmp") == 0) {
            return 0;
        }
        if (ext.compareToIgnoreCase("jpg") == 0 || ext.compareToIgnoreCase("jpeg") == 0) {
            return 4;
        }
        if (ext.compareToIgnoreCase("png") == 0) {
            return 5;
        }
        if (ext.compareToIgnoreCase("gif") == 0) {
            return 2;
        }
        if (ext.compareToIgnoreCase("tif") == 0 || ext.compareToIgnoreCase("tiff") == 0) {
            return 6;
        }
        return 0;
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.document == null) {
            return;
        }
        String path = DataDomImpl.getFilePath(this.document);
        if (path == null || path.length() == 0) {
            return;
        }
        ArrayList imgs = null;
        IFileFilter ff = DataExtractorPlugin.getFilter((String)path);
        if (ff != null) {
            imgs = ff.getImages();
        }
        Image img = null;
        int imgtype = 0;
        if (imgs != null && imgs.size() > 0) {
            ImageListDialog ildlg = new ImageListDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            ildlg.setImages(imgs);
            Image cimg = FrameworkPlugin.getThumbnailImage(DomImpl.getID(this.document));
            if (cimg != null) {
                ildlg.setSelectedImage(cimg);
                cimg.dispose();
            }
            ildlg.open();
            img = ildlg.getImage();
            int i = 0;
            while (i < imgs.size()) {
                Image im = (Image)imgs.get(i);
                if (!im.isDisposed()) {
                    im.dispose();
                }
                ++i;
            }
            if (img == null) {
                return;
            }
        } else {
            FileDialog fd = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
            fd.setText("Specify image used as thumbnail");
            fd.setFilterExtensions(new String[]{"*.bmp", "*.png", "*.gif", "*.jpg;*.jpeg", "*.tif;*.tiff"});
            fd.setFilterNames(new String[]{"Windows Bitmap(*.bmp)", "PNG(*.png)", "GIF(*.gif)", "JPEG(*.jpg, *.jpeg)", "TIFF(*.tif, *.tiff)"});
            String imgp = fd.open();
            if (imgp == null || imgp.length() == 0) {
                return;
            }
            try {
                img = new Image((Device)PlatformUI.getWorkbench().getDisplay(), imgp);
            }
            catch (Throwable throwable) {
                return;
            }
            imgtype = this.getImageType(FilenameUtils.getExtension((String)imgp));
        }
        Image nimg = GraphicUtil.getResizedImage(img, 200, 200);
        FrameworkPlugin.setThumbnailImage(nimg, DomImpl.getID(this.document), imgtype);
        nimg.dispose();
        img.dispose();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel == null || sel.size() == 0) {
            this.document = null;
            return;
        }
        this.document = (Document)sel.getFirstElement();
        String path = DataDomImpl.getFilePath(this.document);
        if (CCGFileUtils.isImage(path) || CCGFileUtils.isHtml(path)) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
        }
    }
}

