/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import com.ibm.icu.text.BreakIterator;
import java.text.CharacterIterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class DefaultTextDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private DocumentCharacterIterator fDocIter = new DocumentCharacterIterator();

    public void doubleClicked(ITextViewer text) {
        int position = text.getSelectedRange().x;
        if (position < 0) {
            return;
        }
        try {
            int end;
            IDocument document = text.getDocument();
            IRegion line = document.getLineInformationOfOffset(position);
            if (position == line.getOffset() + line.getLength()) {
                return;
            }
            this.fDocIter.setDocument(document, line);
            BreakIterator breakIter = BreakIterator.getWordInstance();
            breakIter.setText((CharacterIterator)this.fDocIter);
            int start = breakIter.preceding(position);
            if (start == -1) {
                start = line.getOffset();
            }
            if ((end = breakIter.following(position)) == -1) {
                end = line.getOffset() + line.getLength();
            }
            if (breakIter.isBoundary(position)) {
                if (end - position > position - start) {
                    start = position;
                } else {
                    end = position;
                }
            }
            if (start != end) {
                text.setSelectedRange(start, end - start);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    static class DocumentCharacterIterator
    implements CharacterIterator {
        private IDocument fDocument;
        private int fOffset = -1;
        private int fEndOffset = -1;
        private int fIndex = -1;

        public void setDocument(IDocument document, IRegion iteratorRange) {
            this.fDocument = document;
            this.fOffset = iteratorRange.getOffset();
            this.fEndOffset = this.fOffset + iteratorRange.getLength();
        }

        public char first() {
            this.fIndex = this.fOffset;
            return this.current();
        }

        public char last() {
            this.fIndex = this.fOffset < this.fEndOffset ? this.fEndOffset - 1 : this.fEndOffset;
            return this.current();
        }

        public char current() {
            if (this.fOffset <= this.fIndex && this.fIndex < this.fEndOffset) {
                try {
                    return this.fDocument.getChar(this.fIndex);
                }
                catch (BadLocationException badLocationException) {}
            }
            return '\uffff';
        }

        public char next() {
            ++this.fIndex;
            int end = this.getEndIndex();
            if (this.fIndex >= end) {
                this.fIndex = end;
                return '\uffff';
            }
            return this.current();
        }

        public char previous() {
            if (this.fIndex == this.fOffset) {
                return '\uffff';
            }
            if (this.fIndex > this.fOffset) {
                --this.fIndex;
            }
            return this.current();
        }

        public char setIndex(int index) {
            this.fIndex = index;
            return this.current();
        }

        public int getBeginIndex() {
            return this.fOffset;
        }

        public int getEndIndex() {
            return this.fEndOffset;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public Object clone() {
            DocumentCharacterIterator i = new DocumentCharacterIterator();
            i.fDocument = this.fDocument;
            i.fIndex = this.fIndex;
            i.fOffset = this.fOffset;
            i.fEndOffset = this.fEndOffset;
            return i;
        }
    }
}

