/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.connection.ConnectionFactory;
import org.eclipse.update.internal.security.KeystoreHandle;

public class KeyStores {
    private static final String JAVA_POLICY_URL = "policy.url.";
    private static final String DEFAULT_KEYSTORE_TYPE = "keystore.type";
    private List listOfKeyStores;
    private Iterator iterator;

    public KeyStores() {
        this.initializeDefaultKeyStores();
    }

    private Iterator getIterator() {
        if (this.iterator == null) {
            this.iterator = this.listOfKeyStores.iterator();
        }
        return this.iterator;
    }

    public boolean hasNext() {
        return this.getIterator().hasNext();
    }

    private void initializeDefaultKeyStores() {
        URL url;
        this.listOfKeyStores = new ArrayList(5);
        try {
            url = new URL("file", null, 0, String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts");
            this.listOfKeyStores.add(new KeystoreHandle(url, Security.getProperty(DEFAULT_KEYSTORE_TYPE)));
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            url = new URL("file", null, 0, String.valueOf(System.getProperty("user.home")) + File.separator + ".keystore");
            this.listOfKeyStores.add(new KeystoreHandle(url, Security.getProperty(DEFAULT_KEYSTORE_TYPE)));
        }
        catch (MalformedURLException malformedURLException) {}
        int index = 1;
        String java_policy = Security.getProperty(JAVA_POLICY_URL + index);
        while (java_policy != null) {
            KeystoreHandle keystore = this.getKeystoreFromLocation(java_policy);
            if (keystore != null) {
                this.listOfKeyStores.add(keystore);
            }
            java_policy = Security.getProperty(JAVA_POLICY_URL + ++index);
        }
    }

    public KeystoreHandle next() {
        return (KeystoreHandle)this.getIterator().next();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeystoreHandle getKeystoreFromLocation(String location) {
        InputStream in;
        block18: {
            String content;
            int indexOfKeystore;
            in = null;
            char[] buff = new char[4096];
            int indexOf$ = location.indexOf("${");
            int indexOfCurly = location.indexOf(125, indexOf$);
            if (indexOf$ != -1 && indexOfCurly != -1) {
                String prop = System.getProperty(location.substring(indexOf$ + 2, indexOfCurly));
                String location2 = location.substring(0, indexOf$);
                location2 = String.valueOf(location2) + prop;
                location = location2 = String.valueOf(location2) + location.substring(indexOfCurly + 1);
            }
            URL url = new URL(location);
            in = ConnectionFactory.get(url).getInputStream();
            InputStreamReader reader = new InputStreamReader(in);
            int result = reader.read(buff);
            StringBuffer contentBuff = new StringBuffer();
            while (result != -1) {
                contentBuff.append(buff, 0, result);
                result = reader.read(buff);
            }
            if (contentBuff.length() <= 0 || (indexOfKeystore = (content = new String(contentBuff)).indexOf("keystore")) == -1) break block18;
            int indexOfSemiColumn = content.indexOf(59, indexOfKeystore);
            KeystoreHandle keystoreHandle = this.getKeystoreFromString(content.substring(indexOfKeystore, indexOfSemiColumn), url);
            if (in == null) return keystoreHandle;
            try {
                in.close();
                return keystoreHandle;
            }
            catch (IOException iOException) {}
            return keystoreHandle;
            catch (MalformedURLException e) {
                this.log(e);
                if (in == null) return null;
                try {
                    in.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
            catch (IOException e2) {
                this.log(e2);
                if (in == null) return null;
                {
                    catch (Throwable throwable) {
                        if (in == null) throw throwable;
                        try {
                            in.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {
                    in.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        if (in == null) return null;
        try {
            in.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    private KeystoreHandle getKeystoreFromString(String content, URL rootURL) {
        KeystoreHandle handle = null;
        String keyStoreType = Security.getProperty(DEFAULT_KEYSTORE_TYPE);
        int indexOfSpace = content.indexOf(32);
        if (indexOfSpace == -1) {
            return null;
        }
        int secondSpace = content.lastIndexOf(44);
        if (secondSpace == -1) {
            secondSpace = content.length();
        } else {
            keyStoreType = content.substring(secondSpace + 1, content.length()).trim();
        }
        URL url = null;
        try {
            url = new URL(content.substring(indexOfSpace, secondSpace));
        }
        catch (MalformedURLException e) {
            this.log(e);
            try {
                url = new URL(rootURL, content.substring(indexOfSpace, secondSpace));
            }
            catch (MalformedURLException e1) {
                this.log(e1);
            }
        }
        if (url != null) {
            handle = new KeystoreHandle(url, keyStoreType);
        }
        return handle;
    }

    private void log(Exception e) {
        UpdateCore.warn("Cannot retrieve a KeyStore", e);
    }
}

