/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.util.ZipFileUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;

public class XMLWriter {
    public static void DocToXMLFile(Document doc, File outFile) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource domSource = new DOMSource();
            domSource.setNode(doc);
            StreamResult result = new StreamResult();
            result.setOutputStream(new FileOutputStream(outFile));
            transformer.transform(domSource, result);
            result.getOutputStream().close();
        }
        catch (Exception exception) {}
    }

    public static void DocToZipFile(Document doc, String entryName, File outFile) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource domSource = new DOMSource();
            domSource.setNode(doc);
            StreamResult result = new StreamResult();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            result.setOutputStream(baos);
            transformer.transform(domSource, result);
            ZipFileUtil.ByteArrayOutputStreamToZipFile(baos, entryName, outFile);
            result.getOutputStream().close();
        }
        catch (Exception exception) {}
    }

    public static void DocToZipFileWithHead(Document doc, String entryName, File outFile) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource domSource = new DOMSource();
            domSource.setNode(doc);
            StreamResult result = new StreamResult();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            result.setOutputStream(baos);
            transformer.transform(domSource, result);
            ByteArrayOutputStream tos = null;
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            ByteArrayInputStream bais = null;
            try {
                int count;
                byte[] buff;
                byte[] buf = baos.toByteArray();
                bais = new ByteArrayInputStream(buf);
                tos = new ByteArrayOutputStream();
                zos = new ZipOutputStream(tos);
                ZipEntry ze = null;
                try {
                    ze = new ZipEntry(entryName);
                    zos.putNextEntry(ze);
                    buff = new byte[0x100000];
                    while ((count = bais.read(buff, 0, 0x100000)) != -1) {
                        zos.write(buff, 0, count);
                    }
                    zos.closeEntry();
                    buff = null;
                }
                catch (Exception exception) {}
                zos.finish();
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (Exception exception) {}
                    bais = null;
                }
                if (tos != null) {
                    try {
                        tos.close();
                    }
                    catch (Exception exception) {}
                    tos = null;
                }
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (Exception exception) {}
                    zos = null;
                }
                fos = new FileOutputStream(outFile);
                zos = new ZipOutputStream(fos);
                bais = new ByteArrayInputStream(buf);
                try {
                    zos.putNextEntry(ze);
                    buff = new byte[0x100000];
                    while ((count = bais.read(buff, 0, 0x100000)) != -1) {
                        zos.write(buff, 0, count);
                    }
                    zos.closeEntry();
                    buff = null;
                }
                catch (Exception exception) {}
                zos.finish();
            }
            catch (Exception exception) {}
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (Exception exception) {}
                bais = null;
            }
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception exception) {}
                zos = null;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
            result.getOutputStream().close();
        }
        catch (Exception exception) {}
    }

    public static void DocsToZipFileWithHead(ArrayList<Document> docs, File outFile) {
        block32: {
            ZipOutputStream zosAll = null;
            FileOutputStream fos = null;
            try {
                int i = 0;
                while (i < docs.size()) {
                    try {
                        Document doc = docs.get(i);
                        String entryName = String.valueOf(String.valueOf(i)) + ".xml";
                        TransformerFactory tf = TransformerFactory.newInstance();
                        Transformer transformer = tf.newTransformer();
                        DOMSource domSource = new DOMSource();
                        domSource.setNode(doc);
                        StreamResult result = new StreamResult();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        result.setOutputStream(baos);
                        transformer.transform(domSource, result);
                        ByteArrayOutputStream tos = null;
                        ZipOutputStream zos = null;
                        ByteArrayInputStream bais = null;
                        try {
                            int count;
                            byte[] buff;
                            byte[] buf = baos.toByteArray();
                            bais = new ByteArrayInputStream(buf);
                            tos = new ByteArrayOutputStream();
                            zos = new ZipOutputStream(tos);
                            ZipEntry ze = null;
                            try {
                                ze = new ZipEntry(entryName);
                                zos.putNextEntry(ze);
                                buff = new byte[0x100000];
                                while ((count = bais.read(buff, 0, 0x100000)) != -1) {
                                    zos.write(buff, 0, count);
                                }
                                zos.closeEntry();
                                buff = null;
                            }
                            catch (Exception exception) {}
                            zos.finish();
                            if (bais != null) {
                                try {
                                    bais.close();
                                }
                                catch (Exception exception) {}
                                bais = null;
                            }
                            if (tos != null) {
                                try {
                                    tos.close();
                                }
                                catch (Exception exception) {}
                                tos = null;
                            }
                            if (zos != null) {
                                try {
                                    zos.close();
                                }
                                catch (Exception exception) {}
                                zos = null;
                            }
                            if (fos == null) {
                                fos = new FileOutputStream(outFile);
                            }
                            if (zosAll == null) {
                                zosAll = new ZipOutputStream(fos);
                            }
                            bais = new ByteArrayInputStream(buf);
                            try {
                                zosAll.putNextEntry(ze);
                                buff = new byte[0x100000];
                                while ((count = bais.read(buff, 0, 0x100000)) != -1) {
                                    zosAll.write(buff, 0, count);
                                }
                                zosAll.closeEntry();
                                buff = null;
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception exception) {}
                        if (bais != null) {
                            try {
                                bais.close();
                            }
                            catch (Exception exception) {}
                            bais = null;
                        }
                        result.getOutputStream().close();
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                zosAll.finish();
                if (zosAll != null) {
                    try {
                        zosAll.close();
                    }
                    catch (Exception exception) {}
                    zosAll = null;
                }
                if (fos == null) break block32;
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
            catch (Exception exception) {}
        }
    }

    public static String SaveXMLFileDialog(Shell shell) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterNames(new String[]{FrameworkPlugin.getString("XMLWriter.1"), FrameworkPlugin.getString("XMLWriter.2")});
        dialog.setFilterExtensions(new String[]{"*.xml", "."});
        Date dNow = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dialog.setFileName(String.valueOf(dateFormat.format(dNow)) + ".xml");
        dialog.setText(FrameworkPlugin.getString("XMLWriter.0"));
        String resultPath = dialog.open();
        return resultPath;
    }

    public static void ExportDataDocumentToZipFileWithProgress(ArrayList<Document> docs, File outFile, Shell shell) {
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            ZipWithProgress runnable = new ZipWithProgress(docs, outFile);
            pmd.run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {}
    }

    public static void ExportDataDocumentToZipFile(ArrayList<Document> docs, File outFile, IProgressMonitor monitor) throws Exception {
        if (outFile == null || docs == null) {
            return;
        }
        if (docs.size() == 0) {
            return;
        }
        ZipOutputStream zosAll = null;
        FileOutputStream fos = null;
        try {
            try {
                if (fos == null) {
                    fos = new FileOutputStream(outFile);
                }
                if (zosAll == null) {
                    zosAll = new ZipOutputStream(fos);
                }
                zosAll.putNextEntry(new ZipEntry("xml" + ZipFileUtil.separator));
                zosAll.putNextEntry(new ZipEntry("files" + ZipFileUtil.separator));
                zosAll.closeEntry();
                int i = 0;
                while (i < docs.size()) {
                    block81: {
                        long id;
                        Document doc;
                        block80: {
                            doc = docs.get(i);
                            id = DomImpl.getID(doc);
                            try {
                                StreamResult result = null;
                                try {
                                    try {
                                        String entryName = "xml" + ZipFileUtil.separator + String.valueOf(id) + ".xml";
                                        TransformerFactory tf = TransformerFactory.newInstance();
                                        Transformer transformer = tf.newTransformer();
                                        DOMSource domSource = new DOMSource();
                                        domSource.setNode(doc);
                                        result = new StreamResult();
                                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                        result.setOutputStream(baos);
                                        transformer.transform(domSource, result);
                                        ByteArrayInputStream bais = null;
                                        try {
                                            try {
                                                byte[] data = baos.toByteArray();
                                                bais = new ByteArrayInputStream(data);
                                                ZipEntry ze = ZipFileUtil.createTempZipEntry(entryName, bais, 0L, null);
                                                if (bais != null) {
                                                    try {
                                                        bais.close();
                                                    }
                                                    catch (Exception exception) {}
                                                    bais = null;
                                                }
                                                if (fos == null) {
                                                    fos = new FileOutputStream(outFile);
                                                }
                                                if (zosAll == null) {
                                                    zosAll = new ZipOutputStream(fos);
                                                }
                                                bais = new ByteArrayInputStream(data);
                                                ZipFileUtil.writeZipOutputStream(zosAll, ze, bais, null);
                                            }
                                            catch (InterruptedException excp) {
                                                throw excp;
                                            }
                                            catch (IOException excp) {
                                                throw excp;
                                            }
                                            catch (Exception excp) {
                                                throw excp;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            if (bais != null) {
                                                try {
                                                    bais.close();
                                                }
                                                catch (Exception exception) {}
                                                bais = null;
                                            }
                                            throw throwable;
                                        }
                                        if (bais == null) break block80;
                                        try {
                                            bais.close();
                                        }
                                        catch (Exception exception) {}
                                        bais = null;
                                    }
                                    catch (InterruptedException excp) {
                                        throw excp;
                                    }
                                    catch (IOException excp) {
                                        throw excp;
                                    }
                                    catch (Exception excp) {
                                        throw excp;
                                    }
                                }
                                finally {
                                    if (result != null) {
                                        result.getOutputStream().close();
                                        result = null;
                                    }
                                }
                            }
                            catch (InterruptedException excp) {
                                throw excp;
                            }
                            catch (IOException excp) {
                                throw excp;
                            }
                            catch (Exception excp) {
                                throw excp;
                            }
                        }
                        try {
                            File srcFile;
                            String srcPath = DataDomImpl.getFilePath(doc);
                            if (srcPath == null || srcPath.length() <= 0 || !(srcFile = new File(srcPath)).exists()) break block81;
                            String entryName = "files" + ZipFileUtil.separator + String.valueOf(id);
                            if (srcFile.isFile()) {
                                String extension;
                                String filename = DataDomImpl.getFileName(doc);
                                if (filename != null && (extension = FilenameUtils.getExtension((String)filename)) != null && extension.length() > 0) {
                                    entryName = String.valueOf(entryName) + "." + extension;
                                }
                                FileInputStream fis = null;
                                BufferedInputStream bis = null;
                                try {
                                    fis = new FileInputStream(srcFile);
                                    bis = new BufferedInputStream(fis);
                                    ZipEntry ze = ZipFileUtil.createTempZipEntry(entryName, bis, srcFile.lastModified(), null);
                                    if (bis != null) {
                                        try {
                                            bis.close();
                                        }
                                        catch (Exception exception) {}
                                        bis = null;
                                    }
                                    if (fis != null) {
                                        try {
                                            fis.close();
                                        }
                                        catch (Exception exception) {}
                                        fis = null;
                                    }
                                    fis = new FileInputStream(srcFile);
                                    bis = new BufferedInputStream(fis);
                                    ZipFileUtil.writeZipOutputStream(zosAll, ze, bis, null);
                                }
                                catch (Throwable throwable) {
                                    if (bis != null) {
                                        try {
                                            bis.close();
                                        }
                                        catch (Exception exception) {}
                                        bis = null;
                                    }
                                    if (fis != null) {
                                        try {
                                            fis.close();
                                        }
                                        catch (Exception exception) {}
                                        fis = null;
                                    }
                                    throw throwable;
                                }
                                if (bis != null) {
                                    try {
                                        bis.close();
                                    }
                                    catch (Exception exception) {}
                                    bis = null;
                                }
                                if (fis == null) break block81;
                                try {
                                    fis.close();
                                }
                                catch (Exception exception) {}
                                fis = null;
                                break block81;
                            }
                            ZipEntry ze = new ZipEntry(String.valueOf(entryName) + ZipFileUtil.separator);
                            ze.setTime(srcFile.lastModified());
                            zosAll.putNextEntry(ze);
                            zosAll.closeEntry();
                            File[] files = srcFile.listFiles();
                            int j = 0;
                            while (j < files.length) {
                                ZipFileUtil.PutFileInZipOutputStream(zosAll, files[j], String.valueOf(entryName) + ZipFileUtil.separator, null, false);
                                ++j;
                            }
                        }
                        catch (InterruptedException excp) {
                            throw excp;
                        }
                        catch (IOException excp) {
                            throw excp;
                        }
                        catch (Exception excp) {
                            throw excp;
                        }
                    }
                    if (monitor != null) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException("Cancel has been requested.");
                        }
                        monitor.worked(1);
                    }
                    ++i;
                }
                zosAll.finish();
            }
            catch (InterruptedException excp) {
                throw excp;
            }
            catch (IOException excp) {
                throw excp;
            }
            catch (Exception excp) {
                throw excp;
            }
        }
        catch (Throwable throwable) {
            if (zosAll != null) {
                try {
                    zosAll.close();
                }
                catch (Exception exception) {}
                zosAll = null;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
            throw throwable;
        }
        if (zosAll != null) {
            try {
                zosAll.close();
            }
            catch (Exception exception) {}
            zosAll = null;
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (Exception exception) {}
            fos = null;
        }
    }

    public static void ExportDataDocumentToXMLFile(ArrayList<Document> docs, File folder, Shell shell) {
        if (folder != null && docs != null) {
            if (!folder.exists()) {
                folder.mkdir();
            }
            if (folder.isDirectory()) {
                int i = 0;
                while (i < docs.size()) {
                    block16: {
                        try {
                            String extension;
                            File srcFile;
                            String srcPath;
                            Document datadoc = docs.get(i);
                            long id = DomImpl.getID(datadoc);
                            String filename = String.valueOf(String.valueOf(id)) + ".xml";
                            File xmlFile = new File(folder, filename);
                            if (xmlFile.exists()) {
                                String msg = "\"" + filename + FrameworkPlugin.getString("XMLWriter.10");
                                boolean ans = MessageDialog.openQuestion((Shell)shell, (String)FrameworkPlugin.getString("XMLWriter.24"), (String)msg);
                                if (!ans) break block16;
                                xmlFile.delete();
                            }
                            String typename = DataDomImpl.getDefaultType(datadoc);
                            Document typedoc = TypeManager.getTypeDocument(typename);
                            String pluginid = TypeDomImpl.getPluginID(typedoc);
                            String version = TypeDomImpl.getVersion(typedoc);
                            if (pluginid != null) {
                                datadoc.getDocumentElement().setAttribute("pluginid", pluginid);
                            }
                            if (version != null) {
                                datadoc.getDocumentElement().setAttribute("version", version);
                            }
                            XMLWriter.DocToXMLFile(datadoc, xmlFile);
                            if (pluginid != null) {
                                datadoc.getDocumentElement().removeAttribute("pluginid");
                            }
                            if (version != null) {
                                datadoc.getDocumentElement().removeAttribute("version");
                            }
                            if ((srcPath = DataDomImpl.getFilePath(datadoc)) == null || srcPath.length() <= 0 || !(srcFile = new File(srcPath)).exists()) break block16;
                            filename = String.valueOf(id);
                            String originalFilename = DataDomImpl.getFileName(datadoc);
                            if (originalFilename != null && (extension = FilenameUtils.getExtension((String)originalFilename)) != null && extension.length() > 0) {
                                filename = String.valueOf(filename) + "." + extension;
                            }
                            File dstFile = new File(folder, filename);
                            try {
                                if (!srcFile.isFile()) break block16;
                                if (dstFile.exists()) {
                                    String msg = "\"" + filename + FrameworkPlugin.getString("XMLWriter.14");
                                    boolean ans = MessageDialog.openQuestion((Shell)shell, (String)FrameworkPlugin.getString("XMLWriter.15"), (String)msg);
                                    if (!ans) break block16;
                                    dstFile.delete();
                                }
                                FileUtils.copyFile((File)srcFile, (File)dstFile);
                            }
                            catch (Exception e) {
                                System.err.println(e.getMessage());
                            }
                        }
                        catch (Exception exc) {
                            System.err.println(exc.getMessage());
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private static class ZipWithProgress
    implements IRunnableWithProgress {
        private ArrayList<Document> docs = null;
        private File outFile = null;

        public ZipWithProgress(ArrayList<Document> docs, File outFile) {
            this.docs = docs;
            this.outFile = outFile;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Export Data Document", this.docs.size());
            try {
                try {
                    XMLWriter.ExportDataDocumentToZipFile(this.docs, this.outFile, monitor);
                }
                catch (InvocationTargetException excp) {
                    throw excp;
                }
                catch (InterruptedException excp) {
                    throw excp;
                }
                catch (Exception exception) {
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

