/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.util.GraphicUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DatabaseConfigDialog
extends Dialog {
    private ArrayList<String> dbnames = null;
    private static final int BUTTON1 = 10001;
    private static final int BUTTON2 = 10002;
    private static final int BUTTON3 = 10003;
    private Composite root = null;
    private Composite comp1 = null;
    private Composite comp2 = null;
    private CLabel messagelabel = null;
    private Combo dbcombo = null;
    private Text dbpath = null;
    private Button pathbtn = null;
    private Label dblabel = null;
    private Label pathlabel = null;
    private String databasename = null;
    private String databasepath = null;

    protected DatabaseConfigDialog(Shell parentShell, ArrayList<String> dbnames) {
        super(new Shell(parentShell));
        this.dbnames = dbnames;
    }

    protected void buttonPressed(int buttonId) {
        StackLayout sl = (StackLayout)this.root.getLayout();
        Composite comp = (Composite)sl.topControl;
        if (comp.equals(this.comp1)) {
            switch (buttonId) {
                case 10001: {
                    break;
                }
                case 10002: {
                    this.databasename = this.dbcombo.getText();
                    this.databasepath = this.dbpath.getText();
                    this.dblabel.setText(this.databasename);
                    this.pathlabel.setText(this.databasepath);
                    this.getButton(10002).setText("Finish");
                    this.messagelabel.setText("    If OK, click Finish.");
                    sl.topControl = this.comp2;
                    this.getButton(10001).setEnabled(true);
                    this.getButton(10002).setEnabled(true);
                    this.root.layout();
                    break;
                }
                case 10003: {
                    this.setReturnCode(1);
                    this.close();
                }
            }
        } else {
            switch (buttonId) {
                case 10001: {
                    this.messagelabel.setText("    OK.");
                    this.getButton(10002).setText("Next >");
                    sl.topControl = this.comp1;
                    this.root.layout();
                    break;
                }
                case 10002: {
                    this.setReturnCode(0);
                    this.close();
                    break;
                }
                case 10003: {
                    this.setReturnCode(1);
                    this.close();
                }
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btn1 = this.createButton(parent, 10001, "< Back", false);
        Button btn2 = this.createButton(parent, 10002, "Next >", true);
        this.createButton(parent, 10003, "Cancel", false);
        btn1.setEnabled(false);
        btn2.setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite proot = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        proot.setLayout((Layout)gl);
        Composite top = new Composite(proot, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        top.setLayoutData((Object)new GridData(4, 16384, true, false));
        GraphicUtil.setBackground((Control)top, 1);
        Label tl = new Label(top, 0);
        tl.setLayoutData((Object)new GridData(4, 16384, true, false));
        tl.setText("Database configuration");
        GraphicUtil.setBackground((Control)tl, 1);
        Label imgl = new Label(top, 0);
        GridData igd = new GridData(131072, 0x1000000, false, false);
        igd.verticalSpan = 2;
        imgl.setLayoutData((Object)igd);
        imgl.setImage(FrameworkPlugin.getImageDescriptor("icons/wizard.png").createImage());
        GraphicUtil.setBackground((Control)imgl, 1);
        this.messagelabel = new CLabel(top, 0);
        this.messagelabel.setLayoutData((Object)new GridData(4, 16384, true, false));
        this.messagelabel.setText("    Select a database and its location.");
        GraphicUtil.setBackground((Control)this.messagelabel, 1);
        this.root = new Composite(proot, 0);
        this.root.setLayout((Layout)new StackLayout());
        this.root.setLayoutData((Object)new GridData(4, 4, true, true));
        this.comp1 = new Composite(this.root, 0);
        this.comp1.setLayout((Layout)new GridLayout(1, false));
        Group gr1 = new Group(this.comp1, 0);
        gr1.setLayout((Layout)new GridLayout(1, false));
        gr1.setLayoutData((Object)new GridData(4, 16384, true, false));
        gr1.setText("Database");
        this.dbcombo = new Combo((Composite)gr1, 8);
        this.dbcombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        int i = 0;
        while (i < this.dbnames.size()) {
            this.dbcombo.add(this.dbnames.get(i));
            ++i;
        }
        if (this.dbcombo.getItemCount() > 0) {
            this.dbcombo.select(0);
        }
        Group gr2 = new Group(this.comp1, 0);
        gr2.setLayout((Layout)new GridLayout(2, false));
        gr2.setLayoutData((Object)new GridData(4, 4, true, true));
        gr2.setText("Database location");
        this.dbpath = new Text((Composite)gr2, 2048);
        GridData dbgd = new GridData(4, 0x1000000, true, false);
        dbgd.widthHint = 320;
        this.dbpath.setLayoutData((Object)dbgd);
        this.dbpath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DatabaseConfigDialog.this.dbpath.getText().trim().length() == 0) {
                    DatabaseConfigDialog.this.getButton(10002).setEnabled(false);
                    DatabaseConfigDialog.this.messagelabel.setImage(FrameworkPlugin.getImageDescriptor("icons/error.gif").createImage());
                    DatabaseConfigDialog.this.messagelabel.setText("Location is not specified.");
                } else {
                    File f = new File(DatabaseConfigDialog.this.dbpath.getText());
                    if (f.exists()) {
                        DatabaseConfigDialog.this.getButton(10002).setEnabled(true);
                        DatabaseConfigDialog.this.messagelabel.setText("  OK.");
                        DatabaseConfigDialog.this.messagelabel.setImage(null);
                    } else {
                        DatabaseConfigDialog.this.getButton(10002).setEnabled(false);
                        DatabaseConfigDialog.this.messagelabel.setImage(FrameworkPlugin.getImageDescriptor("icons/error.gif").createImage());
                        DatabaseConfigDialog.this.messagelabel.setText("Selected location does not exist.");
                    }
                }
            }
        });
        this.pathbtn = new Button((Composite)gr2, 0);
        this.pathbtn.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.pathbtn.setText("Browse...");
        this.pathbtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(DatabaseConfigDialog.this.root.getShell());
                dd.setMessage("Select database location");
                dd.setText("Database location");
                String path = dd.open();
                if (path != null && path.length() > 0) {
                    DatabaseConfigDialog.this.dbpath.setText(path);
                }
            }
        });
        this.comp2 = new Composite(this.root, 0);
        this.comp2.setLayout((Layout)new GridLayout(1, false));
        Group gr3 = new Group(this.comp2, 0);
        gr3.setLayout((Layout)new GridLayout(2, false));
        gr3.setLayoutData((Object)new GridData(4, 4, true, true));
        gr3.setText("Confirmation of the configuration");
        Label dl = new Label((Composite)gr3, 0);
        dl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        dl.setText("Database:");
        this.dblabel = new Label((Composite)gr3, 0);
        this.dblabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label pl = new Label((Composite)gr3, 0);
        pl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        pl.setText("Location:");
        this.pathlabel = new Label((Composite)gr3, 0);
        this.pathlabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        StackLayout sl = (StackLayout)this.root.getLayout();
        sl.topControl = this.comp1;
        return this.root;
    }

    protected void initializeBounds() {
        this.getShell().setLocation(400, 240);
        this.getShell().setSize(this.getShell().computeSize(-1, -1));
    }

    public String getDatabaseName() {
        return this.databasename;
    }

    public String getDatabaseDirectory() {
        return this.databasepath;
    }
}

