/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.database.cache;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileCache {
    private Hashtable<String, Long> filecache = new Hashtable();

    public void load() {
        Request r = new Request(4, "/ccgconfig[@name='FileCache']", "ccgconfig");
        ArrayList<Document> data = FrameworkPlugin.getDocumentsOfQuery(r);
        if (data == null || data.size() == 0) {
            r = new Request(4, "/", "data");
            ArrayList<Document> mdata = FrameworkPlugin.getDocumentsOfQuery(r);
            int i = 0;
            while (i < mdata.size()) {
                Document doc = mdata.get(i);
                String path = DataDomImpl.getFilePath(doc);
                if (path != null && path.length() != 0) {
                    long id = DomImpl.getID(doc);
                    this.filecache.put(path, id);
                }
                ++i;
            }
        } else {
            Document doc = data.get(0);
            ArrayList<Element> elems = DomImpl.getElements(doc, "file");
            int i = 0;
            while (i < elems.size()) {
                String path = DomImpl.getAttribute(elems.get(i), "path");
                long id = Long.parseLong(DomImpl.getAttribute(elems.get(i), "id"));
                this.filecache.put(path, id);
                ++i;
            }
        }
    }

    public void save() {
        Request r = new Request(4, "/ccgconfig[@name='FileCache']", "ccgconfig");
        ArrayList<Document> data = FrameworkPlugin.getDocumentsOfQuery(r);
        Document doc = null;
        if (data == null || data.size() == 0) {
            doc = DomImpl.createDocument("ccgconfig");
            DomImpl.setAttribute(DomImpl.getRootElement(doc), "name", "FileCache");
        } else {
            doc = data.get(0);
        }
        Element root = DomImpl.getRootElement(doc);
        DomImpl.removeAllChildren(root);
        Set<Map.Entry<String, Long>> set = this.filecache.entrySet();
        for (Map.Entry<String, Long> kv : set) {
            Element elem = DomImpl.appendElement(root, "file");
            DomImpl.setAttribute(elem, "path", kv.getKey());
            DomImpl.setAttribute(elem, "id", kv.getValue().toString());
        }
        r = new Request(3, doc, "ccgconfig");
        FrameworkPlugin.updateDocuments(r, null);
    }

    public void add(String path, long id) {
        this.filecache.put(path, id);
    }

    public void delete(String path) {
        this.filecache.remove(path);
    }

    public Long get(String path) {
        return this.filecache.get(path);
    }
}

