/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.database;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.sourceforge.concierge.database.IDatabaseAdapter;
import jp.sourceforge.concierge.database.IDatabasePlugin;
import jp.sourceforge.concierge.database.xindice.XindiceAdapter;
import org.apache.xindice.client.xmldb.services.CollectionManager;
import org.apache.xindice.xml.dom.DOMParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;

public class XindicePlugin
extends AbstractUIPlugin
implements IDatabasePlugin {
    private static XindicePlugin plugin;
    private static String XINDICE;
    private static String XINDICE_EMBEDDED_URI;
    private Hashtable<String, String> properties = new Hashtable();
    private Hashtable<String, XindiceAdapter> adapters = new Hashtable();
    private Database database = null;
    static final String BUNDLE_NAME = "jp.sourceforge.concierge.database.xindice.messages";
    static final ResourceBundle RESOURCE_BUNDLE;

    static {
        XINDICE = "XML DB (Apache Xindice)";
        XINDICE_EMBEDDED_URI = "xmldb:xindice-embed:///db/";
        RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
    }

    private Collection addCollection(String collectionname) {
        try {
            Collection col = DatabaseManager.getCollection((String)XINDICE_EMBEDDED_URI);
            CollectionManager service = (CollectionManager)col.getService("CollectionManager", "1.0");
            String colstr = "<collection compressed=\"true\" name=\"" + collectionname + "\">" + "   <filer class=\"org.apache.xindice.core.filer.BTreeFiler\"/>" + "</collection>";
            return service.createCollection(collectionname, DOMParser.toDocument((String)colstr));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Collection getCollection(String collectionname) throws Exception {
        String uri = String.valueOf(XINDICE_EMBEDDED_URI) + collectionname;
        Collection col = DatabaseManager.getCollection((String)uri);
        if (col == null) {
            col = this.addCollection(collectionname);
        }
        return col;
    }

    private String openDialog() {
        Display disp = PlatformUI.createDisplay();
        Shell shell = new Shell(disp);
        DirectoryDialog ddlg = new DirectoryDialog(shell);
        ddlg.setText(XindicePlugin.getString("XindicePlugin.8"));
        ddlg.setMessage(XindicePlugin.getString("XindicePlugin.9"));
        String path = ddlg.open();
        shell.dispose();
        return path;
    }

    private void registerDatabase(String dbhome) {
        File f = new File(dbhome);
        if (!f.exists() || !f.isDirectory()) {
            return;
        }
        String driver = "org.apache.xindice.client.xmldb.DatabaseImpl";
        try {
            Class<?> c = Class.forName(driver);
            if (this.database != null) {
                Enumeration<XindiceAdapter> en = this.adapters.elements();
                while (en.hasMoreElements()) {
                    XindiceAdapter xa = en.nextElement();
                    xa.close();
                }
                this.adapters.clear();
                DatabaseManager.deregisterDatabase((Database)this.database);
            }
            this.database = (Database)c.newInstance();
            this.database.setProperty("db-home", dbhome);
            DatabaseManager.registerDatabase((Database)this.database);
        }
        catch (Exception e) {
            this.database = null;
            System.err.println(e.getMessage());
        }
    }

    public XindicePlugin() {
        plugin = this;
        this.properties.put("Database Directory", "");
    }

    public String getDatabaseName() {
        return XINDICE;
    }

    public void setProperty(String property, String value) {
        String oldp = this.properties.get(property);
        if (oldp != null && oldp.compareTo(value) == 0) {
            return;
        }
        this.properties.put(property, value);
        if (this.database == null && property.compareTo("Database Directory") == 0) {
            this.registerDatabase(this.properties.get("Database Directory"));
        }
    }

    public String getProperty(String property) {
        return this.properties.get(property);
    }

    public String getLocalDatabaseDirectory() {
        return String.valueOf(this.properties.get("Database Directory")) + System.getProperty("file.separator") + "db";
    }

    public String getLocalDatabaseDirectory(String parentdir) {
        return String.valueOf(parentdir) + System.getProperty("file.separator") + "db";
    }

    public ArrayList<String> getProperties() {
        ArrayList<String> props = new ArrayList<String>();
        Enumeration<String> e = this.properties.keys();
        while (e.hasMoreElements()) {
            props.add(e.nextElement());
        }
        return props;
    }

    public IDatabaseAdapter getInstance(String collection) {
        String dbhome = this.properties.get("Database Directory");
        if (dbhome == null || dbhome.length() == 0) {
            String path = this.openDialog();
            if (path == null) {
                return null;
            }
            this.properties.put("Database Directory", path);
        } else {
            File dbf = new File(dbhome);
            if (!dbf.isDirectory()) {
                String path = this.openDialog();
                if (path == null) {
                    return null;
                }
                this.properties.put("Database Directory", path);
            }
        }
        if (this.database == null) {
            this.registerDatabase(this.properties.get("Database Directory"));
        }
        try {
            dbhome = this.properties.get("Database Directory");
            String akey = String.valueOf(dbhome) + "-" + collection;
            XindiceAdapter adapter = this.adapters.get(akey);
            if (adapter == null) {
                adapter = new XindiceAdapter(this.getCollection(collection));
                this.adapters.put(akey, adapter);
            }
            return adapter;
        }
        catch (Exception exception) {
            System.err.println("Instance could not be created.");
            return null;
        }
    }

    public String getPropertyDescription(String property) {
        return null;
    }

    public Byte getPropertyType(String property) {
        if (property.compareTo("Database Directory") == 0) {
            return IDatabasePlugin.PROP_TYPE_PATH;
        }
        return IDatabasePlugin.PROP_TYPE_STRING;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(null);
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(XindicePlugin.getString("XindicePlugin.7"), XindicePlugin.this.adapters.size());
                    Enumeration e = XindicePlugin.this.adapters.elements();
                    while (e.hasMoreElements()) {
                        XindiceAdapter adp = (XindiceAdapter)e.nextElement();
                        adp.close();
                        monitor.worked(1);
                    }
                }
            });
        }
        catch (Exception exception) {}
        DatabaseManager.deregisterDatabase((Database)this.database);
        super.stop(context);
        plugin = null;
    }

    public static XindicePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.database.xindice", (String)path);
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }
}

