/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.database.cache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.DataExtractorPlugin;
import jp.sourceforge.concierge.plugin.IFileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.demo.FileJDocument;
import org.apache.lucene.index.IndexWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentCache {
    private String cachedir = null;

    private void indexDocs(IndexWriter writer, File file, String charset) throws Exception {
        if (file.isDirectory()) {
            String[] files = file.list();
            int i = 0;
            while (i < files.length) {
                try {
                    this.indexDocs(writer, new File(file, files[i]), charset);
                }
                catch (Exception exception) {
                    System.err.println("indexing failed: " + file.toString());
                }
                ++i;
            }
        } else {
            writer.addDocument(FileJDocument.Document((File)file, (String)charset));
        }
    }

    public ContentCache(String cachedir) {
        System.setProperty("sen.home", FrameworkPlugin.getDefault().getFilePath("lib"));
        this.cachedir = cachedir;
        File indexdir = new File(String.valueOf(cachedir) + File.separator + "index");
        if (!indexdir.exists()) {
            indexdir.mkdir();
        }
    }

    public void add(String path, long id) {
        String ext = FilenameUtils.getExtension((String)path);
        if (!(ext.equals("xml") || ext.equals("xhtml") || ext.equals("html") || ext.equals("htm"))) {
            return;
        }
        IFileFilter ff = DataExtractorPlugin.getFilter((String)path);
        if (ff == null) {
            return;
        }
        try {
            String str = ff.getText();
            if (str == null) {
                return;
            }
            FileOutputStream fos = new FileOutputStream(new File(String.valueOf(this.cachedir) + File.separator + id + ".txt"));
            fos.write(str.getBytes());
            fos.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public void delete(long id) {
        try {
            File f = new File(String.valueOf(this.cachedir) + File.separator + id + ".txt");
            f.delete();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public ArrayList<String> search(String querystr) {
        File dir = new File(this.cachedir);
        File[] fs = dir.listFiles(new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".txt");
            }
        });
        ArrayList<String> files = new ArrayList<String>();
        String qstr = querystr.toLowerCase();
        int i = 0;
        while (i < fs.length) {
            FileReader fr = null;
            BufferedReader br = null;
            try {
                boolean c = false;
                fr = new FileReader(fs[i]);
                br = new BufferedReader(fr);
                String str = br.readLine();
                while (str != null) {
                    if (str.toLowerCase().contains(qstr)) {
                        c = true;
                        break;
                    }
                    str = br.readLine();
                }
                if (c) {
                    files.add(fs[i].getAbsolutePath());
                }
                br.close();
                fr.close();
                br = null;
                fr = null;
            }
            catch (Exception exception) {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (Exception exception2) {}
            }
            ++i;
        }
        return files;
    }

    public void makeIndex() {
        try {
            String indexdir = String.valueOf(this.cachedir) + File.separator + "index";
            String charset = System.getProperty("file.encoding");
            boolean create = true;
            File root = new File(this.cachedir);
            IndexWriter writer = new IndexWriter(indexdir, (Analyzer)new JapaneseAnalyzer(), create);
            this.indexDocs(writer, root, charset);
            writer.optimize();
            writer.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

