/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.tabulator.indexer;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.sourceforge.concierge.plugin.tabulator.indexer.ClassifyMethod;
import jp.sourceforge.concierge.plugin.tabulator.indexer.SelectionAction;
import jp.sourceforge.concierge.util.GraphicUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemList {
    private TableViewer viewer;
    private SelectionAction action = null;
    private ClassifyMethod classify = null;
    private Hashtable<String, ArrayList<Document>> classlist = null;
    private ISelectionChangedListener selectionListener = null;

    private void show() {
        if (this.classlist == null) {
            return;
        }
        Enumeration<String> e = this.classlist.keys();
        while (e.hasMoreElements()) {
            this.viewer.add((Object)e.nextElement());
        }
    }

    public ItemList(Composite parent, boolean sort) {
        GridLayout gl = new GridLayout(1, true);
        gl.marginWidth = 1;
        gl.marginHeight = 1;
        gl.verticalSpacing = 1;
        gl.horizontalSpacing = 1;
        parent.setLayout((Layout)gl);
        GraphicUtil.setBackground((Control)parent, (int)1);
        this.viewer = new TableViewer(parent, 68096);
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        if (sort) {
            this.viewer.setSorter(new ViewerSorter());
        }
        this.selectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = ItemList.this.viewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                String selstr = (String)((IStructuredSelection)selection).getFirstElement();
                if (ItemList.this.action != null) {
                    ItemList.this.action.run(selstr, (ArrayList)ItemList.this.classlist.get(selstr));
                }
            }
        };
        this.viewer.addSelectionChangedListener(this.selectionListener);
        new TableColumn(this.viewer.getTable(), 16384, 0);
        this.viewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                Rectangle r = table.getClientArea();
                TableColumn[] col = table.getColumns();
                if (col.length > 0) {
                    col[0].setWidth(r.width);
                }
            }
        });
    }

    public void setClassifyMethod(ClassifyMethod cm) {
        this.classify = cm;
    }

    public void setAction(SelectionAction act) {
        this.action = act;
    }

    public void setDocuments(ArrayList<Document> docs) {
        this.clear();
        if (this.classify != null) {
            this.classlist = this.classify.classify(docs);
        }
        this.viewer.getTable().removeAll();
        this.show();
    }

    public boolean setSelection(String sel) {
        this.viewer.removeSelectionChangedListener(this.selectionListener);
        boolean selectable = false;
        int idx = -1;
        int i = 0;
        while (i < this.viewer.getTable().getItemCount()) {
            String str = (String)this.viewer.getElementAt(i);
            if (str.equals(sel)) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx >= 0) {
            this.viewer.getTable().select(idx);
            this.action.run(sel, this.classlist.get(sel));
            selectable = true;
        }
        this.viewer.addSelectionChangedListener(this.selectionListener);
        return selectable;
    }

    public String getSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        if (sel.isEmpty()) {
            return null;
        }
        return (String)sel.getFirstElement();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void clear() {
        this.viewer.getTable().removeAll();
        if (this.classlist != null) {
            this.classlist.clear();
            this.classlist = null;
        }
    }

    public void deselect() {
        this.viewer.getTable().deselectAll();
    }
}

