/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.filters;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.IFileFilter;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.eclipse.swt.graphics.Image;

public abstract class OfficeFilter
implements IFileFilter {
    protected POIFSFileSystem poifs = null;
    protected String filename = null;

    public OfficeFilter(String file) throws IOException {
        this.poifs = new POIFSFileSystem((InputStream)new FileInputStream(file));
        this.filename = file;
    }

    @Override
    public String[] getDataNames() {
        return new String[]{"Title", "Author", "Subject", "Keywords", "Comment", "Creation Date", "Modification Date"};
    }

    @Override
    public String getData(String name) {
        try {
            DirectoryNode root = this.poifs.getRoot();
            DocumentEntry sie = (DocumentEntry)root.getEntry("\u0005SummaryInformation");
            DocumentInputStream dis = new DocumentInputStream(sie);
            PropertySet ps = new PropertySet((InputStream)dis);
            dis.close();
            SummaryInformation si = new SummaryInformation(ps);
            if (name.equals("Title")) {
                return si.getTitle();
            }
            if (name.equals("Author")) {
                return si.getAuthor();
            }
            if (name.equals("Subject")) {
                return si.getSubject();
            }
            if (name.equals("Keywords")) {
                return si.getKeywords();
            }
            if (name.equals("Comment")) {
                return si.getComments();
            }
            if (name.equals("Creation Date")) {
                return si.getCreateDateTime().toString();
            }
            if (name.equals("Modification Date")) {
                return si.getLastSaveDateTime().toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public abstract ArrayList<Image> getImages();

    @Override
    public void setThumbnail(Image img) {
    }
}

