/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote.styledtexteditor;

import java.io.File;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.ImageUtils;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.Memo;
import jp.sourceforge.concierge.util.CCGFileUtils;
import jp.sourceforge.concierge.util.GraphicUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EmbeddedObject {
    private static String metaimg = LabNotePlugin.getDefault().getFilePath("icons/metadata.gif");
    private static String fileimg = LabNotePlugin.getDefault().getFilePath("icons/noimgfile.gif");
    private int offset;
    private String filename;
    private Document document;
    private Point size;
    private Image objectimage;
    private Image memoimage = null;
    private Image overlayedimage = null;
    private String imagefile;

    protected void finalize() throws Throwable {
        this.disposeImage(this.objectimage);
        this.disposeImage(this.memoimage);
        super.finalize();
    }

    private Element createElement(Document html, String asrc, String aalt, String imgsrc, String imgalt) {
        Element a = html.createElement("a");
        if (asrc != null) {
            a.setAttribute("href", asrc);
        }
        if (aalt != null) {
            a.setAttribute("alt", aalt);
        }
        Element img = html.createElement("img");
        img.setAttribute("src", imgsrc);
        if (imgalt != null) {
            img.setAttribute("alt", imgalt);
        }
        img.setAttribute("width", String.valueOf(this.size.x));
        img.setAttribute("height", String.valueOf(this.size.y));
        a.appendChild(img);
        return a;
    }

    private void disposeImage(Image img) {
        if (img != null && !img.isDisposed()) {
            img.dispose();
        }
    }

    private void initImage(String path, boolean hasdoc) {
        boolean exists = new File(path).exists();
        this.objectimage = CCGFileUtils.isImage((String)path) && exists ? new Image((Device)PlatformUI.getWorkbench().getDisplay(), path) : (hasdoc ? new Image((Device)PlatformUI.getWorkbench().getDisplay(), metaimg) : new Image((Device)PlatformUI.getWorkbench().getDisplay(), fileimg));
        Rectangle r = this.objectimage.getBounds();
        this.size = new Point(r.width, r.height);
    }

    public static EmbeddedObject createInstance(Element elema) {
        String imgalt;
        String imgsrc;
        NodeList cn;
        block11: {
            String aalt;
            block10: {
                try {
                    aalt = elema.getAttribute("alt");
                    cn = elema.getElementsByTagName("img");
                    if (cn.getLength() != 0) break block10;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            imgsrc = ((Element)cn.item(0)).getAttribute("src");
            imgalt = ((Element)cn.item(0)).getAttribute("alt");
            if (aalt == null || aalt.length() <= 0) break block11;
            long docid = Long.parseLong(aalt);
            Document doc = FrameworkPlugin.getDocumentByID((String)"data", (long)docid);
            if (doc != null) {
                return new EmbeddedObject(doc, imgsrc);
            }
            return null;
        }
        String asrc = elema.getAttribute("src");
        String w = ((Element)cn.item(0)).getAttribute("width");
        String h = ((Element)cn.item(0)).getAttribute("height");
        EmbeddedObject eo = null;
        if (asrc != null && asrc.length() > 0) {
            eo = new EmbeddedObject(asrc, imgsrc);
        } else {
            assert (imgalt != null && imgalt.length() > 0);
            eo = new EmbeddedObject(imgalt);
            String memofile = Memo.getMemoImagePath((String)imgalt);
            if (new File(memofile).exists()) {
                eo.setMemoImage(memofile);
            }
        }
        if (w != null && w.length() > 0 && h != null && h.length() > 0) {
            Point sz = new Point(Integer.parseInt(w), Integer.parseInt(h));
            eo.setSize(sz);
        }
        return eo;
    }

    private void setMemoImage(String memofile) {
        this.disposeImage(this.memoimage);
        this.memoimage = ImageUtils.loadMemoImage((Display)PlatformUI.getWorkbench().getDisplay(), (String)memofile);
    }

    private void createOverlayedImage() {
        this.overlayedimage = new Image((Device)PlatformUI.getWorkbench().getDisplay(), this.objectimage.getImageData());
        if (this.memoimage != null && !this.memoimage.isDisposed()) {
            GC gc = new GC((Drawable)this.overlayedimage);
            gc.drawImage(this.memoimage, 0, 0);
            gc.dispose();
        }
    }

    private EmbeddedObject(String orgfile, String imgfile) {
        this.document = null;
        this.filename = orgfile;
        this.initImage(imgfile, false);
        this.imagefile = imgfile;
    }

    private EmbeddedObject(Document doc, String imgfile) {
        this.document = doc;
        this.filename = DataDomImpl.getFilePath((Document)doc);
        this.initImage(imgfile, true);
        this.imagefile = imgfile;
    }

    public EmbeddedObject(Document doc) {
        this.document = doc;
        this.filename = DataDomImpl.getFilePath((Document)doc);
        this.initImage(this.filename, true);
        this.imagefile = CCGFileUtils.isImage((String)this.filename) ? this.filename : metaimg;
    }

    public EmbeddedObject(String path) {
        this.document = null;
        this.filename = path;
        this.initImage(this.filename, false);
        this.imagefile = CCGFileUtils.isImage((String)this.filename) ? this.filename : fileimg;
    }

    public void setImage(Image img, Image memo) {
        this.disposeImage(this.objectimage);
        this.objectimage = new Image((Device)PlatformUI.getWorkbench().getDisplay(), img.getImageData());
        this.disposeImage(this.memoimage);
        this.memoimage = memo != null ? new Image((Device)PlatformUI.getWorkbench().getDisplay(), memo.getImageData()) : null;
        this.disposeImage(this.overlayedimage);
        this.createOverlayedImage();
    }

    public Image getOriginalImage() {
        return this.objectimage;
    }

    public Image getMemoImage() {
        return this.memoimage;
    }

    public Image getImage() {
        if (this.overlayedimage == null) {
            this.createOverlayedImage();
        }
        return this.overlayedimage;
    }

    public void setSize(Point sz) {
        this.size = sz;
    }

    public Point getSize() {
        return this.size;
    }

    public void setFile(String path) {
        boolean hasdoc = this.document != null;
        this.disposeImage(this.objectimage);
        this.disposeImage(this.memoimage);
        this.initImage(path, hasdoc);
    }

    public String getFile() {
        return this.filename;
    }

    public void setDocument(Document doc) {
        this.document = doc;
        this.filename = DataDomImpl.getFilePath((Document)doc);
        this.initImage(this.filename, true);
    }

    public Document getDocument() {
        return this.document;
    }

    public Element save(Document html) {
        String asrc = null;
        String aalt = null;
        String imgalt = null;
        String img = null;
        if (this.document != null) {
            asrc = DataDomImpl.getFilePath((Document)this.document);
            aalt = String.valueOf(DomImpl.getID((Document)this.document));
            imgalt = null;
            img = this.imagefile = LabNotePlugin.importImageFile(this.imagefile, DomImpl.getID((Document)this.document));
        } else if (!CCGFileUtils.isImage((String)this.filename)) {
            asrc = this.filename;
            aalt = null;
            imgalt = null;
            img = this.imagefile = LabNotePlugin.importImageFile(this.imagefile, -1L);
        } else {
            asrc = null;
            aalt = null;
            imgalt = this.imagefile = LabNotePlugin.importImageFile(this.imagefile, -1L);
            img = Memo.getOverlayedImagePath((String)this.imagefile);
            if (this.overlayedimage == null) {
                this.createOverlayedImage();
            }
            GraphicUtil.saveImage((Image)this.overlayedimage, (String)img, (int)5);
            if (this.memoimage != null) {
                String memofile = Memo.getMemoImagePath((String)imgalt);
                GraphicUtil.saveImage((Image)this.memoimage, (String)memofile, (int)0);
            }
        }
        return this.createElement(html, asrc, aalt, img, imgalt);
    }

    public boolean resizable() {
        return this.size != null;
    }

    public boolean editable() {
        return true;
    }

    public boolean hasDocument() {
        return this.document != null;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void remove() {
        LabNotePlugin.removeImageFile(this.imagefile);
        String memofile = Memo.getMemoImagePath((String)this.imagefile);
        LabNotePlugin.removeImageFile(memofile);
        String overlayfile = Memo.getOverlayedImagePath((String)this.imagefile);
        LabNotePlugin.removeImageFile(overlayfile);
    }
}

