/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import jp.sourceforge.concierge.plugin.ImageUpdateListener;
import jp.sourceforge.concierge.plugin.Memo;
import jp.sourceforge.concierge.plugin.MemoGraphPlugin;
import jp.sourceforge.concierge.plugin.imageviewer.ColorDialog;
import jp.sourceforge.concierge.plugin.imageviewer.ColorSelectionListener;
import jp.sourceforge.concierge.util.GraphicUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.part.ViewPart;

public class MemoGraph
extends ViewPart {
    private Memo memo = null;
    private Image image = null;
    private Canvas canvas = null;
    private int sc_x = 0;
    private int sc_y = 0;
    private int width = 640;
    private int height = 640;
    private boolean issaved = false;
    private ImageUpdateListener listener = null;
    private ColorDialog colordlg = null;

    public void dispose() {
        try {
            if (!this.issaved && MessageDialog.openConfirm((Shell)this.canvas.getShell(), (String)"Save", (String)"Save anyway?")) {
                this.save();
            }
            if (!this.image.isDisposed()) {
                this.image.dispose();
            }
            this.colordlg.close();
        }
        catch (Throwable throwable) {}
        super.dispose();
    }

    private void configScrollBar(ScrollBar sb, int isz, int csz) {
        if (csz < 20) {
            return;
        }
        if (isz + 20 > csz) {
            sb.setThumb(csz - 20);
        } else {
            sb.setThumb(isz);
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite root = new Composite(parent, 0);
        root.setLayoutData((Object)new GridData(4, 4, true, true));
        root.setLayout((Layout)new GridLayout(1, true));
        ToolBar tb = new ToolBar(root, 0);
        tb.setLayoutData((Object)new GridData(131072, 0, false, false));
        ToolItem ti = new ToolItem(tb, 8);
        ti.setImage(MemoGraphPlugin.getImageDescriptor("icons/save.png").createImage());
        ti.setToolTipText("Save");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MemoGraph.this.save();
            }
        });
        ti = new ToolItem(tb, 8);
        ti.setImage(MemoGraphPlugin.getImageDescriptor("icons/color.png").createImage());
        ti.setToolTipText("Show color");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    if (MemoGraph.this.memo == null) {
                        return;
                    }
                    MemoGraph.this.colordlg.setInitialColor(MemoGraph.this.memo.getColor());
                    MemoGraph.this.colordlg.setColorSelectionListener(new ColorSelectionListener(){

                        public void colorSelected(Color c) {
                            if (MemoGraph.this.memo == null) {
                                return;
                            }
                            MemoGraph.this.memo.setColor(c);
                        }
                    });
                    MemoGraph.this.colordlg.open();
                }
                catch (Throwable throwable) {}
            }
        });
        ti = new ToolItem(tb, 8);
        ti.setImage(MemoGraphPlugin.getImageDescriptor("icons/text.png").createImage());
        ti.setToolTipText("Font");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private String getStyle(int style) {
                switch (style) {
                    case 1: {
                        return "Bold";
                    }
                    case 2: {
                        return "Italic";
                    }
                }
                return "Normal";
            }

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    if (MemoGraph.this.memo == null) {
                        return;
                    }
                    FontDialog fontdlg = new FontDialog(MemoGraph.this.canvas.getShell());
                    fontdlg.setFontList(MemoGraph.this.memo.getFont().getFontData());
                    FontData nfd = fontdlg.open();
                    if (nfd == null) {
                        return;
                    }
                    fontdlg = null;
                    MemoGraph.this.memo.setFont(new Font((Device)MemoGraph.this.canvas.getDisplay(), nfd));
                    ((ToolItem)arg0.widget).setToolTipText("Font " + nfd.getName() + ";" + nfd.getHeight() + "pt;" + this.getStyle(nfd.getStyle()));
                }
                catch (Throwable throwable) {}
            }
        });
        this.canvas = new Canvas(root, 768);
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        GraphicUtil.setBackground((Control)this.canvas, (int)16);
        this.image = new Image((Device)this.canvas.getDisplay(), this.width, this.height);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Point csz = MemoGraph.this.canvas.getSize();
                ScrollBar vsb = MemoGraph.this.canvas.getVerticalBar();
                ScrollBar hsb = MemoGraph.this.canvas.getHorizontalBar();
                MemoGraph.this.configScrollBar(hsb, MemoGraph.this.width, csz.x);
                MemoGraph.this.configScrollBar(vsb, MemoGraph.this.height, csz.y);
                MemoGraph.this.sc_x = hsb.getSelection();
                MemoGraph.this.sc_y = vsb.getSelection();
                MemoGraph.this.canvas.redraw();
            }
        });
        this.colordlg = new ColorDialog(this.canvas.getShell());
        ScrollBar sb = this.canvas.getHorizontalBar();
        sb.setValues(0, 0, this.width, this.width, 1, 100);
        sb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MemoGraph.this.sc_x = ((ScrollBar)arg0.getSource()).getSelection();
                MemoGraph.this.canvas.redraw();
            }
        });
        sb = this.canvas.getVerticalBar();
        sb.setValues(0, 0, this.height, this.height, 1, 100);
        sb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MemoGraph.this.sc_y = ((ScrollBar)arg0.getSource()).getSelection();
                MemoGraph.this.canvas.redraw();
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                if (MemoGraph.this.image == null) {
                    return;
                }
                arg0.gc.drawImage(MemoGraph.this.image, MemoGraph.this.sc_x, MemoGraph.this.sc_y, MemoGraph.this.width - MemoGraph.this.sc_x, MemoGraph.this.height - MemoGraph.this.sc_y, 0, 0, MemoGraph.this.width - MemoGraph.this.sc_x, MemoGraph.this.height - MemoGraph.this.sc_y);
            }
        });
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    public void setImage(Image original, Image memoimg) {
        if (this.canvas.isDisposed()) {
            return;
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        this.image = new Image((Device)this.canvas.getDisplay(), original.getImageData());
        ImageData id = this.image.getImageData();
        this.width = id.width;
        this.height = id.height;
        Point csz = this.canvas.getSize();
        this.canvas.getHorizontalBar().setValues(0, 0, this.width, csz.x, 1, 100);
        this.canvas.getVerticalBar().setValues(0, 0, this.height, csz.y, 1, 100);
        this.memo = new Memo((Control)this.canvas, this.width, this.height);
        this.memo.setDrawMode(true);
        if (memoimg != null) {
            this.memo.setImage(memoimg);
        }
    }

    public void save() {
        Image memoimg = null;
        if (this.memo != null) {
            memoimg = this.memo.getImage();
        }
        if (this.listener != null) {
            this.listener.imageUpdated(memoimg, this.image);
        }
        this.issaved = true;
    }

    public void setUpdateListener(ImageUpdateListener listener) {
        this.listener = listener;
    }

    public boolean isDisposed() {
        return this.canvas.isDisposed();
    }
}

