/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.concierge.plugin.ipapers.CannotGuessIdtypeException;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.search.pubmed.PubMedCore;
import org.apache.commons.io.FilenameUtils;

public class PaperFactory {
    private static final PaperFactory singleton = new PaperFactory();

    public static PaperFactory getInstance() {
        return singleton;
    }

    private PaperFactory() {
    }

    public Paper create(String filename) throws CannotGuessIdtypeException {
        String id = null;
        id = this.containdsIEICEID(filename);
        if (id != null) {
            return new Paper(id, "ieice");
        }
        id = this.containdsPubMedID(filename);
        if (id != null) {
            return new Paper(id, PubMedCore.IDTYPE);
        }
        throw new CannotGuessIdtypeException(filename);
    }

    private String containdsIEICEID(String filepath) {
        File file = new File(filepath);
        if (file.exists()) {
            String filename = file.getName();
            filename = FilenameUtils.getBaseName((String)filename);
            Pattern pattern = Pattern.compile("(j\\d+-[abcd]\\d*_\\d+_\\d+)");
            Matcher matcher = pattern.matcher(filename);
            if (matcher.find(0)) {
                return matcher.group(1);
            }
        }
        return null;
    }

    private String containdsPubMedID(String filepath) {
        File file = new File(filepath);
        if (file.exists()) {
            String filename = file.getName();
            filename = FilenameUtils.getBaseName((String)filename);
            Pattern pattern = Pattern.compile("\\d+");
            Matcher matcher = pattern.matcher(filename);
            if (matcher.find(0)) {
                return filename.substring(matcher.start(), matcher.end());
            }
        }
        return null;
    }
}

