/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.NullPaperInfo;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfo;
import jp.sourceforge.concierge.plugin.ipapers.search.ArticleInfo;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheDB {
    private Connection con;
    private static final CacheDB singleton = new CacheDB();

    public static CacheDB getInstance() {
        return singleton;
    }

    public CacheDB() {
        block4: {
            String dbdir = String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + System.getProperty("file.separator") + "ipapers";
            File db = new File(dbdir);
            if (!db.exists()) {
                db.mkdir();
            }
            try {
                Class.forName("org.hsqldb.jdbcDriver");
                this.con = DriverManager.getConnection("jdbc:hsqldb:file:" + dbdir + System.getProperty("file.separator") + "SearchCache.db", "sa", "");
                PreparedStatement ps = this.con.prepareStatement("create table cache (id int, idtype varchar(64), author varchar, title varchar, journal varchar(256), volume varchar(32), issue varchar(32), pages varchar(32), year char(4), abstract varchar, searchCount int, searchTime timestamp, flag int)");
                ps.execute();
                ps.close();
                this.con.commit();
            }
            catch (ClassNotFoundException classNotFoundException) {
                IPapersPlugin.log.fatal((Object)"ERROR: failed to load HSQLDB JDBC driver.");
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("S0001")) break block4;
                IPapersPlugin.log.warn((Object)("failed to create table cache, " + e.getMessage() + "," + e.getSQLState()));
            }
        }
    }

    private PaperInfo fetchInfo(String id, String idtype) {
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT id,idtype,author,title,journal,volume,issue,pages,year,abstract,searchCount,flag FROM cache WHERE id=? and idtype=?");
            ps.setString(1, id);
            ps.setString(2, idtype);
            ResultSet rs = ps.executeQuery();
            rs.next();
            if (rs.getString("volume").length() == 0) {
                Paper newPaper = new Paper(id, idtype);
                newPaper.getPaperInfo().setFlag(rs.getInt("flag"));
                rs.close();
                ps.close();
                this.con.commit();
                return newPaper.getPaperInfo();
            }
            ArticleInfo info = null;
            info = new ArticleInfo();
            info.setAuthor(rs.getString("author"));
            info.setTitle(rs.getString("title"));
            info.setJournal(rs.getString("journal"));
            info.setAbstract(rs.getString("abstract"));
            info.setVolume(rs.getString("volume"));
            info.setYear(rs.getString("year"));
            info.setIssue(rs.getString("issue"));
            info.setPages(rs.getString("pages"));
            info.setFlag(rs.getInt("flag"));
            rs.close();
            ps.close();
            this.con.commit();
            return info;
        }
        catch (SQLException e) {
            IPapersPlugin.log.error((Object)("could not fetch, " + e.getMessage() + "," + e.getSQLState()));
            return new NullPaperInfo();
        }
        catch (CannotGetPaperInfoException cannotGetPaperInfoException) {
            return new NullPaperInfo();
        }
    }

    public void storeInfoToCache(Paper info, Timestamp searchTime) {
        try {
            PreparedStatement ps = this.con.prepareStatement("insert into cache (id, idtype, author, title, journal, volume, issue, pages, year, abstract, searchTime, flag) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
            ps.setString(1, info.getId());
            ps.setString(2, info.getIdType());
            ps.setString(3, info.getPaperInfo().getAuthor());
            ps.setString(4, info.getPaperInfo().getTitle());
            ps.setString(5, info.getPaperInfo().getJournal());
            ps.setString(6, info.getPaperInfo().getVolume());
            ps.setString(7, info.getPaperInfo().getIssue());
            ps.setString(8, info.getPaperInfo().getPages());
            ps.setString(9, info.getPaperInfo().getYear());
            ps.setString(10, info.getPaperInfo().getAbstract());
            ps.setTimestamp(11, searchTime);
            ps.setInt(12, info.getPaperInfo().getFlag());
            ps.execute();
            ps.close();
            this.con.commit();
        }
        catch (SQLException sQLException) {
            IPapersPlugin.log.error((Object)"could not store");
        }
        catch (CannotGetPaperInfoException cannotGetPaperInfoException) {
            IPapersPlugin.log.error((Object)"could not store because PaperInfo has not been able to get");
        }
    }

    public void shutdown() throws Exception {
        this.con.commit();
        this.con.createStatement().execute("SHUTDOWN;");
        this.con.close();
    }

    public void cancel() {
        try {
            this.shutdown();
        }
        catch (Exception exception) {
            IPapersPlugin.log.debug((Object)"could not stop search plugin");
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.shutdown();
    }

    public ArrayList<Paper> getPapers(Timestamp time) {
        ArrayList<Paper> papers = new ArrayList<Paper>();
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT id,idtype FROM cache WHERE searchTime=?");
            ps.setTimestamp(1, time);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PaperInfo info = this.fetchInfo(rs.getString("id"), rs.getString("idtype"));
                Paper paper = new Paper(rs.getString("id"), rs.getString("idtype"), info);
                papers.add(paper);
            }
            rs.close();
            ps.close();
            this.con.commit();
        }
        catch (SQLException e) {
            IPapersPlugin.log.error((Object)(String.valueOf(e.getMessage()) + ":" + e.getSQLState()));
        }
        return papers;
    }

    public void setFlag(String id, String idType, int flag) {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE cache SET flag=? WHERE id=? AND idtype=?");
            ps.setInt(1, flag);
            ps.setString(2, id);
            ps.setString(3, idType);
            ps.execute();
            this.con.commit();
        }
        catch (SQLException e) {
            IPapersPlugin.log.error((Object)(String.valueOf(e.getMessage()) + ":" + e.getSQLState()));
        }
    }

    public void removeInfo(String id, String idType) {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM cache  WHERE id=? AND idtype=?");
            ps.setString(1, id);
            ps.setString(2, idType);
            ps.execute();
            this.con.commit();
        }
        catch (SQLException e) {
            IPapersPlugin.log.error((Object)(String.valueOf(e.getMessage()) + ":" + e.getSQLState()));
        }
    }
}

