/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public class ResourceBundleWrapper
extends UResourceBundle {
    private ResourceBundle bundle = null;
    private String localeID = null;
    private String baseName = null;
    private Vector keys = null;
    private int loadingStatus = -1;
    private static final boolean DEBUG = ICUDebug.enabled("resourceBundleWrapper");

    private ResourceBundleWrapper(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    protected void setLoadingStatus(int newStatus) {
        this.loadingStatus = newStatus;
    }

    protected Object handleGetObject(String key) {
        ResourceBundleWrapper current = this;
        Object obj = null;
        while (current != null) {
            try {
                obj = current.bundle.getObject(key);
                break;
            }
            catch (MissingResourceException missingResourceException) {
                current = (ResourceBundleWrapper)current.getParent();
            }
        }
        if (obj == null) {
            throw new MissingResourceException("Can't find resource for bundle " + this.baseName + ", key " + key, this.getClass().getName(), key);
        }
        return obj;
    }

    public Enumeration getKeys() {
        return this.keys.elements();
    }

    private void initKeysVector() {
        ResourceBundleWrapper current = this;
        this.keys = new Vector();
        while (current != null) {
            Enumeration<String> e = current.bundle.getKeys();
            while (e.hasMoreElements()) {
                String elem = e.nextElement();
                if (this.keys.contains(elem)) continue;
                this.keys.add(elem);
            }
            current = (ResourceBundleWrapper)current.getParent();
        }
    }

    protected String getLocaleID() {
        return this.localeID;
    }

    protected String getBaseName() {
        return this.bundle.getClass().getName().replace('.', '/');
    }

    public ULocale getULocale() {
        return new ULocale(this.localeID);
    }

    public UResourceBundle getParent() {
        return (UResourceBundle)this.parent;
    }

    public static UResourceBundle getBundleInstance(String baseName, String localeID, ClassLoader root, boolean disableFallback) {
        UResourceBundle b = ResourceBundleWrapper.instantiateBundle(baseName, localeID, root, disableFallback);
        if (b == null) {
            String separator = "_";
            if (baseName.indexOf(47) >= 0) {
                separator = "/";
            }
            throw new MissingResourceException("Could not find the bundle " + baseName + separator + localeID, "", "");
        }
        return b;
    }

    protected static synchronized UResourceBundle instantiateBundle(String baseName, String localeID, ClassLoader root, boolean disableFallback) {
        ResourceBundleWrapper b;
        if (root == null) {
            root = ClassLoader.getSystemClassLoader();
        }
        final ClassLoader cl = root;
        String name = baseName;
        ULocale defaultLocale = ULocale.getDefault();
        if (localeID.length() != 0) {
            name = String.valueOf(name) + "_" + localeID;
        }
        if ((b = (ResourceBundleWrapper)UResourceBundle.loadFromCache(cl, name, defaultLocale)) == null) {
            block32: {
                ResourceBundleWrapper parent = null;
                int i = localeID.lastIndexOf(95);
                if (i != -1) {
                    String locName = localeID.substring(0, i);
                    parent = (ResourceBundleWrapper)UResourceBundle.loadFromCache(cl, String.valueOf(baseName) + "_" + locName, defaultLocale);
                    if (parent == null) {
                        parent = (ResourceBundleWrapper)ResourceBundleWrapper.instantiateBundle(baseName, locName, cl, disableFallback);
                    }
                } else if (localeID.length() > 0 && (parent = (ResourceBundleWrapper)UResourceBundle.loadFromCache(cl, baseName, defaultLocale)) == null) {
                    parent = (ResourceBundleWrapper)ResourceBundleWrapper.instantiateBundle(baseName, "", cl, disableFallback);
                }
                try {
                    Class<?> cls = cl.loadClass(name);
                    ResourceBundle bx = (ResourceBundle)cls.newInstance();
                    b = new ResourceBundleWrapper(bx);
                    if (parent != null) {
                        b.setParent(parent);
                    }
                    b.baseName = baseName;
                    b.localeID = localeID;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    block31: {
                        final String resName = String.valueOf(name.replace('.', '/')) + ".properties";
                        InputStream stream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                if (cl != null) {
                                    return cl.getResourceAsStream(resName);
                                }
                                return ClassLoader.getSystemResourceAsStream(resName);
                            }
                        });
                        if (stream != null) {
                            stream = new BufferedInputStream(stream);
                            try {
                                try {
                                    b = new ResourceBundleWrapper(new PropertyResourceBundle(stream));
                                    if (parent != null) {
                                        b.setParent(parent);
                                    }
                                    b.baseName = baseName;
                                    b.localeID = localeID;
                                }
                                catch (Exception exception) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Exception exception2) {}
                                    break block31;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    stream.close();
                                }
                                catch (Exception exception) {}
                                throw throwable;
                            }
                            try {
                                stream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (b == null) {
                        String defaultName = defaultLocale.toString();
                        if (localeID.length() > 0 && localeID.indexOf(95) < 0 && defaultName.indexOf(localeID) == -1 && (b = (ResourceBundleWrapper)UResourceBundle.loadFromCache(cl, String.valueOf(baseName) + "_" + defaultName, defaultLocale)) == null) {
                            b = (ResourceBundleWrapper)ResourceBundleWrapper.instantiateBundle(baseName, defaultName, cl, disableFallback);
                        }
                    }
                    if (b == null) {
                        b = parent;
                    }
                }
                catch (Exception e) {
                    if (DEBUG) {
                        System.out.println("failure");
                    }
                    if (!DEBUG) break block32;
                    System.out.println(e);
                }
            }
            UResourceBundle.addToCache(cl, name, defaultLocale, b);
        }
        if (b != null) {
            b.initKeysVector();
        } else if (DEBUG) {
            System.out.println("Returning null for " + baseName + "_" + localeID);
        }
        return b;
    }
}

