/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.parser;

import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLDocumentParser
implements ITypeParser {
    private static final String PARSERNS = "http://concierge.sourceforge.jp/ns/htmldocument";
    private static final String PARSERNSPREFIX = "htdoc";
    private static final String HEADTAGNAME = "head";
    private static final String BODYTAGNAME = "body";
    private static final String MESSAGE = "Follow HTML format.";

    @Override
    public String getParserNS() {
        return PARSERNS;
    }

    @Override
    public String getParserNSPrefix() {
        return PARSERNSPREFIX;
    }

    @Override
    public String getSingleText(Element data) {
        ArrayList<Element> list = DomImpl.getElements(data, BODYTAGNAME);
        if (list.size() == 0) {
            return "";
        }
        Element e = list.get(0);
        return DomImpl.getAllText(e);
    }

    @Override
    public ArrayList<String> getMultiText(Element data) {
        return null;
    }

    @Override
    public ArrayList<String> getIndexValues(Element data, String abc) {
        return null;
    }

    @Override
    public ArrayList<String> getIndexABC(Element data) {
        return null;
    }

    @Override
    public void putToElement(Element data, String str) {
    }

    public void setHTMLNode(Element data, Element child) {
        String nodename = child.getNodeName();
        if (nodename.compareTo(HEADTAGNAME) != 0 && nodename.compareTo(BODYTAGNAME) != 0) {
            return;
        }
        ArrayList<Element> elems = DomImpl.getElements(data, nodename);
        int i = 0;
        while (i < elems.size()) {
            data.removeChild(elems.get(i));
            ++i;
        }
        data.appendChild(data.getOwnerDocument().importNode(child, true));
    }

    public Element getHTMLNode(Element data, String nodename) {
        if (nodename.compareTo(HEADTAGNAME) != 0 && nodename.compareTo(BODYTAGNAME) != 0) {
            return null;
        }
        ArrayList<Element> elems = DomImpl.getElements(data, nodename);
        if (elems.size() > 0) {
            return elems.get(0);
        }
        return null;
    }

    @Override
    public String getMessage() {
        return MESSAGE;
    }
}

