/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jp.sourceforge.concierge.contentassist.Word;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DomImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordList {
    private static ArrayList<Word> words = new ArrayList();

    private static void setWords(ArrayList<Element> welems) {
        int i = 0;
        while (i < welems.size()) {
            Element welem = welems.get(i);
            String word = DomImpl.getAttribute(welem, "value");
            String count = DomImpl.getAttribute(welem, "counter");
            String lastused = DomImpl.getAttribute(welem, "lastused");
            String isreg = DomImpl.getAttribute(welem, "register");
            Word wd = new Word(word, Long.parseLong(lastused), Integer.parseInt(count), Boolean.parseBoolean(isreg));
            wd.setCommit(true);
            words.add(wd);
            ++i;
        }
    }

    private static void save(Element root, String[] commitlist) {
        WordList.sortWithWord();
        int i = 0;
        while (i < words.size()) {
            block7: {
                Word w;
                block6: {
                    w = words.get(i);
                    if (w.isCommitted()) break block6;
                    int j = 0;
                    while (j < commitlist.length) {
                        if (w.getWord().compareTo(commitlist[j]) == 0) {
                            w.setCommit(true);
                            break;
                        }
                        ++j;
                    }
                    if (!w.isCommitted()) break block7;
                }
                Element we = DomImpl.appendElement(root, "word");
                DomImpl.setAttribute(we, "value", w.getWord());
                DomImpl.setAttribute(we, "lastused", String.valueOf(w.getLastUsed()));
                DomImpl.setAttribute(we, "counter", String.valueOf(w.getCounter()));
                DomImpl.setAttribute(we, "register", String.valueOf(w.isRegistered()));
            }
            ++i;
        }
    }

    public static ArrayList<Word> getAllWords(boolean regword) {
        ArrayList<Word> ws = new ArrayList<Word>();
        int i = 0;
        while (i < words.size()) {
            Word w = words.get(i);
            if (w.isCommitted() && w.isRegistered() == regword) {
                ws.add(w);
            }
            ++i;
        }
        return ws;
    }

    public static ArrayList<Word> getWordsStartWith(String s, boolean regword) {
        ArrayList<Word> wlist = new ArrayList<Word>();
        int i = 0;
        while (i < words.size()) {
            Word w = words.get(i);
            if (w.isCommitted() && regword == w.isRegistered() && w.getWord().startsWith(s)) {
                wlist.add(w);
            }
            ++i;
        }
        return wlist;
    }

    private static Word contains(String word) {
        int i = 0;
        while (i < words.size()) {
            if (words.get(i).getWord().compareTo(word) == 0) {
                return words.get(i);
            }
            ++i;
        }
        return null;
    }

    public static void addWords(String[] wds) {
        int i = 0;
        while (i < wds.length) {
            String wd = wds[i].trim();
            if (wd.length() != 0 && WordList.contains(wd) == null) {
                words.add(new Word(wd, System.currentTimeMillis(), 0, false));
            }
            ++i;
        }
        WordList.sortWithWord();
    }

    public static void addWordAsRegistered(String word) {
        Word wd = WordList.contains(word);
        if (wd == null) {
            wd = new Word(word, System.currentTimeMillis(), 0, true);
            words.add(wd);
        } else {
            wd.setRegistered(true);
        }
        wd.setCommit(true);
        WordList.sortWithWord();
    }

    public static void deleteWord(String word) {
        int i = 0;
        while (i < words.size()) {
            Word w = words.get(i);
            if (w.getWord().equals(word)) {
                words.remove(w);
                return;
            }
            ++i;
        }
    }

    public static void load() {
        Document cdoc;
        ArrayList<Element> regelems;
        Request r = new Request(4, "/rtext", "ccgconfig");
        ArrayList<Document> confdocs = FrameworkPlugin.getDocumentsOfQuery(r);
        if (confdocs.size() > 0 && (regelems = DomImpl.getElements(DomImpl.getRootElement(cdoc = confdocs.get(0)), "word")).size() > 0) {
            WordList.setWords(regelems);
        }
    }

    public static void save(String[] commitlist) {
        Request r = new Request(4, "/rtext", "ccgconfig");
        ArrayList<Document> confdocs = FrameworkPlugin.getDocumentsOfQuery(r);
        Document cdoc = null;
        boolean newdoc = false;
        if (confdocs != null && confdocs.size() > 0) {
            cdoc = confdocs.get(0);
        } else {
            cdoc = DomImpl.createDocument("rtext");
            newdoc = true;
        }
        Element root = DomImpl.getRootElement(cdoc);
        DomImpl.removeAllChildren(root);
        int i = 0;
        while (i < commitlist.length) {
            commitlist[i] = commitlist[i].trim();
            ++i;
        }
        WordList.save(root, commitlist);
        Request nr = new Request(newdoc ? 1 : 3, cdoc, "ccgconfig");
        ArrayList<Request> nrs = new ArrayList<Request>();
        nrs.add(nr);
        FrameworkPlugin.updateDocuments(nrs, null);
    }

    public static void sortWithCount() {
        Collections.sort(words, new Comparator<Word>(){

            @Override
            public int compare(Word arg0, Word arg1) {
                return arg0.compareWithCounter(arg1);
            }
        });
    }

    public static void sortWithLastUsed() {
        Collections.sort(words, new Comparator<Word>(){

            @Override
            public int compare(Word arg0, Word arg1) {
                return arg0.compareWithLastUsed(arg1);
            }
        });
    }

    public static void sortWithWord() {
        Collections.sort(words, new Comparator<Word>(){

            @Override
            public int compare(Word arg0, Word arg1) {
                return arg0.compareWithWord(arg1);
            }
        });
    }
}

