/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.plugin.XooNIpsConnection;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.MappingField;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.MappingTableDialog;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference.EditExportDatasetListDialog;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference.EditSrcMappingFieldDialog;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference.ExportMappingData;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference.ExportMappingDataList;
import jp.sourceforge.xoonips.XooNIpsItemType;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExportPreferenceDialog
extends MappingTableDialog {
    public ExportPreferenceDialog(Shell parentShell, XooNIpsConnection xoonipsConnection) {
        super(parentShell, xoonipsConnection);
    }

    protected Control createSettingControl(Composite parent) {
        SashForm sf = new SashForm(parent, 256);
        sf.setLayoutData((Object)new GridData(1808));
        sf.setLayout((Layout)new FillLayout());
        this.createTypeTableViewer((Composite)sf);
        Composite composite = new Composite((Composite)sf, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createDatasetControls(composite);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        Composite upperComposite = new Composite((Composite)group, 0);
        upperComposite.setLayoutData((Object)new GridData(768));
        upperComposite.setLayout((Layout)new GridLayout(2, false));
        this.createDataNameControls(upperComposite);
        this.createDstTypeNameControls(upperComposite, "XooNIps Type:");
        Label separator = new Label(upperComposite, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        this.createMappingTableViewer((Composite)group, "XooNIps", "Concierge");
        sf.setWeights(new int[]{25, 75});
        return sf;
    }

    private ExportMappingDataList getSelectionTypeTableView() {
        Object obj;
        ISelection selection = this.typeTableView.getSelection();
        if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof ExportMappingDataList) {
            return (ExportMappingDataList)obj;
        }
        return null;
    }

    protected void initialize() {
        this.typeTableView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (obj = selection.getFirstElement()) != null && obj instanceof ExportMappingDataList) {
                    ExportMappingDataList mappingDataList = (ExportMappingDataList)obj;
                    ArrayList<ExportMappingData> mappingDataAL = mappingDataList.getList();
                    ExportPreferenceDialog.this.datasetListCombo.setInput(mappingDataAL);
                    ExportPreferenceDialog.this.datasetListCombo.getCombo().select(mappingDataList.getCurrentIndex());
                    ExportMappingData mappingData = null;
                    if (mappingDataList.getCurrentIndex() >= 0) {
                        mappingData = mappingDataAL.get(mappingDataList.getCurrentIndex());
                    }
                    ExportPreferenceDialog.this.setMappingDataToControls(mappingData);
                    return;
                }
                ExportPreferenceDialog.this.setMappingDataToControls(null);
                ExportPreferenceDialog.this.datasetListCombo.setInput(null);
            }
        });
        this.datasetListCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (obj = selection.getFirstElement()) != null && obj instanceof ExportMappingData) {
                    ExportMappingData mappingData = (ExportMappingData)obj;
                    ExportMappingDataList mappingDataList = ExportPreferenceDialog.this.getSelectionTypeTableView();
                    mappingDataList.setCurrentIndex(mappingData);
                    ExportPreferenceDialog.this.setMappingDataToControls(mappingData);
                    return;
                }
                ExportPreferenceDialog.this.mappingTableViewer.setInput(null);
            }
        });
        this.datasetEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                ExportMappingDataList mappingDataList = ExportPreferenceDialog.this.getSelectionTypeTableView();
                ArrayList<ExportMappingData> mappingDataAL = mappingDataList.getList();
                try {
                    XooNIpsItemType[] xnpItemTypes = ExportPreferenceDialog.this.xoonipsConnection.getXooNIpsSession().getItemTypeList();
                    EditExportDatasetListDialog dlg = new EditExportDatasetListDialog(button.getShell(), mappingDataAL, mappingDataList.getSrc(), xnpItemTypes);
                    if (dlg.open() == 0) {
                        ArrayList<ExportMappingData> al = dlg.getMappingDataList();
                        int i = mappingDataAL.size() - 1;
                        while (i >= 0) {
                            ExportMappingData srcObj = mappingDataAL.get(i);
                            if (!al.remove(srcObj)) {
                                mappingDataAL.remove(i);
                            }
                            --i;
                        }
                        if (al.size() > 0) {
                            mappingDataAL.addAll(al);
                            mappingDataList.setCurrentIndex(mappingDataAL.size() - 1);
                            ExportPreferenceDialog.this.datasetListCombo.refresh();
                            ExportPreferenceDialog.this.datasetListCombo.getCombo().select(mappingDataList.getCurrentIndex());
                            ExportPreferenceDialog.this.setMappingDataToControls(mappingDataAL.get(mappingDataList.getCurrentIndex()));
                        }
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.mappingTableViewer.setLabelProvider((IBaseLabelProvider)new MappingViewLabelProvider());
        this.mappingTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null) {
                    MappingField mappingField = (MappingField)obj;
                    ExportMappingDataList mappingDataList = ExportPreferenceDialog.this.getSelectionTypeTableView();
                    EditSrcMappingFieldDialog dlg = new EditSrcMappingFieldDialog(ExportPreferenceDialog.this.mappingTableViewer.getControl().getShell(), mappingDataList.getSrc(), mappingField);
                    if (dlg.open() == 0) {
                        ExportPreferenceDialog.this.mappingTableViewer.update(obj, null);
                    }
                }
            }
        });
        ArrayList typedocs = TypeManager.getAllTypeDocuments((boolean)true, (boolean)true, (boolean)true);
        int i = 0;
        while (i < typedocs.size()) {
            ExportMappingDataList mappingDataList = new ExportMappingDataList((Document)typedocs.get(i));
            this.typeTableView.add((Object)mappingDataList);
            this.readDoc(mappingDataList);
            ArrayList<ExportMappingData> mappingDataAL = mappingDataList.getList();
            if (mappingDataAL.size() == 0) {
                try {
                    XooNIpsItemType[] xnpItemTypes = this.xoonipsConnection.getXooNIpsSession().getItemTypeList();
                    ExportMappingData mappingData = new ExportMappingData(xnpItemTypes[0], (Document)typedocs.get(i));
                    mappingDataAL.add(mappingData);
                    mappingDataList.setCurrentIndex(0);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        if (this.typeTableView.getTable().getItemCount() > 0) {
            this.typeTableView.getTable().select(0);
            ExportMappingDataList mappingDataList = (ExportMappingDataList)this.typeTableView.getElementAt(0);
            ArrayList<ExportMappingData> mappingDataAL = mappingDataList.getList();
            this.datasetListCombo.setInput(mappingDataAL);
            this.datasetListCombo.getCombo().select(mappingDataList.getCurrentIndex());
            ExportMappingData mappingData = null;
            if (mappingDataList.getCurrentIndex() >= 0) {
                mappingData = mappingDataAL.get(mappingDataList.getCurrentIndex());
            }
            this.setMappingDataToControls(mappingData);
        }
    }

    protected void DoSave() {
        this.typeTableView.getTable().setFocus();
    }

    private void deleteMappingDataFromDB() {
        String xpath = "/";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, (Object)xpath, "xoonipslink");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        System.out.println("Result size = " + docs.size());
        if (docs.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            reqs.add(new Request(2, (Object)docs, "xoonipslink"));
            FrameworkPlugin.updateDocuments(reqs, (Object)"jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference");
            reqs = null;
        }
        docs = null;
    }

    private void saveMappingDataToDB() {
        ArrayList<Document> docs = new ArrayList<Document>();
        int i = 0;
        while (i < this.typeTableView.getTable().getItemCount()) {
            ExportMappingDataList mappingDataList = (ExportMappingDataList)this.typeTableView.getElementAt(0);
            Document doc = this.newDoc(mappingDataList);
            if (doc != null) {
                docs.add(doc);
            }
            ++i;
        }
        if (docs.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            reqs.add(new Request(1, docs, "xoonipslink"));
            FrameworkPlugin.updateDocuments(reqs, (Object)"jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference");
            Object var2_3 = null;
        }
        docs = null;
    }

    private Document newDoc(ExportMappingDataList mappingDataList) {
        Document doc = DomImpl.createDocument((String)"exportmappingdata");
        Element rootElem = doc.getDocumentElement();
        rootElem.setAttribute("type", mappingDataList.getSrcID());
        rootElem.setAttribute("select", String.valueOf(mappingDataList.getCurrentIndex()));
        ArrayList<ExportMappingData> mappingDataAL = mappingDataList.getList();
        int j = 0;
        while (j < mappingDataAL.size()) {
            ExportMappingData mappingData = mappingDataAL.get(j);
            Element dataElem = doc.createElement("data");
            rootElem.appendChild(dataElem);
            dataElem.setAttribute("dataname", mappingData.getDataName());
            dataElem.setAttribute("typename", mappingData.getDstXooNIpsItemType().getTypeName());
            ArrayList<MappingField> fields = mappingData.getFields();
            int k = 0;
            while (k < fields.size()) {
                fields.get(k);
                Element fieldElem = doc.createElement("field");
                dataElem.appendChild(fieldElem);
                ++k;
            }
            ++j;
        }
        return doc;
    }

    private void readDoc(ExportMappingDataList mappingDataList) {
    }

    class MappingViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            if (obj instanceof MappingField) {
                MappingField field = (MappingField)obj;
                if (index == 0) {
                    return field.getDst();
                }
                if (index == 1) {
                    ArrayList<String> al;
                    ExportMappingDataList mappingDataList = ExportPreferenceDialog.this.getSelectionTypeTableView();
                    StringBuffer strBuf = new StringBuffer();
                    if (mappingDataList != null && (al = field.getSrc()) != null) {
                        int i = 0;
                        while (i < al.size()) {
                            if (i > 0) {
                                strBuf.append(", ");
                            }
                            String src = al.get(i);
                            strBuf.append(src);
                            ++i;
                        }
                    }
                    return strBuf.toString();
                }
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

