/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.xoonipslink2.preferences;

import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.MappingData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class EditDatasetListDialog
extends Dialog {
    protected TableViewer datasetTableView = null;

    public EditDatasetListDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Point getInitialSize() {
        return new Point(480, 320);
    }

    protected Control createDialogArea(Composite parent, String labelName, Object input, SelectionAdapter newButtonSelectionAdapter, SelectionAdapter delButtonSelectionAdapter) {
        this.getShell().setText("Edit Data Set");
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Composite upperComposite = new Composite(composite, 0);
        upperComposite.setLayout((Layout)new GridLayout(2, false));
        upperComposite.setLayoutData((Object)new GridData(1808));
        this.datasetTableView = new TableViewer(upperComposite, 66308);
        this.datasetTableView.getTable().setLayoutData((Object)new GridData(1808));
        this.datasetTableView.setContentProvider((IContentProvider)new DatasetTableViewContentProvider());
        this.datasetTableView.setLabelProvider((IBaseLabelProvider)new DatasetTableViewLabelProvider());
        this.datasetTableView.getTable().setLinesVisible(true);
        this.datasetTableView.getTable().setHeaderVisible(true);
        TableColumn tc1 = new TableColumn(this.datasetTableView.getTable(), 16384, 0);
        tc1.setText("Name");
        TableColumn tc2 = new TableColumn(this.datasetTableView.getTable(), 16384, 1);
        tc2.setText(labelName);
        this.datasetTableView.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                Rectangle r = table.getClientArea();
                TableColumn[] col = table.getColumns();
                if (col.length == 2) {
                    col[0].setWidth(r.width / 2);
                    col[1].setWidth(r.width / 2);
                }
            }
        });
        this.datasetTableView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
            }
        });
        this.datasetTableView.setInput(input);
        Composite actionComposite = new Composite(upperComposite, 0);
        actionComposite.setLayout((Layout)new GridLayout(1, false));
        actionComposite.setLayoutData((Object)new GridData(1040));
        Button newButton = new Button(actionComposite, 0);
        newButton.setText("New");
        newButton.setLayoutData((Object)new GridData(768));
        newButton.addSelectionListener((SelectionListener)newButtonSelectionAdapter);
        Button delButton = new Button(actionComposite, 0);
        delButton.setText("Delete");
        delButton.setLayoutData((Object)new GridData(768));
        delButton.addSelectionListener((SelectionListener)delButtonSelectionAdapter);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
        super.buttonPressed(buttonId);
    }

    class DatasetTableViewContentProvider
    implements IStructuredContentProvider {
        DatasetTableViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((ArrayList)parent).toArray();
        }
    }

    class DatasetTableViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DatasetTableViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof MappingData) {
                MappingData data = (MappingData)obj;
                if (index == 0) {
                    return data.getDataName();
                }
                if (index == 1) {
                    return data.getDstTypeName();
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

