/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Stack;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.parser.AuthorsParser;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.parser.IdentifiersParser;
import jp.sourceforge.concierge.plugin.IndexTreeViewContentProvider;
import jp.sourceforge.concierge.plugin.IndexTreeViewLabelProvider;
import jp.sourceforge.concierge.plugin.TextDialog;
import jp.sourceforge.concierge.plugin.XnpFileData;
import jp.sourceforge.concierge.plugin.XooNIpsConnection;
import jp.sourceforge.concierge.plugin.XoonipsLink2Plugin;
import jp.sourceforge.xoonips.XooNIpsException;
import jp.sourceforge.xoonips.XooNIpsFile;
import jp.sourceforge.xoonips.XooNIpsIndex;
import jp.sourceforge.xoonips.XooNIpsItemType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadNewXooNIpsItemDialog
extends Dialog {
    private Composite detailComposite = null;
    private CheckboxTreeViewer xoonipsIndexTreeViewer = null;
    private ArrayList<String> srcTypeElemNames = null;
    private Document srcDataDoc = null;
    private Element srcDataElem = null;
    private Hashtable<String, Object> controlDataHT = null;
    private ArrayList<XooNIpsIndex> dstXnpIndexArrayList = null;
    private String defaultXnpItemType = null;
    private XooNIpsItemType[] xnpItemTypes = null;
    private XooNIpsIndex srcXnpIndex = null;
    private XooNIpsItemType dstXnpItemType = null;
    private XooNIpsConnection xoonipsConnection = null;

    protected UploadNewXooNIpsItemDialog(Shell parentShell) {
        super(parentShell);
    }

    protected UploadNewXooNIpsItemDialog(Shell parentShell, XooNIpsConnection xoonipsConnection, String defaultXnpItemType, XooNIpsIndex srcXnpIndex, ArrayList<String> srcTypeElemNames, Document srcDataDoc, Element srcDataElem) {
        super(parentShell);
        this.setShellStyle(0x10870 | UploadNewXooNIpsItemDialog.getDefaultOrientation());
        this.xoonipsConnection = xoonipsConnection;
        this.defaultXnpItemType = defaultXnpItemType;
        this.srcXnpIndex = srcXnpIndex;
        this.srcTypeElemNames = srcTypeElemNames;
        this.srcDataDoc = srcDataDoc;
        this.srcDataElem = srcDataElem;
    }

    protected Point getInitialSize() {
        return new Point(640, 640);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Upload to XooNIps");
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        SashForm sf = new SashForm(composite, 0);
        sf.setLayoutData((Object)new GridData(1808));
        sf.setLayout((Layout)new FillLayout());
        try {
            this.xoonipsIndexTreeViewer = new CheckboxTreeViewer((Composite)sf, 2820);
            this.xoonipsIndexTreeViewer.setContentProvider((IContentProvider)new IndexTreeViewContentProvider());
            this.xoonipsIndexTreeViewer.setLabelProvider((IBaseLabelProvider)new IndexTreeViewLabelProvider());
            this.xoonipsIndexTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
            this.xoonipsIndexTreeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getChecked()) {
                        UploadNewXooNIpsItemDialog.this.dstXnpIndexArrayList.add((XooNIpsIndex)event.getElement());
                    } else if (UploadNewXooNIpsItemDialog.this.srcXnpIndex.getIndexNo() != ((XooNIpsIndex)event.getElement()).getIndexNo()) {
                        UploadNewXooNIpsItemDialog.this.dstXnpIndexArrayList.remove((XooNIpsIndex)event.getElement());
                    } else {
                        UploadNewXooNIpsItemDialog.this.xoonipsIndexTreeViewer.setChecked((Object)((XooNIpsIndex)event.getElement()), true);
                    }
                }
            });
            this.xoonipsIndexTreeViewer.setInput((Object)this.xoonipsConnection);
        }
        catch (Exception exception) {}
        Composite rightComposite = new Composite((Composite)sf, 0);
        rightComposite.setLayout((Layout)new GridLayout(1, false));
        rightComposite.setLayoutData((Object)new GridData(1808));
        try {
            this.xnpItemTypes = this.xoonipsConnection.getXooNIpsSession().getItemTypeList();
            Combo itemTypeCombo = new Combo(rightComposite, 8);
            String[] itemTypeNames = new String[this.xnpItemTypes.length];
            int index = -1;
            XooNIpsItemType xnpItemType = null;
            int i = 0;
            while (i < itemTypeNames.length) {
                itemTypeNames[i] = this.xnpItemTypes[i].getTitle();
                if (this.defaultXnpItemType != null && this.defaultXnpItemType.length() > 0 && this.xnpItemTypes[i].getTypeName().equals(this.defaultXnpItemType)) {
                    xnpItemType = this.xnpItemTypes[i];
                    index = i;
                }
                ++i;
            }
            if (xnpItemType == null && this.xnpItemTypes.length > 0) {
                xnpItemType = this.xnpItemTypes[0];
                index = 0;
            }
            itemTypeCombo.setItems(itemTypeNames);
            itemTypeCombo.select(index);
            itemTypeCombo.setText("XooNIps Item Type:");
            itemTypeCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Combo combo = (Combo)e.getSource();
                    int index = combo.getSelectionIndex();
                    if (index >= 0 && index < UploadNewXooNIpsItemDialog.this.xnpItemTypes.length) {
                        UploadNewXooNIpsItemDialog.this.init_ItemView(UploadNewXooNIpsItemDialog.this.xnpItemTypes[index]);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ScrolledComposite sc = new ScrolledComposite(rightComposite, 2560);
            sc.setLayout((Layout)new GridLayout(1, false));
            sc.getVerticalBar().setIncrement(12);
            sc.setExpandHorizontal(true);
            sc.setLayoutData((Object)new GridData(1808));
            sc.setBackground(XoonipsLink2Plugin.newColor(null, 255, 255, 255));
            this.detailComposite = new Composite((Composite)sc, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginWidth = 10;
            gl.marginHeight = 10;
            gl.horizontalSpacing = 1;
            gl.verticalSpacing = 2;
            this.detailComposite.setLayout((Layout)gl);
            this.detailComposite.setLayoutData((Object)new GridData(1808));
            this.detailComposite.setBackground(XoonipsLink2Plugin.newColor(null, 255, 255, 255));
            sc.setContent((Control)this.detailComposite);
            this.init_ItemView(xnpItemType);
        }
        catch (XooNIpsException xooNIpsException) {
        }
        catch (Exception exception) {}
        this.initIndexTreeViewer(this.srcXnpIndex.getIndexNo());
        sf.setWeights(new int[]{30, 70});
        return composite;
    }

    private void disposeControls(Composite parent) {
        Control[] controls = parent.getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Composite) {
                this.disposeControls((Composite)controls[i]);
            } else if (controls[i] instanceof Label) {
                Label srcObj = (Label)controls[i];
                Image img = srcObj.getImage();
                srcObj.setImage(null);
                if (img != null) {
                    img.dispose();
                }
                img = null;
            }
            controls[i].dispose();
            controls[i] = null;
            ++i;
        }
    }

    private void initIndexTreeViewer(int index) {
        this.dstXnpIndexArrayList = new ArrayList();
        try {
            Stack<XooNIpsIndex> stack = new Stack<XooNIpsIndex>();
            int count = 0;
            while (index != -1) {
                XooNIpsIndex xnpIndex = this.xoonipsConnection.getXooNIpsSession().getIndex(index);
                stack.push(xnpIndex);
                index = xnpIndex.getParentIndex();
                if (32 <= count) break;
                ++count;
            }
            TreeItem item = this.findTreeItemFromTreeViewer(null, stack);
            if (item != null) {
                this.xoonipsIndexTreeViewer.setChecked(item.getData(), true);
                this.dstXnpIndexArrayList.add((XooNIpsIndex)item.getData());
            }
            stack = null;
        }
        catch (XooNIpsException xooNIpsException) {
        }
        catch (Exception exception) {}
    }

    private TreeItem findTreeItemFromTreeViewer(TreeItem item, Stack stack) {
        TreeItem[] items = null;
        items = item != null ? item.getItems() : this.xoonipsIndexTreeViewer.getTree().getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                Object objA = items[i].getData();
                Object objB = stack.peek();
                if (((XooNIpsIndex)objA).getIndexNo() == ((XooNIpsIndex)objB).getIndexNo()) {
                    stack.pop();
                    if (stack.empty()) {
                        return items[i];
                    }
                    this.xoonipsIndexTreeViewer.expandToLevel(objA, 1);
                    item = this.findTreeItemFromTreeViewer(items[i], stack);
                    if (item != null) {
                        return item;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private void init_ItemView(XooNIpsItemType xnpItemType) {
        this.dstXnpItemType = xnpItemType;
        this.disposeControls(this.detailComposite);
        this.detailComposite.layout(true, true);
        this.detailComposite.setSize(this.detailComposite.computeSize(-1, -1));
        this.detailComposite.setSize(new Point(0, 0));
        if (this.controlDataHT != null) {
            this.controlDataHT.clear();
            this.controlDataHT = null;
        }
        if (xnpItemType == null) {
            return;
        }
        this.controlDataHT = new Hashtable();
        this.createItemFields(this.detailComposite, xnpItemType, this.srcTypeElemNames, this.srcDataDoc, this.srcDataElem, this.controlDataHT);
        this.detailComposite.layout(true, true);
        this.detailComposite.setSize(this.detailComposite.computeSize(-1, -1));
    }

    private Composite createField(Composite parent, XooNIpsItemType xnpItemType, String fieldName) {
        Composite fieldComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        fieldComp.setLayout((Layout)gl);
        fieldComp.setLayoutData((Object)new GridData(1808));
        Color darkColor = XoonipsLink2Plugin.newColor(null, 222, 227, 231);
        Composite labelGroupComp = new Composite(fieldComp, 0);
        GridLayout gl2 = new GridLayout(1, false);
        gl2.marginWidth = 2;
        gl2.verticalSpacing = 0;
        gl2.horizontalSpacing = 0;
        labelGroupComp.setLayout((Layout)gl2);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        labelGroupComp.setLayoutData((Object)gd);
        labelGroupComp.setBackground(darkColor);
        Label keyLabel = new Label(labelGroupComp, 0);
        GridData gd2 = new GridData(768);
        keyLabel.setLayoutData((Object)gd2);
        keyLabel.setBackground(darkColor);
        try {
            String displayName = xnpItemType.getDisplayName(fieldName);
            if (xnpItemType.isRequired(fieldName)) {
                keyLabel.setText(String.valueOf(displayName) + " *");
            } else {
                keyLabel.setText(displayName);
            }
        }
        catch (Exception excp) {
            excp.printStackTrace();
            keyLabel.setText(fieldName);
        }
        Composite editGroupComp = new Composite(fieldComp, 0);
        GridLayout gl3 = new GridLayout(1, false);
        gl3.verticalSpacing = 1;
        gl3.horizontalSpacing = 1;
        editGroupComp.setLayout((Layout)gl3);
        GridData gd3 = new GridData(1808);
        gd3.widthHint = 300;
        editGroupComp.setLayoutData((Object)gd3);
        Color lightColor = XoonipsLink2Plugin.newColor(null, 233, 233, 233);
        editGroupComp.setBackground(lightColor);
        return editGroupComp;
    }

    private void createStringWideArea(Composite parent, String value, XooNIpsItemType xnpItemType, String fieldName, Hashtable<String, Object> outHT) {
        Composite editGroupComp = this.createField(parent, xnpItemType, fieldName);
        Color lightColor = XoonipsLink2Plugin.newColor(null, 233, 233, 233);
        try {
            if (value == null) {
                value = "";
            }
            outHT.put(fieldName, value);
            this.createEditStringPart(editGroupComp, lightColor, fieldName, outHT, true);
            editGroupComp.layout();
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
    }

    private void createStringWideArea(Composite parent, ArrayList<String> al, XooNIpsItemType xnpItemType, String fieldName, Hashtable<String, Object> outHT) {
        String value = "";
        if (al != null) {
            int n = 0;
            while (n < al.size()) {
                if (value.length() > 0) {
                    value = String.valueOf(value) + ", ";
                }
                value = String.valueOf(value) + al.get(n).trim();
                ++n;
            }
        }
        this.createStringWideArea(parent, value, xnpItemType, fieldName, outHT);
    }

    private void createStringArea(Composite parent, String value, XooNIpsItemType xnpItemType, String fieldName, Hashtable<String, Object> outHT) {
        Composite editGroupComp = this.createField(parent, xnpItemType, fieldName);
        Color lightColor = XoonipsLink2Plugin.newColor(null, 233, 233, 233);
        try {
            if (value == null) {
                value = "";
            }
            outHT.put(fieldName, value);
            boolean isWide = false;
            if (value != null) {
                isWide = value.length() > 127;
            }
            this.createEditStringPart(editGroupComp, lightColor, fieldName, outHT, isWide);
            editGroupComp.layout();
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
    }

    private void createStringArea(Composite parent, ArrayList<String> al, XooNIpsItemType xnpItemType, String fieldName, Hashtable<String, Object> outHT) {
        String value = "";
        if (al != null) {
            int n = 0;
            while (n < al.size()) {
                if (value.length() > 0) {
                    value = String.valueOf(value) + ", ";
                }
                value = String.valueOf(value) + al.get(n).trim();
                ++n;
            }
        }
        this.createStringArea(parent, value, xnpItemType, fieldName, outHT);
    }

    private void createReadStringArea(Composite parent, String value, XooNIpsItemType xnpItemType, String fieldName) {
        Composite editGroupComp = this.createField(parent, xnpItemType, fieldName);
        Color lightColor = XoonipsLink2Plugin.newColor(null, 233, 233, 233);
        try {
            this.createReadStringPart(editGroupComp, lightColor, value);
            editGroupComp.layout();
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
    }

    private void createMultiStringArea(Composite parent, ArrayList<String> al, XooNIpsItemType xnpItemType, String fieldName, Hashtable<String, Object> outHT) {
        Composite editGroupComp = this.createField(parent, xnpItemType, fieldName);
        Color lightColor = XoonipsLink2Plugin.newColor(null, 233, 233, 233);
        try {
            outHT.put(fieldName, al);
            this.createEditStringMultiPart(editGroupComp, lightColor, al);
            editGroupComp.layout();
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
    }

    private void createDateArea(Composite parent, Calendar srcCal, XooNIpsItemType xnpItemType, String fieldName, Hashtable<String, Object> outHT) {
        Composite editGroupComp = this.createField(parent, xnpItemType, fieldName);
        Color lightColor = XoonipsLink2Plugin.newColor(null, 233, 233, 233);
        try {
            if (srcCal == null) {
                Date theDay = new Date();
                srcCal = new GregorianCalendar();
                srcCal.setTime(theDay);
            }
            outHT.put(fieldName, srcCal);
            this.createEditDatePart(editGroupComp, lightColor, srcCal);
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
        editGroupComp.layout();
    }

    private void createDateArea(Composite parent, String value, XooNIpsItemType xnpItemType, String fieldName, Hashtable<String, Object> outHT) {
        Calendar srcCal = this.StringToCalendar(value);
        try {
            this.createDateArea(parent, srcCal, xnpItemType, fieldName, outHT);
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
    }

    private void createDateArea(Composite parent, ArrayList<String> al, XooNIpsItemType xnpItemType, String fieldName, Hashtable<String, Object> outHT) {
        Composite editGroupComp = this.createField(parent, xnpItemType, fieldName);
        Color lightColor = XoonipsLink2Plugin.newColor(null, 233, 233, 233);
        try {
            Calendar srcCal = null;
            if (al.size() > 0) {
                String value = al.get(0);
                srcCal = this.StringToCalendar(value);
            }
            if (srcCal == null) {
                Date theDay = new Date();
                srcCal = new GregorianCalendar();
                srcCal.setTime(theDay);
            }
            outHT.put(fieldName, srcCal);
            this.createEditDatePart(editGroupComp, lightColor, srcCal);
            editGroupComp.layout();
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
    }

    private void createReadDateArea(Composite parent, ArrayList inAL, XooNIpsItemType xnpItemType, String fieldName) {
        Composite editGroupComp = this.createField(parent, xnpItemType, fieldName);
        Color lightColor = XoonipsLink2Plugin.newColor(null, 233, 233, 233);
        try {
            Calendar srcCal = null;
            if (inAL.size() > 0) {
                String value = (String)inAL.get(0);
                srcCal = this.StringToCalendar(value);
            }
            if (srcCal == null) {
                Date theDay = new Date();
                srcCal = new GregorianCalendar();
                srcCal.setTime(theDay);
            }
            this.createReadDatePart(editGroupComp, lightColor, srcCal);
            editGroupComp.layout();
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
    }

    private void createOptionsArea(Composite parent, String value, XooNIpsItemType xnpItemType, String fieldName, Hashtable<String, Object> outHT) {
        Composite editGroupComp = this.createField(parent, xnpItemType, fieldName);
        try {
            Combo valueCombo = new Combo(editGroupComp, 8);
            valueCombo.setLayoutData((Object)new GridData(4));
            valueCombo.setItems(xnpItemType.getOptionDisplayNames(fieldName));
            String[] optionNames = xnpItemType.getOptionNames(fieldName);
            int n = 0;
            while (n < optionNames.length) {
                if (optionNames[n].equals(value)) {
                    valueCombo.select(n);
                    break;
                }
                ++n;
            }
            outHT.put(fieldName, value);
            valueCombo.setData("fieldName", (Object)fieldName);
            valueCombo.setData("outHT", outHT);
            valueCombo.setData("OptionNames", (Object)optionNames);
            valueCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Combo combo = (Combo)e.getSource();
                    String[] values = (String[])combo.getData("OptionNames");
                    int index = combo.getSelectionIndex();
                    String fieldName = (String)combo.getData("fieldName");
                    Hashtable outHT = (Hashtable)combo.getData("outHT");
                    outHT.put(fieldName, values[index]);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
        editGroupComp.layout();
    }

    private void createReadOptionsArea(Composite parent, String value, XooNIpsItemType xnpItemType, String fieldName) {
        Composite editGroupComp = this.createField(parent, xnpItemType, fieldName);
        Color lightColor = XoonipsLink2Plugin.newColor(null, 233, 233, 233);
        try {
            String[] optionNames = xnpItemType.getOptionNames(fieldName);
            int n = 0;
            while (n < optionNames.length) {
                if (optionNames[n].equals(value)) {
                    String[] optionDisplayNames = xnpItemType.getOptionDisplayNames(fieldName);
                    value = optionDisplayNames[n];
                    break;
                }
                ++n;
            }
            int style = 74;
            Text valueText = new Text(editGroupComp, style);
            valueText.setLayoutData((Object)new GridData(1812));
            if (lightColor != null) {
                valueText.setBackground(lightColor);
            }
            valueText.setText(value);
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
        editGroupComp.layout();
    }

    private void createEditDatePart(Composite parent, Color color, Calendar srcCal) {
        Composite dateComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.verticalSpacing = 1;
        gl.horizontalSpacing = 1;
        dateComp.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        dateComp.setLayoutData((Object)gd);
        dateComp.setBackground(color);
        Combo monthCombo = new Combo(dateComp, 8);
        monthCombo.setLayoutData((Object)new GridData(4));
        String[] monthString = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        monthCombo.setItems(monthString);
        monthCombo.select(srcCal.get(2));
        monthCombo.setData((Object)srcCal);
        monthCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                try {
                    Calendar cal = (Calendar)combo.getData();
                    cal.set(2, combo.getSelectionIndex());
                }
                catch (Exception exception) {}
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Combo dayCombo = new Combo(dateComp, 8);
        dayCombo.setLayoutData((Object)new GridData(4));
        String[] dayString = new String[31];
        int i = 0;
        while (i < 31) {
            dayString[i] = String.valueOf(i + 1);
            ++i;
        }
        dayCombo.setItems(dayString);
        dayCombo.select(srcCal.get(5) - 1);
        dayCombo.setData((Object)srcCal);
        dayCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                try {
                    Calendar cal = (Calendar)combo.getData();
                    cal.set(5, combo.getSelectionIndex() + 1);
                }
                catch (Exception exception) {}
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Text yearText = new Text(dateComp, 2048);
        yearText.setLayoutData((Object)new GridData());
        yearText.setEditable(true);
        yearText.setText(String.valueOf(srcCal.get(1)));
        yearText.setData((Object)srcCal);
        yearText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
                if (e.character == '\b' || e.character == '\u007f') {
                    return;
                }
                String numberCharacters = "0123456789";
                if (numberCharacters.indexOf(Character.toString(e.character)) == -1) {
                    e.doit = false;
                }
            }
        });
        yearText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                try {
                    String year = text.getText();
                    int value = Integer.valueOf(year);
                    Calendar cal = (Calendar)text.getData();
                    cal.set(1, value);
                }
                catch (Exception exception) {}
            }
        });
    }

    private void createReadDatePart(Composite parent, Color color, Calendar srcCal) {
        String value = "";
        if (srcCal != null) {
            SimpleDateFormat myformat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = srcCal.getTime();
            value = myformat.format(date);
        }
        this.createReadStringPart(parent, color, value);
    }

    private void createEditStringMultiPart(Composite parent, Color color, ArrayList<String> al) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(1808));
        if (color != null) {
            comp.setBackground(color);
        }
        Table table = new Table(comp, 68352);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        TableColumn tc = new TableColumn(table, 16384, 0);
        tc.setText("");
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                Rectangle r = table.getClientArea();
                TableColumn[] col = table.getColumns();
                if (col.length > 0) {
                    col[0].setWidth(r.width);
                }
            }
        });
        int n = 0;
        while (n < al.size()) {
            TableItem item = new TableItem(table, 0);
            item.setText(al.get(n));
            ++n;
        }
        table.setData(al);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Table table = (Table)e.getSource();
                TableItem item = table.getItem(table.getSelectionIndex());
                TextDialog dlg = new TextDialog(table.getShell(), item.getText());
                if (dlg.open() == 0) {
                    item.setText(dlg.getValue());
                    ArrayList al = (ArrayList)table.getData();
                    al.remove(table.getSelectionIndex());
                    al.add(table.getSelectionIndex(), dlg.getValue());
                }
            }
        });
        Composite actioncomp = new Composite(comp, 0);
        GridLayout gl2 = new GridLayout(1, false);
        gl2.verticalSpacing = 1;
        actioncomp.setLayout((Layout)gl2);
        actioncomp.setLayoutData((Object)new GridData(1040));
        if (color != null) {
            actioncomp.setBackground(color);
        }
        Button addButton = new Button(actioncomp, 8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setText("add");
        if (color != null) {
            addButton.setBackground(color);
        }
        addButton.setData((Object)table);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value;
                Button button = (Button)e.getSource();
                Table table = (Table)button.getData();
                ArrayList al = (ArrayList)table.getData();
                TextDialog dlg = new TextDialog(table.getShell(), "");
                if (dlg.open() == 0 && (value = dlg.getValue()) != null && value.length() > 0) {
                    int index = table.getSelectionIndex();
                    if (++index > 0 && index < table.getItemCount()) {
                        al.add(index, value);
                        TableItem item = new TableItem(table, 0, index);
                        item.setText(value);
                        table.select(index);
                    } else {
                        al.add(value);
                        TableItem item = new TableItem(table, 0);
                        item.setText(value);
                        table.select(table.indexOf(item));
                    }
                }
            }
        });
        Button delButton = new Button(actioncomp, 8);
        delButton.setLayoutData((Object)new GridData(768));
        delButton.setText("del");
        if (color != null) {
            delButton.setBackground(color);
        }
        delButton.setData((Object)table);
        delButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                Table table = (Table)button.getData();
                ArrayList al = (ArrayList)table.getData();
                int index = table.getSelectionIndex();
                al.remove(index);
                table.remove(index);
            }
        });
        Button upButton = new Button(actioncomp, 8);
        upButton.setLayoutData((Object)new GridData(768));
        upButton.setText("up");
        if (color != null) {
            upButton.setBackground(color);
        }
        upButton.setData((Object)table);
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                Table table = (Table)button.getData();
                ArrayList al = (ArrayList)table.getData();
                int index = table.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                TableItem item = table.getItem(index);
                String data = item.getText();
                int pos = index - 1;
                if (pos >= 0) {
                    al.remove(index);
                    table.remove(index);
                    al.add(pos, data);
                    TableItem newItem = new TableItem(table, 0, pos);
                    newItem.setText(data);
                    table.select(pos);
                }
            }
        });
        Button downButton = new Button(actioncomp, 8);
        downButton.setLayoutData((Object)new GridData(768));
        downButton.setText("down");
        if (color != null) {
            downButton.setBackground(color);
        }
        downButton.setData((Object)table);
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                Table table = (Table)button.getData();
                ArrayList al = (ArrayList)table.getData();
                int index = table.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                TableItem item = table.getItem(index);
                String data = item.getText();
                if (index < table.getItemCount() - 1) {
                    int pos = index + 1;
                    al.remove(index);
                    table.remove(index);
                    if (pos > 0 && pos < table.getItemCount()) {
                        al.add(pos, data);
                        TableItem newItem = new TableItem(table, 0, pos);
                        newItem.setText(data);
                        table.select(pos);
                    } else {
                        al.add(data);
                        TableItem newItem = new TableItem(table, 0);
                        newItem.setText(data);
                        table.select(table.indexOf(newItem));
                    }
                }
            }
        });
    }

    private void createEditStringPart(Composite parent, Color color, String fieldName, Hashtable<String, Object> outHT, boolean isWide) {
        GridData gd = new GridData(772);
        int style = 0;
        if (isWide) {
            style = 2626;
            gd.heightHint = 100;
        } else {
            style = 2048;
        }
        Text valueText = new Text(parent, style);
        valueText.setLayoutData((Object)gd);
        valueText.setEditable(true);
        String value = (String)outHT.get(fieldName);
        valueText.setText(value);
        valueText.setData("fieldName", (Object)fieldName);
        valueText.setData("outHT", outHT);
        valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                String fieldName = (String)text.getData("fieldName");
                Hashtable outHT = (Hashtable)text.getData("outHT");
                outHT.put(fieldName, text.getText());
            }
        });
    }

    private void createReadStringPart(Composite parent, Color color, String srcValue) {
        GridData gd = new GridData(1812);
        int style = 0;
        if (srcValue.length() > 128) {
            style = 586;
            gd.heightHint = 100;
            color = null;
        } else {
            style = 74;
        }
        Text valueText = new Text(parent, style);
        valueText.setLayoutData((Object)gd);
        if (color != null) {
            valueText.setBackground(color);
        }
        valueText.setText(srcValue);
    }

    private void createFileDownloadRuleArea(Composite parent, String value, XooNIpsItemType xnpItemType, String fieldName, Hashtable<String, Object> outHT) {
        Composite editGroupComp = this.createField(parent, xnpItemType, fieldName);
        if (fieldName.equals("detail_field.attachment_dl_limit")) {
            try {
                outHT.put(fieldName, value);
                Button button0 = new Button(editGroupComp, 16);
                button0.setData("outHT", outHT);
                button0.setData("fieldName", (Object)fieldName);
                button0.setText("Everyone");
                button0.setSelection(value.equals("0"));
                button0.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button button = (Button)e.getSource();
                        if (button.getSelection()) {
                            Hashtable outHT = (Hashtable)button.getData("outHT");
                            String fieldName = (String)button.getData("fieldName");
                            outHT.put(fieldName, "0");
                        }
                    }
                });
                Button button1 = new Button(editGroupComp, 16);
                button1.setData("outHT", outHT);
                button1.setData("fieldName", (Object)fieldName);
                button1.setText("Login User");
                button1.setSelection(value.equals("1"));
                button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button button = (Button)e.getSource();
                        if (button.getSelection()) {
                            Hashtable outHT = (Hashtable)button.getData("outHT");
                            String fieldName = (String)button.getData("fieldName");
                            outHT.put(fieldName, "1");
                        }
                    }
                });
            }
            catch (Exception excp) {
                excp.printStackTrace();
            }
        } else if (fieldName.equals("detail_field.attachment_dl_notify")) {
            try {
                outHT.put(fieldName, value);
                Button button0 = new Button(editGroupComp, 16);
                button0.setData("outHT", outHT);
                button0.setData("fieldName", (Object)fieldName);
                button0.setText("No");
                button0.setSelection(value.equals("0"));
                button0.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button button = (Button)e.getSource();
                        if (button.getSelection()) {
                            Hashtable outHT = (Hashtable)button.getData("outHT");
                            String fieldName = (String)button.getData("fieldName");
                            outHT.put(fieldName, "0");
                        }
                    }
                });
                Button button1 = new Button(editGroupComp, 16);
                button1.setData("outHT", outHT);
                button1.setData("fieldName", (Object)fieldName);
                button1.setText("Yes");
                button1.setSelection(value.equals("1"));
                button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button button = (Button)e.getSource();
                        if (button.getSelection()) {
                            Hashtable outHT = (Hashtable)button.getData("outHT");
                            String fieldName = (String)button.getData("fieldName");
                            outHT.put(fieldName, "1");
                        }
                    }
                });
            }
            catch (Exception excp) {
                excp.printStackTrace();
            }
        }
        editGroupComp.layout();
    }

    private void createReadFileDownloadRuleArea(Composite parent, String value, XooNIpsItemType xnpItemType, String fieldName) {
        Composite editGroupComp = this.createField(parent, xnpItemType, fieldName);
        Color lightColor = XoonipsLink2Plugin.newColor(null, 233, 233, 233);
        if (fieldName.equals("detail_field.attachment_dl_limit")) {
            try {
                value = value.equals("0") ? "Everyone" : "Login User";
                this.createReadStringPart(editGroupComp, lightColor, value);
            }
            catch (Exception excp) {
                excp.printStackTrace();
            }
        } else if (fieldName.equals("detail_field.attachment_dl_notify")) {
            try {
                value = value.equals("0") ? "No" : "Yes";
                this.createReadStringPart(editGroupComp, lightColor, value);
            }
            catch (Exception excp) {
                excp.printStackTrace();
            }
        }
        editGroupComp.layout();
    }

    private void createRightsArea(Composite parent, String rightsStr, String useccStr, String cccommercialuseStr, String ccmodificationStr, XooNIpsItemType xnpItemType, Hashtable<String, Object> outHT) {
        Composite editGroupComp = this.createField(parent, xnpItemType, "detail_field.rights");
        Color lightColor = XoonipsLink2Plugin.newColor(null, 233, 233, 233);
        outHT.put("detail_field.use_cc", useccStr);
        Button SomeRightsReservedButton = new Button(editGroupComp, 16);
        SomeRightsReservedButton.setText("Some rights reserved");
        SomeRightsReservedButton.setSelection(useccStr.equals("1"));
        SomeRightsReservedButton.setLayoutData((Object)new GridData(768));
        SomeRightsReservedButton.setData(outHT);
        SomeRightsReservedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    Hashtable outHT = (Hashtable)button.getData();
                    outHT.put("detail_field.use_cc", "1");
                }
            }
        });
        Composite ccComp = new Composite(editGroupComp, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 30;
        gl.marginHeight = 5;
        ccComp.setLayout((Layout)gl);
        ccComp.setLayoutData((Object)new GridData(1808));
        ccComp.setBackground(lightColor);
        Label label = new Label(ccComp, 0);
        label.setText("Allow commercial uses of your resource?");
        label.setBackground(lightColor);
        Composite commercialuseComp = new Composite(ccComp, 0);
        GridLayout gl2 = new GridLayout(1, false);
        gl2.marginWidth = 20;
        gl2.marginHeight = 0;
        commercialuseComp.setLayout((Layout)gl2);
        commercialuseComp.setLayoutData((Object)new GridData(1808));
        commercialuseComp.setBackground(lightColor);
        outHT.put("detail_field.cc_commercial_use", cccommercialuseStr);
        Button yesButton = new Button(commercialuseComp, 16);
        yesButton.setText("Yes");
        yesButton.setSelection(cccommercialuseStr.equals("1"));
        yesButton.setLayoutData((Object)new GridData(768));
        yesButton.setData(outHT);
        yesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    Hashtable outHT = (Hashtable)button.getData();
                    outHT.put("detail_field.cc_commercial_use", "1");
                }
            }
        });
        Button noButton = new Button(commercialuseComp, 16);
        noButton.setText("No");
        noButton.setSelection(cccommercialuseStr.equals("0"));
        noButton.setLayoutData((Object)new GridData(768));
        noButton.setData(outHT);
        noButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    Hashtable outHT = (Hashtable)button.getData();
                    outHT.put("detail_field.cc_commercial_use", "0");
                }
            }
        });
        Label label2 = new Label(ccComp, 0);
        label2.setText("Allow modifications of your resource?");
        label2.setBackground(lightColor);
        Composite modificationComp = new Composite(ccComp, 0);
        GridLayout gl3 = new GridLayout(1, false);
        gl3.marginWidth = 20;
        gl3.marginHeight = 0;
        modificationComp.setLayout((Layout)gl3);
        modificationComp.setLayoutData((Object)new GridData(1808));
        modificationComp.setBackground(lightColor);
        outHT.put("detail_field.cc_modification", ccmodificationStr);
        Button yesButton2 = new Button(modificationComp, 16);
        yesButton2.setText("Yes");
        yesButton2.setSelection(ccmodificationStr.equals("2"));
        yesButton2.setLayoutData((Object)new GridData(768));
        yesButton2.setData(outHT);
        yesButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    Hashtable outHT = (Hashtable)button.getData();
                    outHT.put("detail_field.cc_modification", "2");
                }
            }
        });
        Button shareButton = new Button(modificationComp, 16);
        shareButton.setText("Yes, as long as others share alike");
        shareButton.setSelection(ccmodificationStr.equals("1"));
        shareButton.setLayoutData((Object)new GridData(768));
        shareButton.setData(outHT);
        shareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    Hashtable outHT = (Hashtable)button.getData();
                    outHT.put("detail_field.cc_modification", "1");
                }
            }
        });
        Button noButton2 = new Button(modificationComp, 16);
        noButton2.setText("No");
        noButton2.setSelection(ccmodificationStr.equals("0"));
        noButton2.setLayoutData((Object)new GridData(768));
        noButton2.setData(outHT);
        noButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    Hashtable outHT = (Hashtable)button.getData();
                    outHT.put("detail_field.cc_modification", "0");
                }
            }
        });
        Button AllrightsReservedButton = new Button(editGroupComp, 16);
        AllrightsReservedButton.setText("All rights reserved");
        AllrightsReservedButton.setSelection(useccStr.equals("0"));
        AllrightsReservedButton.setLayoutData((Object)new GridData(768));
        AllrightsReservedButton.setData(outHT);
        AllrightsReservedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    Hashtable outHT = (Hashtable)button.getData();
                    outHT.put("detail_field.use_cc", "0");
                }
            }
        });
        Composite rightsComp = new Composite(editGroupComp, 0);
        GridLayout gl4 = new GridLayout(1, false);
        gl4.marginWidth = 30;
        gl4.marginHeight = 0;
        rightsComp.setLayout((Layout)gl4);
        rightsComp.setLayoutData((Object)new GridData(1808));
        rightsComp.setBackground(lightColor);
        outHT.put("detail_field.rights", rightsStr);
        String rights = rightsStr;
        int style = 0;
        GridData gd = new GridData(772);
        style = 2626;
        gd.heightHint = 100;
        Text rightsText = new Text(rightsComp, style);
        rightsText.setLayoutData((Object)gd);
        rightsText.setEditable(true);
        rightsText.setText(rights);
        rightsText.setData(outHT);
        rightsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                Hashtable outHT = (Hashtable)text.getData();
                outHT.put("detail_field.rights", text.getText());
            }
        });
    }

    private void createChangeFileArea(Composite parent, XnpFileData xnpFileData, XooNIpsItemType xnpItemType, String fieldName, Hashtable<String, Object> outHT) {
        Composite editGroupComp = this.createField(parent, xnpItemType, fieldName);
        Color lightColor = XoonipsLink2Plugin.newColor(null, 233, 233, 233);
        try {
            if (xnpFileData == null) {
                xnpFileData = new XnpFileData();
            }
            outHT.put(fieldName, xnpFileData);
            this.createChangeFilePart(editGroupComp, lightColor, xnpItemType.isRequired(fieldName), xnpFileData);
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
        editGroupComp.layout();
    }

    private void createChangeFilePart(Composite parent, Color color, boolean isRequired, XnpFileData xnpFileData) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(768));
        if (color != null) {
            composite.setBackground(color);
        }
        Button button = new Button(composite, 8);
        if (isRequired) {
            button.setText("Select File");
        } else if (xnpFileData.oldFiles.size() == 0) {
            button.setText("Select File");
        } else {
            button.setText("Delete File");
        }
        button.setData("XnpFileData", (Object)xnpFileData);
        if (isRequired) {
            button.setData("isRequired", (Object)"true");
        } else {
            button.setData("isRequired", (Object)"false");
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Button button = (Button)e.getSource();
                    XnpFileData xnpFileData = (XnpFileData)button.getData("XnpFileData");
                    String isRequired = (String)button.getData("isRequired");
                    Label label = (Label)button.getData("Label");
                    if (isRequired.equals("true")) {
                        FileDialog dialog = new FileDialog(UploadNewXooNIpsItemDialog.this.detailComposite.getShell(), 4096);
                        String path = dialog.open();
                        if (path != null) {
                            long maxFileSize = UploadNewXooNIpsItemDialog.this.xoonipsConnection.getXooNIpsSession().getMaximumFileSize();
                            File file = new File(path);
                            if ((maxFileSize *= 1000L) >= file.length()) {
                                XooNIpsFile o = null;
                                if (xnpFileData.oldFiles.size() > 0) {
                                    xnpFileData.oldFiles.get(0);
                                }
                                if (o == null && xnpFileData.newFiles.size() > 0) {
                                    xnpFileData.newFiles.get(0);
                                }
                                if (o != null) {
                                    xnpFileData.delete(o);
                                }
                                xnpFileData.addNew(new XooNIpsFile(file, file.getName()));
                                label.setText(file.getName());
                            } else {
                                MessageDialog.openWarning((Shell)UploadNewXooNIpsItemDialog.this.detailComposite.getShell(), (String)"File", (String)"The file size is too big to upload.");
                            }
                        }
                    } else if (button.getText().equals("Delete File")) {
                        boolean ans = MessageDialog.openQuestion((Shell)UploadNewXooNIpsItemDialog.this.detailComposite.getShell(), (String)"Delete File", (String)"May I delete a file from this item?");
                        if (ans) {
                            XooNIpsFile o = null;
                            if (xnpFileData.oldFiles.size() > 0) {
                                xnpFileData.oldFiles.get(0);
                            }
                            if (o == null && xnpFileData.newFiles.size() > 0) {
                                xnpFileData.newFiles.get(0);
                            }
                            if (o != null) {
                                xnpFileData.delete(o);
                            }
                            label.setText("");
                            button.setText("Select File");
                        }
                    } else {
                        FileDialog dialog = new FileDialog(UploadNewXooNIpsItemDialog.this.detailComposite.getShell(), 4096);
                        String path = dialog.open();
                        if (path != null) {
                            File file = new File(path);
                            long maxFileSize = UploadNewXooNIpsItemDialog.this.xoonipsConnection.getXooNIpsSession().getMaximumFileSize();
                            if ((maxFileSize *= 1000L) >= file.length()) {
                                xnpFileData.addNew(new XooNIpsFile(file, file.getName()));
                                label.setText(file.getName());
                                button.setText("Delete File");
                            } else {
                                MessageDialog.openWarning((Shell)UploadNewXooNIpsItemDialog.this.detailComposite.getShell(), (String)"File", (String)"The file size is too big to upload.");
                            }
                        }
                    }
                }
                catch (XooNIpsException xooNIpsException) {
                }
                catch (Exception exception) {}
            }
        });
        Label filenameLabel = new Label(composite, 0);
        filenameLabel.setLayoutData((Object)new GridData(768));
        if (xnpFileData.oldFiles.size() == 0) {
            filenameLabel.setText("");
        } else {
            String filename = "";
            XooNIpsFile xnpFile = xnpFileData.oldFiles.get(0);
            try {
                filename = xnpFile.getFileName();
            }
            catch (Exception exception) {}
            filenameLabel.setText(filename);
        }
        if (color != null) {
            filenameLabel.setBackground(color);
        }
        button.setData("Label", (Object)filenameLabel);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        boolean success;
        if (buttonId == 0 && this.dstXnpItemType != null && !(success = this.UploadNewXooNIpsItem(this.dstXnpItemType, this.controlDataHT))) {
            return;
        }
        this.setReturnCode(buttonId);
        this.close();
        super.buttonPressed(buttonId);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean UploadNewXooNIpsItem(XooNIpsItemType xnpItemType, Hashtable<String, Object> outHT) {
        block66: {
            block65: {
                newXnpItem = xnpItemType.getInstance();
                fieldNames = xnpItemType.getFieldNames();
                i = 0;
                while (i < fieldNames.length) {
                    fieldName = fieldNames[i];
                    if (xnpItemType.isMultiple(fieldName)) {
                        if (fieldName.equals("indexes")) {
                            indexes = new int[this.dstXnpIndexArrayList.size()];
                            j = 0;
                            while (j < this.dstXnpIndexArrayList.size()) {
                                xnpIndex = this.dstXnpIndexArrayList.get(j);
                                indexes[j] = xnpIndex.getIndexNo();
                                ++j;
                            }
                            newXnpItem.setIndexes(indexes);
                        }
                        if (xnpItemType.getFieldType(fieldName).equals("STRING") && (obj = outHT.get(fieldName)) != null) {
                            if (obj instanceof String) {
                                dst = (String)obj;
                                newXnpItem.addValue(fieldName, dst);
                            } else if (obj instanceof ArrayList) {
                                al = (ArrayList)obj;
                                n = 0;
                                while (n < al.size()) {
                                    dst = (String)al.get(n);
                                    newXnpItem.addValue(fieldName, dst);
                                    ++n;
                                }
                            }
                        }
                    } else if (xnpItemType.getFieldType(fieldName).equals("STRING")) {
                        obj = outHT.get(fieldName);
                        if (obj != null) {
                            if (obj instanceof String) {
                                dst = (String)obj;
                                newXnpItem.addValue(fieldName, dst);
                            } else if (obj instanceof ArrayList) {
                                al = (ArrayList)obj;
                                n = 0;
                                while (n < al.size()) {
                                    dst = (String)al.get(n);
                                    newXnpItem.addValue(fieldName, dst);
                                    ++n;
                                }
                            }
                        }
                    } else if (xnpItemType.getFieldType(fieldName).equals("DATE")) {
                        obj = outHT.get(fieldName);
                        if (obj != null) {
                            dstCal = null;
                            if (obj instanceof String) {
                                dst = (String)obj;
                                dstCal = this.StringToCalendar(dst);
                            } else if (obj instanceof Calendar) {
                                dstCal = (Calendar)obj;
                            }
                            if (dstCal != null) {
                                newXnpItem.putDateValue(fieldName, dstCal);
                            }
                        }
                    } else if (xnpItemType.getFieldType(fieldName).equals("FILE") && (obj = outHT.get(fieldName)) != null && obj instanceof XnpFileData) {
                        dstXnpFileData = (XnpFileData)obj;
                        j = 0;
                        while (j < dstXnpFileData.newFiles.size()) {
                            newXnpItem.addFile(fieldName, dstXnpFileData.newFiles.get(j));
                            ++j;
                        }
                    }
                    ++i;
                }
                notDefinedFields = new StringBuffer();
                xoonipsItemCheck = true;
                requiredFields = xnpItemType.getRequiredFields();
                n = 0;
                while (n < requiredFields.length) {
                    fieldName = requiredFields[n];
                    if (xnpItemType.getFieldType(fieldName).equals("STRING")) {
                        if (fieldName.equals("indexes")) {
                            indexes = newXnpItem.getIndexes();
                            if (indexes == null) {
                                if (notDefinedFields.length() > 0) {
                                    notDefinedFields.append(", ");
                                }
                                notDefinedFields.append(xnpItemType.getDisplayName(fieldName));
                                System.out.println("Not defined:" + fieldName);
                                xoonipsItemCheck = false;
                            } else if (indexes.length == 0) {
                                if (notDefinedFields.length() > 0) {
                                    notDefinedFields.append(", ");
                                }
                                notDefinedFields.append(xnpItemType.getDisplayName(fieldName));
                                System.out.println("Not defined:" + fieldName);
                                xoonipsItemCheck = false;
                            }
                        } else if (!fieldName.equals("itemtype") && !fieldName.equals("related_to")) {
                            try {
                                value = newXnpItem.getValue(fieldName, 0);
                                if (value.length() == 0) {
                                    if (notDefinedFields.length() > 0) {
                                        notDefinedFields.append(", ");
                                    }
                                    notDefinedFields.append(xnpItemType.getDisplayName(fieldName));
                                    System.out.println("Not defined:" + fieldName);
                                    xoonipsItemCheck = false;
                                }
                            }
                            catch (Exception v0) {
                                if (notDefinedFields.length() > 0) {
                                    notDefinedFields.append(", ");
                                }
                                notDefinedFields.append(xnpItemType.getDisplayName(fieldName));
                                System.out.println("Not defined:" + fieldName);
                                xoonipsItemCheck = false;
                            }
                        }
                    } else if (xnpItemType.getFieldType(fieldName).equals("DATE")) {
                        try {
                            value = newXnpItem.getDateValue(fieldName);
                            if (value == null) {
                                if (notDefinedFields.length() > 0) {
                                    notDefinedFields.append(", ");
                                }
                                notDefinedFields.append(xnpItemType.getDisplayName(fieldName));
                                System.out.println("Not defined:" + fieldName);
                                xoonipsItemCheck = false;
                            }
                        }
                        catch (Exception v1) {
                            if (notDefinedFields.length() > 0) {
                                notDefinedFields.append(", ");
                            }
                            notDefinedFields.append(xnpItemType.getDisplayName(fieldName));
                            System.out.println("Not defined:" + fieldName);
                            xoonipsItemCheck = false;
                        }
                    } else if (xnpItemType.getFieldType(fieldName).equals("FILE")) {
                        try {
                            if (newXnpItem.getCount(fieldName) > 0) {
                                xnpFile = newXnpItem.getFile(fieldName, 0);
                                if (xnpFile == null) {
                                    if (notDefinedFields.length() > 0) {
                                        notDefinedFields.append(", ");
                                    }
                                    notDefinedFields.append(xnpItemType.getDisplayName(fieldName));
                                    System.out.println("Not defined:" + fieldName);
                                    xoonipsItemCheck = false;
                                }
                            } else {
                                if (notDefinedFields.length() > 0) {
                                    notDefinedFields.append(", ");
                                }
                                notDefinedFields.append(xnpItemType.getDisplayName(fieldName));
                                System.out.println("Not defined:" + fieldName);
                                xoonipsItemCheck = false;
                            }
                        }
                        catch (Exception v2) {
                            if (notDefinedFields.length() > 0) {
                                notDefinedFields.append(", ");
                            }
                            notDefinedFields.append(xnpItemType.getDisplayName(fieldName));
                            System.out.println("Not defined:" + fieldName);
                            xoonipsItemCheck = false;
                        }
                    }
                    ++n;
                }
                if (xoonipsItemCheck.booleanValue()) break block65;
                MessageDialog.openError((Shell)this.detailComposite.getShell(), (String)"Upload of XooNIpsItem failed", (String)("Please input " + notDefinedFields.toString()));
                return false;
            }
            xoonipsItemCheck = newXnpItem.isReadyToSend();
            if (xoonipsItemCheck.booleanValue()) break block66;
            System.out.println("isReadyToSend:" + xoonipsItemCheck);
            MessageDialog.openError((Shell)this.detailComposite.getShell(), (String)"Upload of New Item failed", (String)"Fail");
            return false;
        }
        try {
            this.xoonipsConnection.getXooNIpsSession().putXooNIpsItem(newXnpItem, false);
            return true;
        }
        catch (XooNIpsException excp) {
            if (excp.getMessage() != "Error Server Returns Fault") return false;
            count = excp.countMessage();
            n = 0;
            ** while (n < count)
        }
lbl-1000:
        // 1 sources

        {
            msg = "";
            msg = excp.getCode(n) == 103 ? "Error Server Returns Fault:(ACCESS FORBIDDEN):" + excp.getMessage(n) : (excp.getCode(n) == 105 ? "Error Server Returns Fault:(INCOMPLETE_PARAM):" + excp.getMessage(n) : "Error Server Returns Fault:(" + excp.getCode(n) + "):" + excp.getMessage(n));
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Error:Upload of New Item failed", (String)msg);
            System.err.println(String.valueOf(excp.getCode(n)) + ":" + excp.getMessage(n));
            ++n;
            continue;
lbl201:
            // 1 sources

            return false;
        }
        catch (Exception v3) {}
        return false;
    }

    private Calendar StringToCalendar(String value) {
        GregorianCalendar srcCal = null;
        if (value != null) {
            Date theDay;
            SimpleDateFormat myformat;
            if (srcCal == null) {
                try {
                    myformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    theDay = myformat.parse(value);
                    srcCal = new GregorianCalendar();
                    srcCal.setTime(theDay);
                }
                catch (Exception exception) {}
            }
            if (srcCal == null) {
                try {
                    myformat = new SimpleDateFormat("yyyy-MM-dd");
                    theDay = myformat.parse(value);
                    srcCal = new GregorianCalendar();
                    srcCal.setTime(theDay);
                }
                catch (Exception exception) {}
            }
            if (srcCal == null) {
                try {
                    myformat = new SimpleDateFormat("yyyy-MM");
                    theDay = myformat.parse(value);
                    srcCal = new GregorianCalendar();
                    srcCal.setTime(theDay);
                }
                catch (Exception exception) {}
            }
            if (srcCal == null) {
                try {
                    myformat = new SimpleDateFormat("yyyy");
                    theDay = myformat.parse(value);
                    srcCal = new GregorianCalendar();
                    srcCal.setTime(theDay);
                }
                catch (Exception exception) {}
            }
        }
        return srcCal;
    }

    private void createItemFields(Composite parent, XooNIpsItemType xnpItemType, ArrayList<String> ccgTypeElemNames, Document ccgDataDoc, Element ccgDataElem, Hashtable<String, Object> outHT) {
        String[] fieldNames = xnpItemType.getFieldNames();
        int i = 0;
        while (i < fieldNames.length) {
            block63: {
                String fieldName = fieldNames[i];
                boolean hasOptions = false;
                try {
                    hasOptions = xnpItemType.hasOptions(fieldName);
                }
                catch (XooNIpsException xooNIpsException) {}
                String fieldType = "";
                try {
                    fieldType = xnpItemType.getFieldType(fieldName);
                }
                catch (XooNIpsException xooNIpsException) {}
                boolean readOnly = false;
                try {
                    readOnly = xnpItemType.isReadOnly(fieldName);
                }
                catch (XooNIpsException xooNIpsException) {}
                if (fieldType.equals("STRING")) {
                    if (!(fieldName.equals("item_id") || fieldName.equals("indexes") || fieldName.equals("related_to"))) {
                        if (fieldName.equals("itemtype")) {
                            if (xnpItemType != null) {
                                outHT.put(fieldName, xnpItemType.getTypeName());
                                String value = xnpItemType.getTitle();
                                this.createReadStringArea(parent, value, xnpItemType, fieldName);
                            }
                        } else if (fieldName.equals("username")) {
                            String value = "(" + this.xoonipsConnection.getUserID() + ")";
                            this.createReadStringArea(parent, value, xnpItemType, fieldName);
                        } else if (fieldName.equals("titles")) {
                            ArrayList<String> al = this.getMultiStringWithParser(fieldName, ccgTypeElemNames, ccgDataElem);
                            this.createStringArea(parent, al, xnpItemType, fieldName, outHT);
                        } else if (fieldName.equals("ext_id")) {
                            String value = this.getIdentifiersStringWithParser(ccgTypeElemNames, ccgDataElem, "doi");
                            this.createStringArea(parent, value, xnpItemType, fieldName, outHT);
                        } else if (fieldName.equals("detail_field.pubmed_id")) {
                            String value = this.getIdentifiersStringWithParser(ccgTypeElemNames, ccgDataElem, "pubmed");
                            this.createStringArea(parent, value, xnpItemType, fieldName, outHT);
                        } else if (fieldName.equals("comment")) {
                            ArrayList<String> al = this.getMultiStringWithParser(fieldName, ccgTypeElemNames, ccgDataElem);
                            this.createStringWideArea(parent, al, xnpItemType, fieldName, outHT);
                        } else if (fieldName.equals("detail_field.readme")) {
                            ArrayList<String> al = this.getMultiStringWithParser(fieldName, ccgTypeElemNames, ccgDataElem);
                            this.createStringWideArea(parent, al, xnpItemType, fieldName, outHT);
                        } else if (fieldName.equalsIgnoreCase("detail_field.author") || fieldName.equals("detail_field.creator") || fieldName.equals("detail_field.experimenter") || fieldName.equals("detail_field.developer")) {
                            ArrayList<String> al = this.getAuthorsStringWithParser(ccgTypeElemNames, ccgDataElem);
                            this.createMultiStringArea(parent, al, xnpItemType, fieldName, outHT);
                        } else if (fieldName.equals("detail_field.use_cc")) {
                            String useccStr = "1";
                            String cccommercialuseStr = "1";
                            String ccmodificationStr = "2";
                            String rightsStr = "";
                            this.createRightsArea(parent, rightsStr, useccStr, cccommercialuseStr, ccmodificationStr, xnpItemType, outHT);
                        } else if (!(fieldName.equals("detail_field.rights") || fieldName.equals("detail_field.cc_commercial_use") || fieldName.equals("detail_field.cc_modification"))) {
                            if (fieldName.equals("detail_field.attachment_dl_limit")) {
                                String value = "1";
                                this.createFileDownloadRuleArea(parent, value, xnpItemType, fieldName, outHT);
                            } else if (fieldName.equals("detail_field.attachment_dl_notify")) {
                                String value = "0";
                                this.createFileDownloadRuleArea(parent, value, xnpItemType, fieldName, outHT);
                            } else if (!readOnly) {
                                if (hasOptions) {
                                    ArrayList<String> al = this.getMultiStringWithParser(fieldName, ccgTypeElemNames, ccgDataElem);
                                    String value = "";
                                    if (fieldName.equals("lang")) {
                                        value = "eng";
                                    }
                                    if (al != null && al.size() > 0) {
                                        value = al.get(0);
                                    }
                                    this.createOptionsArea(parent, value, xnpItemType, fieldName, outHT);
                                } else {
                                    ArrayList<String> al = this.getMultiStringWithParser(fieldName, ccgTypeElemNames, ccgDataElem);
                                    try {
                                        if (xnpItemType.isMultiple(fieldName)) {
                                            this.createMultiStringArea(parent, al, xnpItemType, fieldName, outHT);
                                            break block63;
                                        }
                                        this.createStringArea(parent, al, xnpItemType, fieldName, outHT);
                                    }
                                    catch (XooNIpsException xooNIpsException) {}
                                }
                            }
                        }
                    }
                } else if (fieldType.equals("DATE")) {
                    if (fieldName.equals("creation_date")) {
                        long createTime = DomImpl.getCreatedTime((Document)ccgDataDoc);
                        SimpleDateFormat myformat = new SimpleDateFormat("yyyy-MM-dd");
                        String value = myformat.format(createTime);
                        this.createStringArea(parent, value, xnpItemType, fieldName, outHT);
                    } else if (!readOnly) {
                        ArrayList<String> al = this.getMultiStringWithParser(fieldName, ccgTypeElemNames, ccgDataElem);
                        this.createDateArea(parent, al, xnpItemType, fieldName, outHT);
                    }
                } else if (fieldType.equals("FILE")) {
                    if (!fieldName.equals("detail_field.preview")) {
                        XnpFileData xnpFileData = null;
                        if (xnpItemType.getMainFileField().equals(fieldName)) {
                            String filename = DataDomImpl.getFileName((Document)ccgDataDoc);
                            String path = DataDomImpl.getFilePath((Document)ccgDataDoc);
                            if (path.length() == 0) {
                                path = FrameworkPlugin.getPathFromID((long)DomImpl.getID((Document)ccgDataDoc));
                            }
                            File file = null;
                            if (path != null && path.length() > 0) {
                                file = new File(path);
                            }
                            if (filename.length() > 0 && file != null && file.isFile() && file.exists()) {
                                try {
                                    long maxFileSize = this.xoonipsConnection.getXooNIpsSession().getMaximumFileSize();
                                    if ((maxFileSize *= 1000L) >= file.length()) {
                                        xnpFileData = new XnpFileData();
                                        xnpFileData.addNew(new XooNIpsFile(file, filename));
                                    }
                                }
                                catch (XooNIpsException xooNIpsException) {
                                }
                                catch (Exception exception) {}
                            }
                        }
                        this.createChangeFileArea(parent, xnpFileData, xnpItemType, fieldName, outHT);
                    }
                } else if (!readOnly) {
                    ArrayList<String> al = this.getMultiStringWithParser(fieldName, ccgTypeElemNames, ccgDataElem);
                    try {
                        if (xnpItemType.isMultiple(fieldName)) {
                            this.createMultiStringArea(parent, al, xnpItemType, fieldName, outHT);
                        } else {
                            this.createStringArea(parent, al, xnpItemType, fieldName, outHT);
                        }
                    }
                    catch (XooNIpsException xooNIpsException) {}
                }
            }
            ++i;
        }
    }

    private ArrayList<String> getMultiStringWithParser(String xnpFieldName, ArrayList<String> ccgTypeElemNames, Element ccgDataElem) {
        int j = 0;
        while (j < ccgTypeElemNames.size()) {
            String typeElemName = ccgTypeElemNames.get(j);
            String value = null;
            value = xnpFieldName.startsWith("detail_field.") ? xnpFieldName.substring("detail_field.".length(), xnpFieldName.length()) : xnpFieldName;
            if (typeElemName.length() <= value.length()) {
                if (value.toLowerCase().startsWith(typeElemName.toLowerCase())) {
                    Element elem = DataDomImpl.getElement((Element)ccgDataElem, (String)typeElemName);
                    return this.getMultiStringWithParser(elem);
                }
            } else if (typeElemName.toLowerCase().startsWith(value.toLowerCase())) {
                Element elem = DataDomImpl.getElement((Element)ccgDataElem, (String)typeElemName);
                return this.getMultiStringWithParser(elem);
            }
            ++j;
        }
        return null;
    }

    private ArrayList<String> getMultiStringWithParser(Element dataElem) {
        String parsername;
        ITypeParser p;
        if (dataElem != null && (p = FrameworkPlugin.getParser((String)(parsername = DataDomImpl.getParserName((Element)dataElem)))) != null) {
            return p.getMultiText(dataElem);
        }
        return null;
    }

    private ArrayList<String> getAuthorsStringWithParser(ArrayList<String> ccgTypeElemNames, Element ccgDataElem) {
        int j = 0;
        while (j < ccgTypeElemNames.size()) {
            String parsername;
            ITypeParser p;
            String elemName = ccgTypeElemNames.get(j);
            Element elem = DataDomImpl.getElement((Element)ccgDataElem, (String)elemName);
            if (elem != null && (p = FrameworkPlugin.getParser((String)(parsername = DataDomImpl.getParserName((Element)elem)))) != null && p instanceof AuthorsParser) {
                return p.getMultiText(elem);
            }
            ++j;
        }
        return null;
    }

    private String getIdentifiersStringWithParser(ArrayList<String> ccgTypeElemNames, Element ccgDataElem, String option) {
        int j = 0;
        while (j < ccgTypeElemNames.size()) {
            ArrayList al;
            String parsername;
            ITypeParser p;
            String elemName = ccgTypeElemNames.get(j);
            Element elem = DataDomImpl.getElement((Element)ccgDataElem, (String)elemName);
            if (elem != null && (p = FrameworkPlugin.getParser((String)(parsername = DataDomImpl.getParserName((Element)elem)))) != null && p instanceof IdentifiersParser && option != null && option.length() > 0 && (al = p.getIndexValues(elem, option)) != null && al.size() > 0) {
                return (String)al.get(0);
            }
            ++j;
        }
        return null;
    }
}

